/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.server.mock;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.server.mock.KubernetesMockServer;
import io.fabric8.kubernetes.client.utils.HttpClientUtils;
import io.fabric8.mockwebserver.Context;
import io.fabric8.mockwebserver.ServerRequest;
import io.fabric8.mockwebserver.ServerResponse;
import io.fabric8.openshift.client.DefaultOpenShiftClient;
import io.fabric8.openshift.client.NamespacedOpenShiftClient;
import io.fabric8.openshift.client.OpenShiftConfig;
import java.util.Map;
import java.util.Queue;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockWebServer;

public class OpenShiftMockServer
extends KubernetesMockServer {
    private boolean disableApiGroupCheck = true;

    public OpenShiftMockServer() {
    }

    public OpenShiftMockServer(boolean useHttps) {
        super(useHttps);
    }

    public OpenShiftMockServer(Context context, MockWebServer server, Map<ServerRequest, Queue<ServerResponse>> responses, Dispatcher dispatcher, boolean useHttps) {
        super(context, server, responses, dispatcher, useHttps);
    }

    public String[] getRootPaths() {
        return new String[]{"/api", "/oapi"};
    }

    public NamespacedOpenShiftClient createOpenShiftClient() {
        OpenShiftConfig config = OpenShiftConfig.wrap((Config)this.getMockConfiguration());
        config.setDisableApiGroupCheck(this.disableApiGroupCheck);
        return new DefaultOpenShiftClient(HttpClientUtils.createHttpClientForMockServer((Config)config), config);
    }

    public boolean isDisableApiGroupCheck() {
        return this.disableApiGroupCheck;
    }

    public void setDisableApiGroupCheck(boolean disableApiGroupCheck) {
        this.disableApiGroupCheck = disableApiGroupCheck;
    }
}

