/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.servicecatalog.client;

import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.ClientContext;
import io.fabric8.kubernetes.client.ExtensionAdapter;
import io.fabric8.kubernetes.client.ExtensionAdapterSupport;
import io.fabric8.kubernetes.client.Handlers;
import io.fabric8.servicecatalog.api.model.ClusterServiceBroker;
import io.fabric8.servicecatalog.api.model.ClusterServiceClass;
import io.fabric8.servicecatalog.api.model.ClusterServicePlan;
import io.fabric8.servicecatalog.api.model.ServiceBinding;
import io.fabric8.servicecatalog.api.model.ServiceInstance;
import io.fabric8.servicecatalog.client.DefaultServiceCatalogClient;
import io.fabric8.servicecatalog.client.ServiceCatalogClient;
import io.fabric8.servicecatalog.client.internal.ClusterServiceBrokerOperationsImpl;
import io.fabric8.servicecatalog.client.internal.ClusterServiceClassOperationsImpl;
import io.fabric8.servicecatalog.client.internal.ClusterServicePlanOperationsImpl;
import io.fabric8.servicecatalog.client.internal.ServiceBindingOperationsImpl;
import io.fabric8.servicecatalog.client.internal.ServiceInstanceOperationsImpl;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ServiceCatalogExtensionAdapter
extends ExtensionAdapterSupport
implements ExtensionAdapter<ServiceCatalogClient> {
    static final ConcurrentMap<URL, Boolean> IS_SERVICE_CATALOG = new ConcurrentHashMap<URL, Boolean>();
    static final ConcurrentMap<URL, Boolean> USES_SERVICE_CATALOG_APIGROUPS = new ConcurrentHashMap<URL, Boolean>();

    public Class<ServiceCatalogClient> getExtensionType() {
        return ServiceCatalogClient.class;
    }

    public Boolean isAdaptable(Client client) {
        return this.isAdaptable(client, IS_SERVICE_CATALOG, USES_SERVICE_CATALOG_APIGROUPS, "servicecatalog.k8s.io");
    }

    public ServiceCatalogClient adapt(Client client) {
        return new DefaultServiceCatalogClient((ClientContext)client);
    }

    static {
        Handlers.register(ClusterServiceBroker.class, ClusterServiceBrokerOperationsImpl::new);
        Handlers.register(ClusterServiceClass.class, ClusterServiceClassOperationsImpl::new);
        Handlers.register(ClusterServicePlan.class, ClusterServicePlanOperationsImpl::new);
        Handlers.register(ServiceBinding.class, ServiceBindingOperationsImpl::new);
        Handlers.register(ServiceInstance.class, ServiceInstanceOperationsImpl::new);
    }
}

