/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.servicecatalog.api.model.ServiceBinding;
import io.fabric8.servicecatalog.api.model.ServiceBindingFluent;
import io.fabric8.servicecatalog.api.model.ServiceBindingFluentImpl;
import java.util.Objects;

public class ServiceBindingBuilder
extends ServiceBindingFluentImpl<ServiceBindingBuilder>
implements VisitableBuilder<ServiceBinding, ServiceBindingBuilder> {
    ServiceBindingFluent<?> fluent;
    Boolean validationEnabled;

    public ServiceBindingBuilder() {
        this(false);
    }

    public ServiceBindingBuilder(Boolean validationEnabled) {
        this(new ServiceBinding(), validationEnabled);
    }

    public ServiceBindingBuilder(ServiceBindingFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ServiceBindingBuilder(ServiceBindingFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ServiceBinding(), validationEnabled);
    }

    public ServiceBindingBuilder(ServiceBindingFluent<?> fluent, ServiceBinding instance) {
        this(fluent, instance, false);
    }

    public ServiceBindingBuilder(ServiceBindingFluent<?> fluent, ServiceBinding instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public ServiceBindingBuilder(ServiceBinding instance) {
        this(instance, (Boolean)false);
    }

    public ServiceBindingBuilder(ServiceBinding instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public ServiceBinding build() {
        ServiceBinding buildable = new ServiceBinding(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceBindingBuilder that = (ServiceBindingBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

