package io.fabric8.servicecatalog.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ServiceBrokerAuthInfoFluent<A extends ServiceBrokerAuthInfoFluent<A>> extends BaseFluent<A>{
  public ServiceBrokerAuthInfoFluent() {
  }
  
  public ServiceBrokerAuthInfoFluent(ServiceBrokerAuthInfo instance) {
    this.copyInstance(instance);
  }
  private BasicAuthConfigBuilder basic;
  private BearerTokenAuthConfigBuilder bearer;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ServiceBrokerAuthInfo instance) {
    instance = (instance != null ? instance : new ServiceBrokerAuthInfo());
    if (instance != null) {
          this.withBasic(instance.getBasic());
          this.withBearer(instance.getBearer());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public BasicAuthConfig buildBasic() {
    return this.basic != null ? this.basic.build() : null;
  }
  
  public A withBasic(BasicAuthConfig basic) {
    this._visitables.remove("basic");
    if (basic != null) {
        this.basic = new BasicAuthConfigBuilder(basic);
        this._visitables.get("basic").add(this.basic);
    } else {
        this.basic = null;
        this._visitables.get("basic").remove(this.basic);
    }
    return (A) this;
  }
  
  public boolean hasBasic() {
    return this.basic != null;
  }
  
  public BasicNested<A> withNewBasic() {
    return new BasicNested(null);
  }
  
  public BasicNested<A> withNewBasicLike(BasicAuthConfig item) {
    return new BasicNested(item);
  }
  
  public BasicNested<A> editBasic() {
    return withNewBasicLike(java.util.Optional.ofNullable(buildBasic()).orElse(null));
  }
  
  public BasicNested<A> editOrNewBasic() {
    return withNewBasicLike(java.util.Optional.ofNullable(buildBasic()).orElse(new BasicAuthConfigBuilder().build()));
  }
  
  public BasicNested<A> editOrNewBasicLike(BasicAuthConfig item) {
    return withNewBasicLike(java.util.Optional.ofNullable(buildBasic()).orElse(item));
  }
  
  public BearerTokenAuthConfig buildBearer() {
    return this.bearer != null ? this.bearer.build() : null;
  }
  
  public A withBearer(BearerTokenAuthConfig bearer) {
    this._visitables.remove("bearer");
    if (bearer != null) {
        this.bearer = new BearerTokenAuthConfigBuilder(bearer);
        this._visitables.get("bearer").add(this.bearer);
    } else {
        this.bearer = null;
        this._visitables.get("bearer").remove(this.bearer);
    }
    return (A) this;
  }
  
  public boolean hasBearer() {
    return this.bearer != null;
  }
  
  public BearerNested<A> withNewBearer() {
    return new BearerNested(null);
  }
  
  public BearerNested<A> withNewBearerLike(BearerTokenAuthConfig item) {
    return new BearerNested(item);
  }
  
  public BearerNested<A> editBearer() {
    return withNewBearerLike(java.util.Optional.ofNullable(buildBearer()).orElse(null));
  }
  
  public BearerNested<A> editOrNewBearer() {
    return withNewBearerLike(java.util.Optional.ofNullable(buildBearer()).orElse(new BearerTokenAuthConfigBuilder().build()));
  }
  
  public BearerNested<A> editOrNewBearerLike(BearerTokenAuthConfig item) {
    return withNewBearerLike(java.util.Optional.ofNullable(buildBearer()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ServiceBrokerAuthInfoFluent that = (ServiceBrokerAuthInfoFluent) o;
    if (!java.util.Objects.equals(basic, that.basic)) return false;
    if (!java.util.Objects.equals(bearer, that.bearer)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(basic,  bearer,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (basic != null) { sb.append("basic:"); sb.append(basic + ","); }
    if (bearer != null) { sb.append("bearer:"); sb.append(bearer + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class BasicNested<N> extends BasicAuthConfigFluent<BasicNested<N>> implements Nested<N>{
    BasicNested(BasicAuthConfig item) {
      this.builder = new BasicAuthConfigBuilder(this, item);
    }
    BasicAuthConfigBuilder builder;
    
    public N and() {
      return (N) ServiceBrokerAuthInfoFluent.this.withBasic(builder.build());
    }
    
    public N endBasic() {
      return and();
    }
    
  
  }
  public class BearerNested<N> extends BearerTokenAuthConfigFluent<BearerNested<N>> implements Nested<N>{
    BearerNested(BearerTokenAuthConfig item) {
      this.builder = new BearerTokenAuthConfigBuilder(this, item);
    }
    BearerTokenAuthConfigBuilder builder;
    
    public N and() {
      return (N) ServiceBrokerAuthInfoFluent.this.withBearer(builder.build());
    }
    
    public N endBearer() {
      return and();
    }
    
  
  }

}