package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ServiceBrokerStatusBuilder extends ServiceBrokerStatusFluent<ServiceBrokerStatusBuilder> implements VisitableBuilder<ServiceBrokerStatus,ServiceBrokerStatusBuilder>{
  public ServiceBrokerStatusBuilder() {
    this(new ServiceBrokerStatus());
  }
  
  public ServiceBrokerStatusBuilder(ServiceBrokerStatusFluent<?> fluent) {
    this(fluent, new ServiceBrokerStatus());
  }
  
  public ServiceBrokerStatusBuilder(ServiceBrokerStatusFluent<?> fluent,ServiceBrokerStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ServiceBrokerStatusBuilder(ServiceBrokerStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ServiceBrokerStatusFluent<?> fluent;
  
  public ServiceBrokerStatus build() {
    ServiceBrokerStatus buildable = new ServiceBrokerStatus(fluent.buildConditions(),fluent.getLastCatalogRetrievalTime(),fluent.getOperationStartTime(),fluent.getReconciledGeneration());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}