/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.servicecatalog.server.mock;

import io.fabric8.kubernetes.client.server.mock.KubernetesMixedDispatcher;
import io.fabric8.kubernetes.client.server.mock.KubernetesMockServerExtension;
import io.fabric8.mockwebserver.Context;
import io.fabric8.mockwebserver.ServerRequest;
import io.fabric8.mockwebserver.ServerResponse;
import io.fabric8.servicecatalog.client.NamespacedServiceCatalogClient;
import io.fabric8.servicecatalog.client.ServiceCatalogClient;
import io.fabric8.servicecatalog.server.mock.EnableServiceCatalogMockClient;
import io.fabric8.servicecatalog.server.mock.ServiceCatalogMockServer;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Queue;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockWebServer;
import org.junit.jupiter.api.extension.ExtensionContext;

public class ServiceCatalogMockServerExtension
extends KubernetesMockServerExtension {
    private ServiceCatalogMockServer serviceCatalogMockServer;
    private NamespacedServiceCatalogClient serviceCatalogClient;

    protected void destroy() {
        this.serviceCatalogMockServer.destroy();
        this.serviceCatalogClient.close();
    }

    protected Class<?> getClientType() {
        return ServiceCatalogClient.class;
    }

    protected Class<?> getKubernetesMockServerType() {
        return ServiceCatalogMockServer.class;
    }

    protected void initializeKubernetesClientAndMockServer(Class<?> testClass) {
        EnableServiceCatalogMockClient a = testClass.getAnnotation(EnableServiceCatalogMockClient.class);
        HashMap<ServerRequest, Queue<ServerResponse>> responses = new HashMap<ServerRequest, Queue<ServerResponse>>();
        this.serviceCatalogMockServer = a.crud() ? new ServiceCatalogMockServer(new Context(), new MockWebServer(), responses, (Dispatcher)new KubernetesMixedDispatcher(responses), a.https()) : new ServiceCatalogMockServer(a.https());
        this.serviceCatalogMockServer.init();
        this.serviceCatalogClient = this.serviceCatalogMockServer.createServiceCatalog();
    }

    protected void setFieldIfKubernetesClientOrMockServer(ExtensionContext context, boolean isStatic, Field field) throws IllegalAccessException {
        this.setFieldIfEqualsToProvidedType(context, isStatic, field, this.getClientType(), (i, f) -> f.set(i, this.serviceCatalogClient));
        this.setFieldIfEqualsToProvidedType(context, isStatic, field, this.getKubernetesMockServerType(), (i, f) -> f.set(i, (Object)this.serviceCatalogMockServer));
    }
}

