/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tekton.pipeline.v1alpha1;

import io.fabric8.knative.internal.pkg.apis.Condition;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.tekton.pipeline.v1alpha1.PipelineRunStatus;
import io.fabric8.tekton.pipeline.v1alpha1.PipelineRunStatusFluent;
import io.fabric8.tekton.pipeline.v1alpha1.PipelineRunTaskRunStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class PipelineRunStatusFluentImpl<A extends PipelineRunStatusFluent<A>>
extends BaseFluent<A>
implements PipelineRunStatusFluent<A> {
    private String completionTime;
    private List<Condition> conditions = new ArrayList<Condition>();
    private Long observedGeneration;
    private String startTime;
    private Map<String, PipelineRunTaskRunStatus> taskRuns;

    public PipelineRunStatusFluentImpl() {
    }

    public PipelineRunStatusFluentImpl(PipelineRunStatus instance) {
        this.withCompletionTime(instance.getCompletionTime());
        this.withConditions(instance.getConditions());
        this.withObservedGeneration(instance.getObservedGeneration());
        this.withStartTime(instance.getStartTime());
        this.withTaskRuns(instance.getTaskRuns());
    }

    @Override
    public String getCompletionTime() {
        return this.completionTime;
    }

    @Override
    public A withCompletionTime(String completionTime) {
        this.completionTime = completionTime;
        return (A)this;
    }

    @Override
    public Boolean hasCompletionTime() {
        return this.completionTime != null;
    }

    @Override
    public A addToConditions(Integer index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.add(index, item);
        return (A)this;
    }

    @Override
    public A setToConditions(Integer index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.set(index, item);
        return (A)this;
    }

    @Override
    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(Condition ... items) {
        for (Condition item : items) {
            if (this.conditions == null) continue;
            this.conditions.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<Condition> items) {
        for (Condition item : items) {
            if (this.conditions == null) continue;
            this.conditions.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<Condition> getConditions() {
        return this.conditions;
    }

    @Override
    public Condition getCondition(Integer index) {
        return this.conditions.get(index);
    }

    @Override
    public Condition getFirstCondition() {
        return this.conditions.get(0);
    }

    @Override
    public Condition getLastCondition() {
        return this.conditions.get(this.conditions.size() - 1);
    }

    @Override
    public Condition getMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<Condition> conditions) {
        if (conditions != null) {
            this.conditions = new ArrayList<Condition>();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    @Override
    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)this;
    }

    @Override
    public Boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    @Override
    public String getStartTime() {
        return this.startTime;
    }

    @Override
    public A withStartTime(String startTime) {
        this.startTime = startTime;
        return (A)this;
    }

    @Override
    public Boolean hasStartTime() {
        return this.startTime != null;
    }

    @Override
    public A addToTaskRuns(String key, PipelineRunTaskRunStatus value) {
        if (this.taskRuns == null && key != null && value != null) {
            this.taskRuns = new LinkedHashMap<String, PipelineRunTaskRunStatus>();
        }
        if (key != null && value != null) {
            this.taskRuns.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToTaskRuns(Map<String, PipelineRunTaskRunStatus> map) {
        if (this.taskRuns == null && map != null) {
            this.taskRuns = new LinkedHashMap<String, PipelineRunTaskRunStatus>();
        }
        if (map != null) {
            this.taskRuns.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromTaskRuns(String key) {
        if (this.taskRuns == null) {
            return (A)this;
        }
        if (key != null && this.taskRuns != null) {
            this.taskRuns.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromTaskRuns(Map<String, PipelineRunTaskRunStatus> map) {
        if (this.taskRuns == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.taskRuns == null) continue;
                this.taskRuns.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, PipelineRunTaskRunStatus> getTaskRuns() {
        return this.taskRuns;
    }

    @Override
    public <K, V> A withTaskRuns(Map<String, PipelineRunTaskRunStatus> taskRuns) {
        this.taskRuns = taskRuns == null ? null : new LinkedHashMap<String, PipelineRunTaskRunStatus>(taskRuns);
        return (A)this;
    }

    @Override
    public Boolean hasTaskRuns() {
        return this.taskRuns != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PipelineRunStatusFluentImpl that = (PipelineRunStatusFluentImpl)o;
        if (this.completionTime != null ? !this.completionTime.equals(that.completionTime) : that.completionTime != null) {
            return false;
        }
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.observedGeneration != null ? !this.observedGeneration.equals(that.observedGeneration) : that.observedGeneration != null) {
            return false;
        }
        if (this.startTime != null ? !this.startTime.equals(that.startTime) : that.startTime != null) {
            return false;
        }
        return !(this.taskRuns != null ? !this.taskRuns.equals(that.taskRuns) : that.taskRuns != null);
    }

    public int hashCode() {
        return Objects.hash(this.completionTime, this.conditions, this.observedGeneration, this.startTime, this.taskRuns, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.completionTime != null) {
            sb.append("completionTime:");
            sb.append(this.completionTime + ",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration + ",");
        }
        if (this.startTime != null) {
            sb.append("startTime:");
            sb.append(this.startTime + ",");
        }
        if (this.taskRuns != null && !this.taskRuns.isEmpty()) {
            sb.append("taskRuns:");
            sb.append(this.taskRuns);
        }
        sb.append("}");
        return sb.toString();
    }
}

