/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.verticalpodautoscaler.api.model.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.verticalpodautoscaler.api.model.v1.ContainerResourcePolicy;
import io.fabric8.verticalpodautoscaler.api.model.v1.ContainerResourcePolicyBuilder;
import io.fabric8.verticalpodautoscaler.api.model.v1.ContainerResourcePolicyFluentImpl;
import io.fabric8.verticalpodautoscaler.api.model.v1.PodResourcePolicy;
import io.fabric8.verticalpodautoscaler.api.model.v1.PodResourcePolicyFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class PodResourcePolicyFluentImpl<A extends PodResourcePolicyFluent<A>>
extends BaseFluent<A>
implements PodResourcePolicyFluent<A> {
    private ArrayList<ContainerResourcePolicyBuilder> containerPolicies = new ArrayList();

    public PodResourcePolicyFluentImpl() {
    }

    public PodResourcePolicyFluentImpl(PodResourcePolicy instance) {
        this.withContainerPolicies(instance.getContainerPolicies());
    }

    @Override
    public A addToContainerPolicies(Integer index, ContainerResourcePolicy item) {
        if (this.containerPolicies == null) {
            this.containerPolicies = new ArrayList();
        }
        ContainerResourcePolicyBuilder builder = new ContainerResourcePolicyBuilder(item);
        this._visitables.get((Object)"containerPolicies").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"containerPolicies").size(), builder);
        this.containerPolicies.add(index >= 0 ? index.intValue() : this.containerPolicies.size(), builder);
        return (A)this;
    }

    @Override
    public A setToContainerPolicies(Integer index, ContainerResourcePolicy item) {
        if (this.containerPolicies == null) {
            this.containerPolicies = new ArrayList();
        }
        ContainerResourcePolicyBuilder builder = new ContainerResourcePolicyBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"containerPolicies").size()) {
            this._visitables.get((Object)"containerPolicies").add(builder);
        } else {
            this._visitables.get((Object)"containerPolicies").set(index, builder);
        }
        if (index < 0 || index >= this.containerPolicies.size()) {
            this.containerPolicies.add(builder);
        } else {
            this.containerPolicies.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToContainerPolicies(ContainerResourcePolicy ... items) {
        if (this.containerPolicies == null) {
            this.containerPolicies = new ArrayList();
        }
        for (ContainerResourcePolicy item : items) {
            ContainerResourcePolicyBuilder builder = new ContainerResourcePolicyBuilder(item);
            this._visitables.get((Object)"containerPolicies").add(builder);
            this.containerPolicies.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToContainerPolicies(Collection<ContainerResourcePolicy> items) {
        if (this.containerPolicies == null) {
            this.containerPolicies = new ArrayList();
        }
        for (ContainerResourcePolicy item : items) {
            ContainerResourcePolicyBuilder builder = new ContainerResourcePolicyBuilder(item);
            this._visitables.get((Object)"containerPolicies").add(builder);
            this.containerPolicies.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromContainerPolicies(ContainerResourcePolicy ... items) {
        for (ContainerResourcePolicy item : items) {
            ContainerResourcePolicyBuilder builder = new ContainerResourcePolicyBuilder(item);
            this._visitables.get((Object)"containerPolicies").remove(builder);
            if (this.containerPolicies == null) continue;
            this.containerPolicies.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromContainerPolicies(Collection<ContainerResourcePolicy> items) {
        for (ContainerResourcePolicy item : items) {
            ContainerResourcePolicyBuilder builder = new ContainerResourcePolicyBuilder(item);
            this._visitables.get((Object)"containerPolicies").remove(builder);
            if (this.containerPolicies == null) continue;
            this.containerPolicies.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromContainerPolicies(Predicate<ContainerResourcePolicyBuilder> predicate) {
        if (this.containerPolicies == null) {
            return (A)this;
        }
        Iterator<ContainerResourcePolicyBuilder> each = this.containerPolicies.iterator();
        List visitables = this._visitables.get((Object)"containerPolicies");
        while (each.hasNext()) {
            ContainerResourcePolicyBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ContainerResourcePolicy> getContainerPolicies() {
        return this.containerPolicies != null ? PodResourcePolicyFluentImpl.build(this.containerPolicies) : null;
    }

    @Override
    public List<ContainerResourcePolicy> buildContainerPolicies() {
        return this.containerPolicies != null ? PodResourcePolicyFluentImpl.build(this.containerPolicies) : null;
    }

    @Override
    public ContainerResourcePolicy buildContainerPolicy(Integer index) {
        return this.containerPolicies.get(index).build();
    }

    @Override
    public ContainerResourcePolicy buildFirstContainerPolicy() {
        return this.containerPolicies.get(0).build();
    }

    @Override
    public ContainerResourcePolicy buildLastContainerPolicy() {
        return this.containerPolicies.get(this.containerPolicies.size() - 1).build();
    }

    @Override
    public ContainerResourcePolicy buildMatchingContainerPolicy(Predicate<ContainerResourcePolicyBuilder> predicate) {
        for (ContainerResourcePolicyBuilder item : this.containerPolicies) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingContainerPolicy(Predicate<ContainerResourcePolicyBuilder> predicate) {
        for (ContainerResourcePolicyBuilder item : this.containerPolicies) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withContainerPolicies(List<ContainerResourcePolicy> containerPolicies) {
        if (this.containerPolicies != null) {
            this._visitables.get((Object)"containerPolicies").removeAll(this.containerPolicies);
        }
        if (containerPolicies != null) {
            this.containerPolicies = new ArrayList();
            for (ContainerResourcePolicy item : containerPolicies) {
                this.addToContainerPolicies(item);
            }
        } else {
            this.containerPolicies = null;
        }
        return (A)this;
    }

    @Override
    public A withContainerPolicies(ContainerResourcePolicy ... containerPolicies) {
        if (this.containerPolicies != null) {
            this.containerPolicies.clear();
        }
        if (containerPolicies != null) {
            for (ContainerResourcePolicy item : containerPolicies) {
                this.addToContainerPolicies(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasContainerPolicies() {
        return this.containerPolicies != null && !this.containerPolicies.isEmpty();
    }

    @Override
    public PodResourcePolicyFluent.ContainerPoliciesNested<A> addNewContainerPolicy() {
        return new ContainerPoliciesNestedImpl();
    }

    @Override
    public PodResourcePolicyFluent.ContainerPoliciesNested<A> addNewContainerPolicyLike(ContainerResourcePolicy item) {
        return new ContainerPoliciesNestedImpl(-1, item);
    }

    @Override
    public PodResourcePolicyFluent.ContainerPoliciesNested<A> setNewContainerPolicyLike(Integer index, ContainerResourcePolicy item) {
        return new ContainerPoliciesNestedImpl(index, item);
    }

    @Override
    public PodResourcePolicyFluent.ContainerPoliciesNested<A> editContainerPolicy(Integer index) {
        if (this.containerPolicies.size() <= index) {
            throw new RuntimeException("Can't edit containerPolicies. Index exceeds size.");
        }
        return this.setNewContainerPolicyLike(index, this.buildContainerPolicy(index));
    }

    @Override
    public PodResourcePolicyFluent.ContainerPoliciesNested<A> editFirstContainerPolicy() {
        if (this.containerPolicies.size() == 0) {
            throw new RuntimeException("Can't edit first containerPolicies. The list is empty.");
        }
        return this.setNewContainerPolicyLike(0, this.buildContainerPolicy(0));
    }

    @Override
    public PodResourcePolicyFluent.ContainerPoliciesNested<A> editLastContainerPolicy() {
        int index = this.containerPolicies.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last containerPolicies. The list is empty.");
        }
        return this.setNewContainerPolicyLike(index, this.buildContainerPolicy(index));
    }

    @Override
    public PodResourcePolicyFluent.ContainerPoliciesNested<A> editMatchingContainerPolicy(Predicate<ContainerResourcePolicyBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.containerPolicies.size(); ++i) {
            if (!predicate.test(this.containerPolicies.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching containerPolicies. No match found.");
        }
        return this.setNewContainerPolicyLike(index, this.buildContainerPolicy(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PodResourcePolicyFluentImpl that = (PodResourcePolicyFluentImpl)o;
        return !(this.containerPolicies != null ? !this.containerPolicies.equals(that.containerPolicies) : that.containerPolicies != null);
    }

    public int hashCode() {
        return Objects.hash(this.containerPolicies, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.containerPolicies != null && !this.containerPolicies.isEmpty()) {
            sb.append("containerPolicies:");
            sb.append(this.containerPolicies);
        }
        sb.append("}");
        return sb.toString();
    }

    class ContainerPoliciesNestedImpl<N>
    extends ContainerResourcePolicyFluentImpl<PodResourcePolicyFluent.ContainerPoliciesNested<N>>
    implements PodResourcePolicyFluent.ContainerPoliciesNested<N>,
    Nested<N> {
        ContainerResourcePolicyBuilder builder;
        Integer index;

        ContainerPoliciesNestedImpl(Integer index, ContainerResourcePolicy item) {
            this.index = index;
            this.builder = new ContainerResourcePolicyBuilder(this, item);
        }

        ContainerPoliciesNestedImpl() {
            this.index = -1;
            this.builder = new ContainerResourcePolicyBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodResourcePolicyFluentImpl.this.setToContainerPolicies(this.index, this.builder.build());
        }

        @Override
        public N endContainerPolicy() {
            return this.and();
        }
    }
}

