/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.vertx.maven.plugin.components.impl;

import io.fabric8.vertx.maven.plugin.components.PackageConfig;
import io.fabric8.vertx.maven.plugin.components.PackageService;
import io.fabric8.vertx.maven.plugin.components.PackageType;
import io.fabric8.vertx.maven.plugin.components.PackagingException;
import io.fabric8.vertx.maven.plugin.components.ServiceUtils;
import io.fabric8.vertx.maven.plugin.mojos.Archive;
import io.fabric8.vertx.maven.plugin.mojos.DependencySet;
import io.fabric8.vertx.maven.plugin.mojos.FileItem;
import io.fabric8.vertx.maven.plugin.mojos.FileSet;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.artifact.filter.resolve.ScopeFilter;
import org.apache.maven.shared.artifact.filter.resolve.transform.ArtifactIncludeFilterTransformer;
import org.apache.maven.shared.utils.io.DirectoryScanner;
import org.apache.maven.shared.utils.io.SelectorUtils;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.FileUtils;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ByteArrayAsset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.importer.ZipImporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;

@Component(role=PackageService.class, hint="fat-jar")
public class ShrinkWrapFatJarPackageService
implements PackageService {
    private static final List<String> DEFAULT_EXCLUDES = new ArrayList<String>(FileUtils.getDefaultExcludesAsList());

    @Override
    public PackageType type() {
        return PackageType.FAT_JAR;
    }

    @Override
    public File doPackage(PackageConfig config) throws PackagingException {
        File jarFile;
        Object classes;
        Log logger = Objects.requireNonNull(config.getMojo().getLog());
        Archive archive = Objects.requireNonNull(config.getArchive());
        JavaArchive jar = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
        for (DependencySet ds : archive.getDependencySets()) {
            ScopeFilter scopeFilter = ServiceUtils.newScopeFilter(ds.getScope());
            ArtifactFilter filter = new ArtifactIncludeFilterTransformer().transform(scopeFilter);
            Set<Artifact> artifacts = ServiceUtils.filterArtifacts(config.getArtifacts(), ds.getIncludes(), ds.getExcludes(), ds.isUseTransitiveDependencies(), logger, filter);
            for (Artifact artifact : artifacts) {
                File file = artifact.getFile();
                if (file.isFile()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((CharSequence)("Adding Dependency :" + artifact));
                    }
                    this.embedDependency(logger, ds, jar, file);
                    continue;
                }
                logger.info((CharSequence)("Cannot embed artifact " + artifact + " - the file does not exist"));
            }
        }
        for (FileSet fs : archive.getFileSets()) {
            this.embedFileSet(logger, config.getProject(), fs, jar);
        }
        if (archive.isIncludeClasses() && ((File)(classes = new File(config.getProject().getBuild().getOutputDirectory()))).isDirectory()) {
            jar.addAsResource((File)classes, "/");
        }
        for (FileItem item : archive.getFiles()) {
            this.embedFile(config, jar, item);
        }
        try {
            this.generateManifest(jar, archive.getManifest());
        }
        catch (IOException | MojoExecutionException e) {
            throw new PackagingException((Exception)e);
        }
        try {
            jarFile = config.getOutput();
            boolean useTmpFile = false;
            File theCreatedFile = jarFile;
            if (jarFile.isFile()) {
                useTmpFile = true;
                theCreatedFile = new File(jarFile.getParentFile(), jarFile.getName() + ".tmp");
            }
            ((ZipExporter)jar.as(ZipExporter.class)).exportTo(theCreatedFile);
            if (useTmpFile) {
                jarFile.delete();
                theCreatedFile.renameTo(jarFile);
            }
        }
        catch (Exception e) {
            throw new PackagingException(e);
        }
        return jarFile;
    }

    private void embedFile(PackageConfig config, JavaArchive jar, FileItem item) throws PackagingException {
        String path;
        if (item.getOutputDirectory() == null) {
            path = "/";
        } else {
            path = item.getOutputDirectory();
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            if (!path.endsWith("/")) {
                path = path + "/";
            }
        }
        File source = new File(config.getProject().getBasedir(), item.getSource());
        if (!source.isFile()) {
            Node node = jar.get(item.getSource());
            if (node == null) {
                throw new PackagingException("Unable to handle the file item " + item.getSource() + ", file not found in the project or in the archive.");
            }
            String name = item.getDestName();
            if (name == null) {
                name = node.getPath().get().substring(node.getPath().getParent().get().length() + 1);
            }
            String out = path + name;
            jar.add(node.getAsset(), out);
            jar.delete(node.getPath());
        } else {
            String name = item.getDestName();
            if (name == null) {
                name = source.getName();
            }
            String out = path + name;
            jar.addAsResource(source, out);
        }
    }

    private void embedFileSet(Log log, MavenProject project, FileSet fs, JavaArchive jar) {
        String[] files;
        File directory = new File(fs.getDirectory());
        if (!directory.isAbsolute()) {
            directory = new File(project.getBasedir(), fs.getDirectory());
        }
        if (!directory.isDirectory()) {
            log.warn((CharSequence)("File set root directory (" + directory.getAbsolutePath() + ") does not exist - skipping"));
            return;
        }
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(directory);
        if (fs.getOutputDirectory() == null) {
            fs.setOutputDirectory("/");
        } else if (!fs.getOutputDirectory().startsWith("/")) {
            fs.setOutputDirectory("/" + fs.getOutputDirectory());
        }
        List<String> excludes = fs.getExcludes();
        if (fs.isUseDefaultExcludes()) {
            excludes.addAll(FileUtils.getDefaultExcludesAsList());
        }
        if (!excludes.isEmpty()) {
            scanner.setExcludes(excludes.toArray(new String[0]));
        }
        if (!fs.getIncludes().isEmpty()) {
            scanner.setIncludes(fs.getIncludes().toArray(new String[0]));
        }
        scanner.scan();
        for (String path : files = scanner.getIncludedFiles()) {
            File file = new File(directory, path);
            log.debug((CharSequence)("Adding " + fs.getOutputDirectory() + path + " to the archive"));
            jar.addAsResource(file, fs.getOutputDirectory() + path);
        }
    }

    private boolean toExclude(DependencySet set, ArchivePath path) {
        String name = path.get();
        List<String> includes = set.getOptions().getIncludes();
        if (includes != null && !includes.isEmpty()) {
            boolean included = false;
            for (String pattern : includes) {
                if (!SelectorUtils.match((String)pattern, (String)name)) continue;
                included = true;
            }
            if (!included) {
                return true;
            }
        }
        if (set.getOptions().isUseDefaultExcludes()) {
            for (String pattern : DEFAULT_EXCLUDES) {
                if (!SelectorUtils.match((String)pattern, (String)name)) continue;
                return true;
            }
        }
        if (name.equalsIgnoreCase("/META-INF/MANIFEST.MF")) {
            return true;
        }
        if (set.getOptions().getExcludes() != null) {
            for (String pattern : set.getExcludes()) {
                if (!SelectorUtils.match((String)pattern, (String)name)) continue;
                return true;
            }
        }
        return false;
    }

    private void embedDependency(Log log, DependencySet set, JavaArchive jar, File file) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            ((ZipImporter)jar.as(ZipImporter.class)).importFrom((InputStream)fis, path -> {
                if (jar.contains(path)) {
                    log.debug((CharSequence)(path.get() + " already embedded in the jar"));
                    return false;
                }
                if (!this.toExclude(set, (ArchivePath)path)) {
                    return true;
                }
                log.debug((CharSequence)("Excluding " + path.get() + " from " + file.getName()));
                return false;
            });
        }
        catch (FileNotFoundException e) {
            try {
                throw new RuntimeException("Unable to read the file " + file.getAbsolutePath(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fis);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)fis);
    }

    private void generateManifest(JavaArchive jar, Map<String, String> entries) throws IOException, MojoExecutionException {
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        if (entries != null) {
            for (Map.Entry<String, String> entry : entries.entrySet()) {
                attributes.put(new Attributes.Name(entry.getKey()), entry.getValue());
            }
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        manifest.write(bout);
        bout.close();
        byte[] bytes = bout.toByteArray();
        jar.setManifest((Asset)new ByteArrayAsset(bytes));
    }

    static {
        DEFAULT_EXCLUDES.add("**/*.DSA");
        DEFAULT_EXCLUDES.add("**/*.RSA");
        DEFAULT_EXCLUDES.add("**/INDEX.LIST");
        DEFAULT_EXCLUDES.add("**/*.SF");
    }
}

