/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.vertx.maven.plugin.mojos;

import io.fabric8.vertx.maven.plugin.mojos.AbstractVertxMojo;
import io.fabric8.vertx.maven.plugin.mojos.MojoSpy;
import io.fabric8.vertx.maven.plugin.utils.ConfigConverterUtil;
import io.fabric8.vertx.maven.plugin.utils.IncrementalBuilder;
import io.fabric8.vertx.maven.plugin.utils.JavaProcessExecutor;
import io.fabric8.vertx.maven.plugin.utils.MavenExecutionUtils;
import io.fabric8.vertx.maven.plugin.utils.MojoExecutor;
import io.fabric8.vertx.maven.plugin.utils.MojoUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ClassUtils;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.DirectoryScanner;

public class AbstractRunMojo
extends AbstractVertxMojo {
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true)
    protected File classesDirectory;
    @Parameter(name="redeploy")
    protected boolean redeploy;
    @Parameter(alias="redeployScanPeriod", property="vertx.redeploy.scan.period", defaultValue="1000")
    long redeployScanPeriod;
    @Parameter(alias="redeployGracePeriod", property="vertx.redeploy.grace.period")
    long redeployGracePeriod;
    @Parameter(alias="redeployTerminationPeriod", property="vertx.redeploy.termination.period", defaultValue="1000")
    long redeployTerminationPeriod;
    protected String vertxCommand = "run";
    @Parameter(alias="config", property="vertx.config", defaultValue="src/main/conf/application.json")
    File config;
    @Parameter(alias="workDirectory", property="vertx.directory", defaultValue="${project.basedir}")
    File workDirectory;
    @Parameter(alias="jvmArgs", property="vertx.jvmArguments")
    protected List<String> jvmArgs;
    protected List<String> optionalRunExtraArgs;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"vertx:run skipped by configuration");
            return;
        }
        this.compileIfNeeded();
        ArrayList<String> argsList = new ArrayList<String>();
        this.scanAndLoadConfigs();
        boolean isVertxLauncher = this.isVertxLauncher(this.launcher);
        this.getLog().info((CharSequence)"Launching Vert.x Application");
        if (isVertxLauncher) {
            this.addVertxArgs(argsList);
        } else if (this.redeploy) {
            this.getLog().info((CharSequence)"Vert.x application redeploy enabled");
            argsList.add(0, "io.vertx.core.Launcher");
            argsList.add(1, "run");
            StringBuilder redeployArg = new StringBuilder();
            redeployArg.append("--redeploy=");
            this.computeOutputDirsWildcard(redeployArg);
            argsList.add(redeployArg.toString());
            this.addRedeployExtraArgs(argsList);
            argsList.add("--launcher-class");
            argsList.add(this.launcher);
            if (this.jvmArgs != null && !this.jvmArgs.isEmpty()) {
                String javaOpts = this.jvmArgs.stream().collect(Collectors.joining(" "));
                String argJavaOpts = "--java-opts=" + javaOpts;
                argsList.add(argJavaOpts);
            }
        } else {
            argsList.add(this.launcher);
        }
        this.addRunExtraArgs(argsList);
        this.run(argsList);
    }

    private void compileIfNeeded() {
        File classes = new File(this.project.getBuild().getOutputDirectory());
        if (!classes.isDirectory()) {
            MavenExecutionUtils.execute("compile", this.project, this.mavenSession, this.lifecycleExecutor, this.container);
        }
    }

    protected void addClasspath(List<String> args) throws MojoExecutionException {
        try {
            StringBuilder classpath = new StringBuilder();
            for (URL ele : this.getClassPathUrls()) {
                classpath = classpath.append(classpath.length() > 0 ? File.pathSeparator : "").append(new File(ele.toURI()));
            }
            this.getLog().debug((CharSequence)("Classpath for forked process: " + classpath));
            args.add("-cp");
            args.add(classpath.toString());
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Could not build classpath", ex);
        }
    }

    protected void addClassesDirectory(List<URL> classpathUrls) throws IOException {
        classpathUrls.add(this.classesDirectory.toURI().toURL());
    }

    protected void addVertxArgs(List<String> argsList) {
        Objects.requireNonNull(this.launcher);
        if ("io.vertx.core.Launcher".equals(this.launcher)) {
            argsList.add("io.vertx.core.Launcher");
        } else {
            argsList.add(this.launcher);
        }
        argsList.add(this.vertxCommand);
        if (this.verticle != null && !"stop".equals(this.vertxCommand)) {
            argsList.add(this.verticle);
        }
        if (this.redeploy && !"start".equals(this.vertxCommand) && !"stop".equals(this.vertxCommand)) {
            this.getLog().info((CharSequence)"Vert.x application redeploy enabled");
            StringBuilder redeployArg = new StringBuilder();
            redeployArg.append("--redeploy=");
            this.computeOutputDirsWildcard(redeployArg);
            argsList.add(redeployArg.toString());
            this.addRedeployExtraArgs(argsList);
            if (this.jvmArgs != null && !this.jvmArgs.isEmpty()) {
                String javaOpts = this.jvmArgs.stream().collect(Collectors.joining(" "));
                argsList.add("--java-opts=" + javaOpts);
            }
        }
        if (!"stop".equals(this.vertxCommand)) {
            String argLauncherClass = "--launcher-class=\"" + this.launcher + "\"";
            argsList.add(argLauncherClass);
            if (this.config != null && this.config.exists() && this.config.isFile()) {
                this.getLog().info((CharSequence)("Using configuration from file: " + this.config.toString()));
                argsList.add("-conf");
                argsList.add(this.config.toString());
            }
        }
    }

    private void computeOutputDirsWildcard(StringBuilder redeployArg) {
        String wildcardClassesDir = this.classesDirectory.toString() + "/**/*";
        redeployArg.append(wildcardClassesDir);
    }

    private void addRedeployExtraArgs(List<String> argsList) {
        if (this.redeployScanPeriod > 0L) {
            argsList.add("--redeploy-scan-period=" + this.redeployScanPeriod);
        }
        if (this.redeployGracePeriod > 0L) {
            argsList.add("--redeploy-grace-period=" + this.redeployGracePeriod);
        }
        if (this.redeployTerminationPeriod > 0L) {
            argsList.add("redeploy-termination-period=" + this.redeployTerminationPeriod);
        }
    }

    private void addRunExtraArgs(List<String> argsList) {
        if ("run".equals(this.vertxCommand) && this.optionalRunExtraArgs != null && !this.optionalRunExtraArgs.isEmpty()) {
            argsList.addAll(this.optionalRunExtraArgs);
        }
    }

    protected boolean isVertxLauncher(String launcher) throws MojoExecutionException {
        if (launcher != null) {
            if ("io.vertx.core.Launcher".equals(launcher)) {
                return true;
            }
            try {
                Class<?> customLauncher = this.buildClassLoader(this.getClassPathUrls()).loadClass(launcher);
                List superClasses = ClassUtils.getAllSuperclasses(customLauncher);
                boolean isAssignable = false;
                if (superClasses != null) {
                    for (Class superClass : superClasses) {
                        if (!"io.vertx.core.Launcher".equals(superClass.getName())) continue;
                        isAssignable = true;
                        break;
                    }
                }
                return isAssignable;
            }
            catch (ClassNotFoundException e) {
                throw new MojoExecutionException("Class \"" + launcher + "\" not found");
            }
        }
        return false;
    }

    protected void run(List<String> argsList) throws MojoExecutionException {
        JavaProcessExecutor vertxExecutor = new JavaProcessExecutor().withJvmOpts(this.redeploy ? Collections.emptyList() : this.jvmArgs).withArgs(argsList).withClassPath(this.getClassPathUrls()).withLogger(this.getLog()).withWaitFor(true);
        try {
            if (this.redeploy && !"start".equals(this.vertxCommand) && !"stop".equals(this.vertxCommand)) {
                this.getLog().debug((CharSequence)("Collected mojos: " + MojoSpy.MOJOS));
                Set<Path> inclDirs = Collections.singleton(new File(this.project.getBasedir(), "src/main").toPath());
                CompletableFuture.runAsync(() -> {
                    List<Callable<Void>> chain = this.computeExecutionChain();
                    IncrementalBuilder incrementalBuilder = new IncrementalBuilder(inclDirs, chain, this.getLog(), this.redeployScanPeriod);
                    incrementalBuilder.run();
                });
            }
            vertxExecutor.execute();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to launch incremental builder", e);
        }
    }

    private List<Callable<Void>> computeExecutionChain() {
        ArrayList<Callable<Void>> list = new ArrayList<JavaBuildCallback>();
        if (MojoSpy.MOJOS.isEmpty()) {
            this.getLog().info((CharSequence)"No plugin execution collected. The vertx:initialize goal has not been run beforehand. Only handling resources and java compilation");
            list.add(new JavaBuildCallback());
            list.add(new ResourceBuildCallback());
        } else {
            list = MojoSpy.MOJOS.stream().filter(exec -> MojoSpy.PHASES.contains(exec.getLifecyclePhase())).map(this::toTask).collect(Collectors.toList());
        }
        return list;
    }

    private Callable<Void> toTask(MojoExecution execution) {
        MojoExecutor executor = new MojoExecutor(execution, this.project, this.mavenSession, this.buildPluginManager);
        return () -> {
            try {
                this.getLog().info((CharSequence)(">>> " + execution.getArtifactId() + ":" + execution.getVersion() + ":" + execution.getGoal() + " (" + execution.getExecutionId() + ") @" + this.project.getArtifactId()));
                executor.execute();
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)"Error while doing incremental build", (Throwable)e);
            }
            return null;
        };
    }

    protected void scanAndLoadConfigs() throws MojoExecutionException {
        Path confBaseDir = Paths.get(this.project.getBasedir().toString(), "src", "main", "conf");
        if (Files.exists(confBaseDir, new LinkOption[0]) && Files.isDirectory(confBaseDir, new LinkOption[0])) {
            DirectoryScanner directoryScanner = new DirectoryScanner();
            directoryScanner.setBasedir(this.project.getBasedir() + "/src/main/conf");
            directoryScanner.setIncludes(WILDCARD_CONFIG_FILES);
            directoryScanner.scan();
            String[] configFiles = directoryScanner.getIncludedFiles();
            if (configFiles != null && configFiles.length != 0) {
                String configFile = configFiles[0];
                Path confPath = Paths.get(confBaseDir.toFile().toString(), configFile);
                if (this.isJson(configFile)) {
                    this.config = confPath.toFile();
                } else if (this.isYaml(configFile)) {
                    Path jsonConfDir = Paths.get(this.projectBuildDir, "conf");
                    jsonConfDir.toFile().mkdirs();
                    Path jsonConfPath = Paths.get(jsonConfDir.toString(), "application.json");
                    try {
                        Files.deleteIfExists(jsonConfPath);
                        if (Files.createFile(jsonConfPath, new FileAttribute[0]).toFile().exists()) {
                            ConfigConverterUtil.convertYamlToJson(confPath, jsonConfPath);
                            this.config = jsonConfPath.toFile();
                        }
                    }
                    catch (IOException e) {
                        throw new MojoExecutionException("Error loading configuration file:" + confPath.toString(), (Exception)e);
                    }
                    catch (Exception e) {
                        throw new MojoExecutionException("Error loading and converting configuration file:" + confPath.toString(), e);
                    }
                }
            }
        }
    }

    protected ClassLoader buildClassLoader(Collection<URL> classPathUrls) {
        return new URLClassLoader(classPathUrls.toArray(new URL[classPathUrls.size()]));
    }

    protected List<URL> getClassPathUrls() throws MojoExecutionException {
        ArrayList<URL> classPathUrls = new ArrayList<URL>();
        try {
            this.addClassesDirectory(classPathUrls);
            Set<Optional<File>> compileAndRuntimeDeps = this.extractArtifactPaths(this.project.getDependencyArtifacts());
            Set<Optional<File>> transitiveDeps = this.extractArtifactPaths(this.project.getArtifacts());
            classPathUrls.addAll(Stream.concat(compileAndRuntimeDeps.stream(), transitiveDeps.stream()).filter(Optional::isPresent).map(file -> {
                try {
                    return ((File)file.get()).toURI().toURL();
                }
                catch (Exception e) {
                    this.getLog().error((CharSequence)"Error building classpath", (Throwable)e);
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList()));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to run:", (Exception)e);
        }
        return classPathUrls;
    }

    private boolean isJson(String configFile) {
        return configFile != null && configFile.endsWith(".json");
    }

    private boolean isYaml(String configFile) {
        return configFile != null && (configFile.endsWith(".yaml") || configFile.endsWith(".yml"));
    }

    public final class ResourceBuildCallback
    implements Callable<Void> {
        @Override
        public Void call() {
            try {
                MojoUtils.copyResources(AbstractRunMojo.this.project, AbstractRunMojo.this.mavenSession, AbstractRunMojo.this.buildPluginManager);
            }
            catch (Exception e) {
                AbstractRunMojo.this.getLog().error((CharSequence)("Error while doing incremental resource processing: " + e.getMessage()), (Throwable)e);
            }
            return null;
        }
    }

    public final class JavaBuildCallback
    implements Callable<Void> {
        @Override
        public Void call() {
            try {
                MojoUtils.compile(AbstractRunMojo.this.project, AbstractRunMojo.this.mavenSession, AbstractRunMojo.this.buildPluginManager);
            }
            catch (Exception e) {
                AbstractRunMojo.this.getLog().error((CharSequence)("Error while doing incremental Java build: " + e.getMessage()), (Throwable)e);
            }
            return null;
        }
    }
}

