/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.vertx.maven.plugin.mojos;

import io.fabric8.vertx.maven.plugin.mojos.AbstractVertxMojo;
import io.fabric8.vertx.maven.plugin.mojos.MojoSpy;
import io.fabric8.vertx.maven.plugin.utils.WebJars;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="initialize", defaultPhase=LifecyclePhase.INITIALIZE, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class InitializeMojo
extends AbstractVertxMojo {
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Parameter
    private File webRoot;
    @Parameter(defaultValue="true")
    private boolean stripWebJarVersion;
    @Parameter(defaultValue="true")
    private boolean stripJavaScriptDependencyVersion;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"vertx:initialize skipped by configuration");
            return;
        }
        if (this.webRoot == null) {
            this.webRoot = new File(this.project.getBuild().getOutputDirectory(), "webroot");
        }
        LinkedHashSet<Artifact> dependencies = new LinkedHashSet<Artifact>();
        dependencies.addAll(this.project.getDependencyArtifacts());
        dependencies.addAll(this.project.getArtifacts());
        this.copyJSDependencies(dependencies);
        this.unpackWebjars(dependencies);
        MavenExecutionRequest request = this.session.getRequest();
        MojoSpy.init(request);
    }

    private void unpackWebjars(Set<Artifact> dependencies) throws MojoExecutionException {
        for (Artifact artifact : dependencies) {
            Optional<File> maybeFile = this.getArtifactFile(artifact);
            if (!artifact.getType().equalsIgnoreCase("jar") || !maybeFile.isPresent() || !WebJars.isWebJar(this.getLog(), maybeFile.get())) continue;
            try {
                WebJars.extract(this, maybeFile.get(), this.createWebRootDirIfNeeded(), this.stripWebJarVersion);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to unpack '" + artifact.toString() + "'", (Exception)e);
            }
        }
    }

    private File createWebRootDirIfNeeded() {
        if (!this.webRoot.isDirectory()) {
            boolean created = this.webRoot.mkdirs();
            if (created) {
                this.getLog().debug((CharSequence)("Webroot directory created: " + this.webRoot.getAbsolutePath()));
            } else {
                this.getLog().error((CharSequence)("Unable to create directory: " + this.webRoot.getAbsolutePath()));
            }
        }
        return this.webRoot;
    }

    private void copyJSDependencies(Set<Artifact> dependencies) throws MojoExecutionException {
        for (Artifact artifact : dependencies) {
            if (!artifact.getType().equalsIgnoreCase("js")) continue;
            Optional<File> file = this.getArtifactFile(artifact);
            if (file.isPresent()) {
                try {
                    if (this.stripJavaScriptDependencyVersion) {
                        String name = artifact.getArtifactId();
                        if (artifact.getClassifier() != null) {
                            name = name + "-" + artifact.getClassifier();
                        }
                        name = name + ".js";
                        File output = new File(this.createWebRootDirIfNeeded(), name);
                        FileUtils.copyFile((File)file.get(), (File)output);
                        continue;
                    }
                    FileUtils.copyFileToDirectory((File)file.get(), (File)this.createWebRootDirIfNeeded());
                    continue;
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Unable to copy '" + artifact.toString() + "'", (Exception)e);
                }
            }
            this.getLog().warn((CharSequence)("Skipped the copy of '" + artifact.toString() + "' - The artifact file does not exist"));
        }
    }
}

