/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.vertx.maven.plugin.utils;

import io.fabric8.vertx.maven.plugin.components.impl.ProjectManifestCustomizer;
import io.fabric8.vertx.maven.plugin.model.ExtraManifestKeys;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.scm.ChangeSet;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.changelog.ChangeLogScmRequest;
import org.apache.maven.scm.command.changelog.ChangeLogScmResult;
import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.provider.ScmUrlUtils;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;

public class ScmSpy {
    private final ScmManager scmManager;

    public ScmSpy(ScmManager scmManager) {
        this.scmManager = scmManager;
    }

    public String getScmType(String scmUrl) throws ScmRepositoryException, NoSuchScmProviderException {
        return ScmUrlUtils.getProvider((String)scmUrl);
    }

    public Map<String, String> getChangeLog(String scmUrl, File workingDir) throws IOException, ScmException {
        List changeSetList;
        HashMap<String, String> changeLogMap = new HashMap<String, String>();
        ScmRepository scmRepository = this.scmManager.makeScmRepository(scmUrl);
        ChangeLogScmResult scmResult = this.scmManager.changeLog(new ChangeLogScmRequest(scmRepository, new ScmFileSet(workingDir, "*")));
        if (scmResult.isSuccess() && (changeSetList = scmResult.getChangeLog().getChangeSets()) != null && !changeSetList.isEmpty()) {
            ChangeSet changeSet = (ChangeSet)changeSetList.get(0);
            changeLogMap.put(ExtraManifestKeys.scmType.name(), this.getScmType(scmUrl));
            changeLogMap.put(ExtraManifestKeys.scmRevision.name(), changeSet.getRevision());
            changeLogMap.put(ExtraManifestKeys.lastCommitTimestamp.name(), ProjectManifestCustomizer.manifestTimestampFormat(changeSet.getDate()));
            changeLogMap.put(ExtraManifestKeys.author.name(), changeSet.getAuthor());
        }
        return changeLogMap;
    }
}

