/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.volumesnapshot.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshotContent;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshotContentFluent;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshotContentSpec;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshotContentSpecBuilder;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshotContentSpecFluentImpl;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshotContentStatus;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshotContentStatusBuilder;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshotContentStatusFluentImpl;
import java.util.Objects;

public class VolumeSnapshotContentFluentImpl<A extends VolumeSnapshotContentFluent<A>>
extends BaseFluent<A>
implements VolumeSnapshotContentFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private VolumeSnapshotContentSpecBuilder spec;
    private VolumeSnapshotContentStatusBuilder status;

    public VolumeSnapshotContentFluentImpl() {
    }

    public VolumeSnapshotContentFluentImpl(VolumeSnapshotContent instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get((Object)"metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get((Object)"metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get((Object)"metadata").remove(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public VolumeSnapshotContentFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public VolumeSnapshotContentFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public VolumeSnapshotContentFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public VolumeSnapshotContentFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public VolumeSnapshotContentFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public VolumeSnapshotContentSpec getSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public VolumeSnapshotContentSpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public A withSpec(VolumeSnapshotContentSpec spec) {
        this._visitables.get((Object)"spec").remove(this.spec);
        if (spec != null) {
            this.spec = new VolumeSnapshotContentSpecBuilder(spec);
            this._visitables.get((Object)"spec").add(this.spec);
        } else {
            this.spec = null;
            this._visitables.get((Object)"spec").remove(this.spec);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSpec() {
        return this.spec != null;
    }

    @Override
    public VolumeSnapshotContentFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public VolumeSnapshotContentFluent.SpecNested<A> withNewSpecLike(VolumeSnapshotContentSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public VolumeSnapshotContentFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public VolumeSnapshotContentFluent.SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : new VolumeSnapshotContentSpecBuilder().build());
    }

    @Override
    public VolumeSnapshotContentFluent.SpecNested<A> editOrNewSpecLike(VolumeSnapshotContentSpec item) {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : item);
    }

    @Override
    @Deprecated
    public VolumeSnapshotContentStatus getStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public VolumeSnapshotContentStatus buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public A withStatus(VolumeSnapshotContentStatus status) {
        this._visitables.get((Object)"status").remove(this.status);
        if (status != null) {
            this.status = new VolumeSnapshotContentStatusBuilder(status);
            this._visitables.get((Object)"status").add(this.status);
        } else {
            this.status = null;
            this._visitables.get((Object)"status").remove(this.status);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStatus() {
        return this.status != null;
    }

    @Override
    public VolumeSnapshotContentFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public VolumeSnapshotContentFluent.StatusNested<A> withNewStatusLike(VolumeSnapshotContentStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public VolumeSnapshotContentFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public VolumeSnapshotContentFluent.StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : new VolumeSnapshotContentStatusBuilder().build());
    }

    @Override
    public VolumeSnapshotContentFluent.StatusNested<A> editOrNewStatusLike(VolumeSnapshotContentStatus item) {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VolumeSnapshotContentFluentImpl that = (VolumeSnapshotContentFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals((Object)that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals(that.status) : that.status != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.spec, this.status, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.spec != null) {
            sb.append("spec:");
            sb.append(this.spec + ",");
        }
        if (this.status != null) {
            sb.append("status:");
            sb.append(this.status);
        }
        sb.append("}");
        return sb.toString();
    }

    class StatusNestedImpl<N>
    extends VolumeSnapshotContentStatusFluentImpl<VolumeSnapshotContentFluent.StatusNested<N>>
    implements VolumeSnapshotContentFluent.StatusNested<N>,
    Nested<N> {
        VolumeSnapshotContentStatusBuilder builder;

        StatusNestedImpl(VolumeSnapshotContentStatus item) {
            this.builder = new VolumeSnapshotContentStatusBuilder(this, item);
        }

        StatusNestedImpl() {
            this.builder = new VolumeSnapshotContentStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)VolumeSnapshotContentFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    class SpecNestedImpl<N>
    extends VolumeSnapshotContentSpecFluentImpl<VolumeSnapshotContentFluent.SpecNested<N>>
    implements VolumeSnapshotContentFluent.SpecNested<N>,
    Nested<N> {
        VolumeSnapshotContentSpecBuilder builder;

        SpecNestedImpl(VolumeSnapshotContentSpec item) {
            this.builder = new VolumeSnapshotContentSpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new VolumeSnapshotContentSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)VolumeSnapshotContentFluentImpl.this.withSpec(this.builder.build());
        }

        @Override
        public N endSpec() {
            return this.and();
        }
    }

    class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<VolumeSnapshotContentFluent.MetadataNested<N>>
    implements VolumeSnapshotContentFluent.MetadataNested<N>,
    Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this);
        }

        @Override
        public N and() {
            return (N)VolumeSnapshotContentFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

