/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.volumesnapshot.server.mock;

import io.fabric8.kubernetes.client.server.mock.KubernetesMixedDispatcher;
import io.fabric8.kubernetes.client.server.mock.KubernetesMockServerExtension;
import io.fabric8.mockwebserver.Context;
import io.fabric8.mockwebserver.ServerRequest;
import io.fabric8.mockwebserver.ServerResponse;
import io.fabric8.volumesnapshot.client.NamespacedVolumeSnapshotClient;
import io.fabric8.volumesnapshot.client.VolumeSnapshotClient;
import io.fabric8.volumesnapshot.server.mock.EnableVolumeSnapshotMockClient;
import io.fabric8.volumesnapshot.server.mock.VolumeSnapshotMockServer;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Queue;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockWebServer;
import org.junit.jupiter.api.extension.ExtensionContext;

public class VolumeSnapshotMockServerExtension
extends KubernetesMockServerExtension {
    private VolumeSnapshotMockServer volumeSnapshotMockServer;
    private NamespacedVolumeSnapshotClient volumeSnapshotClient;

    protected void destroy() {
        this.volumeSnapshotMockServer.destroy();
        this.volumeSnapshotClient.close();
    }

    protected Class<?> getClientType() {
        return VolumeSnapshotClient.class;
    }

    protected Class<?> getKubernetesMockServerType() {
        return VolumeSnapshotMockServer.class;
    }

    protected void initializeKubernetesClientAndMockServer(Class<?> testClass) {
        EnableVolumeSnapshotMockClient a = testClass.getAnnotation(EnableVolumeSnapshotMockClient.class);
        HashMap<ServerRequest, Queue<ServerResponse>> responses = new HashMap<ServerRequest, Queue<ServerResponse>>();
        this.volumeSnapshotMockServer = a.crud() ? new VolumeSnapshotMockServer(new Context(), new MockWebServer(), responses, (Dispatcher)new KubernetesMixedDispatcher(responses), a.https()) : new VolumeSnapshotMockServer(a.https());
        this.volumeSnapshotMockServer.init();
        this.volumeSnapshotClient = this.volumeSnapshotMockServer.createVolumeSnapshot();
    }

    protected void setFieldIfKubernetesClientOrMockServer(ExtensionContext context, boolean isStatic, Field field) throws IllegalAccessException {
        this.setFieldIfEqualsToProvidedType(context, isStatic, field, this.getClientType(), (i, f) -> f.set(i, this.volumeSnapshotClient));
        this.setFieldIfEqualsToProvidedType(context, isStatic, field, this.getKubernetesMockServerType(), (i, f) -> f.set(i, (Object)this.volumeSnapshotMockServer));
    }
}

