/*
 * Decompiled with CFR 0.152.
 */
package org.boon.concurrent;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.boon.Boon;
import org.boon.Logger;
import org.boon.core.Sys;

public class Timer {
    private Logger logger = Boon.configurableLogger(Timer.class);
    private AtomicLong time = new AtomicLong(System.nanoTime() / 1000000L);
    ScheduledExecutorService monitor;
    ScheduledFuture<?> future;
    private static AtomicReference<Timer> timeHolder = new AtomicReference();

    public static Timer timer() {
        if (timeHolder.get() == null && timeHolder.compareAndSet(timeHolder.get(), new Timer())) {
            timeHolder.get().start();
        }
        return timeHolder.get();
    }

    public void stop() {
        this.future.cancel(true);
        this.monitor.shutdownNow();
        this.monitor = null;
    }

    private void start() {
        if (this.monitor == null) {
            this.monitor = Executors.newScheduledThreadPool(1, new ThreadFactory(){

                @Override
                public Thread newThread(Runnable runnable) {
                    Thread thread = new Thread(runnable);
                    thread.setPriority(10);
                    thread.setName("Timer OutputQueue Manager");
                    return thread;
                }
            });
        }
        this.future = this.monitor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    Timer.this.manageTimer();
                }
                catch (Exception ex) {
                    Timer.this.logger.error(ex, "can't manage timeHolder");
                }
            }
        }, 50L, 50L, TimeUnit.MILLISECONDS);
    }

    private void manageTimer() {
        int count = 0;
        while (true) {
            Sys.sleep(5L);
            this.time.addAndGet(5L);
            if (++count <= 100) continue;
            this.time.set(System.nanoTime() / 1000000L);
            count = 0;
        }
    }

    public long time() {
        return this.time.get();
    }

    public long now() {
        return this.time.get();
    }
}

