/*
 * Decompiled with CFR 0.152.
 */
package org.boon.criteria.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.boon.Lists;
import org.boon.core.reflection.Invoker;
import org.boon.criteria.ObjectFilter;
import org.boon.criteria.internal.Criteria;
import org.boon.criteria.internal.Grouping;

public abstract class Group
extends Criteria {
    protected List<Criteria> expressions;
    private Grouping grouping = Grouping.AND;

    public Group(Grouping grouping, Criteria ... expressions) {
        this.grouping = grouping;
        this.expressions = Lists.list(expressions);
    }

    public Group(Grouping grouping, Class<?> cls, List<?> list) {
        this.grouping = grouping;
        ArrayList<Criteria> criteriaArrayList = new ArrayList<Criteria>();
        List<?> lists = list;
        for (ArrayList args : lists) {
            args = new ArrayList(args);
            args.add(1, cls);
            Object o = Lists.atIndex(args, -1);
            if (!(o instanceof List)) {
                Lists.atIndex(args, -1, Collections.singletonList(o));
            }
            Criteria criteria = (Criteria)Invoker.invokeFromObject(ObjectFilter.class, "createCriteriaFromClass", args);
            criteriaArrayList.add(criteria);
        }
        this.expressions = criteriaArrayList;
    }

    public Grouping getGrouping() {
        return this.grouping;
    }

    public List<Criteria> getExpressions() {
        return this.expressions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Group group = (Group)o;
        if (this.expressions != null ? !this.expressions.equals(group.expressions) : group.expressions != null) {
            return false;
        }
        return this.grouping == group.grouping;
    }

    public static class Or
    extends Group {
        public Or(Criteria ... expressions) {
            super(Grouping.OR, expressions);
        }

        public Or(Class<?> cls, List<?> list) {
            super(Grouping.OR, cls, list);
        }

        public boolean test(Object owner) {
            for (Criteria c : this.expressions) {
                if (!c.test(owner)) continue;
                return true;
            }
            return false;
        }
    }

    public static class And
    extends Group {
        public And(Criteria ... expressions) {
            super(Grouping.AND, expressions);
        }

        public And(Class<?> cls, List<?> list) {
            super(Grouping.AND, cls, list);
        }

        public boolean test(Object owner) {
            for (Criteria c : this.expressions) {
                if (c.test(owner)) continue;
                return false;
            }
            return true;
        }
    }
}

