/*
 * Decompiled with CFR 0.152.
 */
package org.boon.datarepo.impl.indexes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.NavigableMap;
import java.util.SortedMap;
import org.boon.Lists;
import org.boon.core.Function;
import org.boon.datarepo.impl.indexes.MultiValue;
import org.boon.datarepo.impl.indexes.UniqueLookupIndex;
import org.boon.datarepo.spi.SPIFactory;
import org.boon.datarepo.spi.SearchIndex;
import org.boon.primitive.CharBuf;

public class UniqueSearchIndex<KEY, ITEM>
extends UniqueLookupIndex<KEY, ITEM>
implements SearchIndex<KEY, ITEM> {
    private Class<?> keyType;
    private NavigableMap<KEY, ITEM> navigableMap;
    private Comparator collator;

    public UniqueSearchIndex(Class<?> keyType) {
        super(keyType);
        this.keyType = keyType;
    }

    public UniqueSearchIndex(Class<?> keyType, List<ITEM> items, Function<ITEM, KEY> keyGetter) {
        super(keyType);
        this.keyGetter = keyGetter;
        this.map = SPIFactory.getMapCreatorFactory().get().createMap(keyType);
        this.navigableMap = (NavigableMap)this.map;
        for (ITEM item : items) {
            this.add(item);
        }
    }

    @Override
    public void setComparator(Comparator collator) {
        this.collator = collator;
    }

    @Override
    public void init() {
        this.map = SPIFactory.getMapCreatorFactory().get().createNavigableMap(this.keyType, this.collator);
        this.navigableMap = (NavigableMap)this.map;
    }

    @Override
    public ITEM findFirst() {
        return this.navigableMap.firstEntry().getValue();
    }

    @Override
    public ITEM findLast() {
        return this.navigableMap.lastEntry().getValue();
    }

    @Override
    public KEY findFirstKey() {
        return this.navigableMap.firstEntry().getKey();
    }

    @Override
    public KEY findLastKey() {
        return this.navigableMap.lastEntry().getKey();
    }

    @Override
    public List<ITEM> findEquals(KEY key) {
        key = this.getKey(key);
        return Lists.list(this.navigableMap.get(key));
    }

    @Override
    public List<ITEM> findStartsWith(KEY keyFrag) {
        if ((keyFrag = this.getKey(keyFrag)) instanceof String) {
            String start = (String)keyFrag;
            if (start.length() == 0 || start == null) {
                return Collections.EMPTY_LIST;
            }
            char endLetter = start.charAt(start.length() - 1);
            String sub = start.substring(0, start.length() - 1);
            CharBuf after = CharBuf.create(start.length());
            after.add(String.valueOf(sub));
            after.add((char)(endLetter + '\u0001'));
            NavigableMap<KEY, ITEM> sortMap = this.navigableMap;
            SortedMap<String, ITEM> sortedSubMap = sortMap.subMap(start, after.toString());
            if (sortedSubMap.size() > 0) {
                ArrayList results = new ArrayList();
                for (MultiValue values : sortedSubMap.values()) {
                    values.addTo(results);
                }
                return results;
            }
            return Collections.EMPTY_LIST;
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<ITEM> findEndsWith(KEY keyFrag) {
        throw new UnsupportedOperationException("findEndsWith Not supported");
    }

    @Override
    public List<ITEM> findContains(KEY keyFrag) {
        throw new UnsupportedOperationException("findContains Not supported");
    }

    @Override
    public List<ITEM> findBetween(KEY start, KEY end) {
        start = this.getKey(start);
        end = this.getKey(end);
        SortedMap<KEY, ITEM> keyMultiValueSortedMap = this.navigableMap.subMap(start, end);
        return new ArrayList<ITEM>(keyMultiValueSortedMap.values());
    }

    @Override
    public List<ITEM> findGreaterThan(KEY key) {
        key = this.getKey(key);
        NavigableMap<KEY, ITEM> keyMultiValueSortedMap = this.navigableMap.tailMap(key, false);
        return new ArrayList(keyMultiValueSortedMap.values());
    }

    @Override
    public List<ITEM> findLessThan(KEY key) {
        key = this.getKey(key);
        NavigableMap<KEY, ITEM> keyMultiValueSortedMap = this.navigableMap.headMap(key, false);
        return new ArrayList(keyMultiValueSortedMap.values());
    }

    @Override
    public List<ITEM> findGreaterThanEqual(KEY key) {
        key = this.getKey(key);
        SortedMap<KEY, ITEM> keyMultiValueSortedMap = this.navigableMap.tailMap(key);
        return new ArrayList<ITEM>(keyMultiValueSortedMap.values());
    }

    @Override
    public List<ITEM> findLessThanEqual(KEY key) {
        key = this.getKey(key);
        SortedMap<KEY, ITEM> keyMultiValueSortedMap = this.navigableMap.headMap(key);
        return new ArrayList<ITEM>(keyMultiValueSortedMap.values());
    }

    @Override
    public ITEM min() {
        return this.navigableMap.firstEntry().getValue();
    }

    @Override
    public ITEM max() {
        return this.navigableMap.lastEntry().getValue();
    }

    @Override
    public List<ITEM> getAll(KEY key) {
        return this.findEquals(key);
    }

    @Override
    public int size() {
        return this.navigableMap.size();
    }

    @Override
    public int count(KEY key) {
        return this.navigableMap.containsKey(key) ? 1 : 0;
    }
}

