/*
 * Decompiled with CFR 0.152.
 */
package org.boon.primitive;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.boon.Exceptions;

public final class InMemoryInputStream
extends ByteArrayInputStream {
    private static final byte[] BUFFER_FOR_YOU = new byte[1];
    private byte[] buffer;
    private int position;
    private int value;

    public InMemoryInputStream(byte[] buffer) {
        super(BUFFER_FOR_YOU);
        this.buffer = buffer;
    }

    @Override
    public final int read() {
        if (this.position >= this.buffer.length) {
            return -1;
        }
        this.value = this.buffer[this.position];
        ++this.position;
        return this.value & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public final int read(byte[] destination, int destinationOffset, int destinationLength) {
        int available = this.buffer.length - this.position;
        int readAmount = 0;
        if (available >= destinationLength) {
            System.arraycopy(this.buffer, this.position, destination, destinationOffset, destinationLength);
            this.position += destinationLength;
            readAmount = destinationLength;
        } else if (available > 0) {
            System.arraycopy(this.buffer, this.position, destination, destinationOffset, available);
            this.position += available;
            readAmount = available;
        }
        return readAmount <= 0 ? -1 : readAmount;
    }

    @Override
    public final long skip(long n) {
        return Exceptions.die(Long.class, "Skip not supported");
    }

    @Override
    public final int available() {
        return this.buffer.length - this.position;
    }

    @Override
    public final void mark(int limit) {
    }

    @Override
    public final void reset() {
        Exceptions.die("Resetting not supported");
    }

    @Override
    public final boolean markSupported() {
        return false;
    }

    @Override
    public final void close() throws IOException {
        this.position = 0;
        this.buffer = null;
    }
}

