/*
 * Decompiled with CFR 0.152.
 */
package io.findify.s3mock.provider.metadata;

import better.files.File;
import better.files.File$;
import com.amazonaws.services.s3.model.ObjectMetadata;
import io.findify.s3mock.provider.metadata.MetadataStore;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.Options;
import org.iq80.leveldb.impl.Iq80DBFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005a\u0001\u0002\u0007\u000e\u0001aA\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\u0006_\u0001!\t\u0001\r\u0005\bg\u0001\u0011\r\u0011\"\u00015\u0011\u00199\u0005\u0001)A\u0005k!)\u0001\n\u0001C!\u0013\")\u0011\r\u0001C!E\")\u0001\u000e\u0001C!S\")A\u000e\u0001C![\")q\u000e\u0001C\u0005a\")1\u000f\u0001C\u0005i\")A\u0010\u0001C\u0005{\n\u0001R*\u00199NKR\fG-\u0019;b'R|'/\u001a\u0006\u0003\u001d=\t\u0001\"\\3uC\u0012\fG/\u0019\u0006\u0003!E\t\u0001\u0002\u001d:pm&$WM\u001d\u0006\u0003%M\taa]\u001an_\u000e\\'B\u0001\u000b\u0016\u0003\u001d1\u0017N\u001c3jMfT\u0011AF\u0001\u0003S>\u001c\u0001aE\u0002\u00013}\u0001\"AG\u000f\u000e\u0003mQ\u0011\u0001H\u0001\u0006g\u000e\fG.Y\u0005\u0003=m\u0011a!\u00118z%\u00164\u0007C\u0001\u0011\"\u001b\u0005i\u0011B\u0001\u0012\u000e\u00055iU\r^1eCR\f7\u000b^8sK\u0006!\u0001/\u0019;i!\t)CF\u0004\u0002'UA\u0011qeG\u0007\u0002Q)\u0011\u0011fF\u0001\u0007yI|w\u000e\u001e \n\u0005-Z\u0012A\u0002)sK\u0012,g-\u0003\u0002.]\t11\u000b\u001e:j]\u001eT!aK\u000e\u0002\rqJg.\u001b;?)\t\t$\u0007\u0005\u0002!\u0001!)1E\u0001a\u0001I\u0005q!-^2lKRlU\r^1eCR\fW#A\u001b\u0011\tYZD%P\u0007\u0002o)\u0011\u0001(O\u0001\b[V$\u0018M\u00197f\u0015\tQ4$\u0001\u0006d_2dWm\u0019;j_:L!\u0001P\u001c\u0003\u00075\u000b\u0007\u000f\u0005\u0002?\u000b6\tqH\u0003\u0002A\u0003\u00069A.\u001a<fY\u0012\u0014'B\u0001\"D\u0003\u0011I\u0017\u000f\u000f\u0019\u000b\u0003\u0011\u000b1a\u001c:h\u0013\t1uH\u0001\u0002E\u0005\u0006y!-^2lKRlU\r^1eCR\f\u0007%A\u0002qkR$BAS'P#B\u0011!dS\u0005\u0003\u0019n\u0011A!\u00168ji\")a*\u0002a\u0001I\u00051!-^2lKRDQ\u0001U\u0003A\u0002\u0011\n1a[3z\u0011\u0015\u0011V\u00011\u0001T\u0003\u0011iW\r^1\u0011\u0005Q{V\"A+\u000b\u0005Y;\u0016!B7pI\u0016d'B\u0001-Z\u0003\t\u00198G\u0003\u0002[7\u0006A1/\u001a:wS\u000e,7O\u0003\u0002];\u0006I\u0011-\\1{_:\fwo\u001d\u0006\u0002=\u0006\u00191m\\7\n\u0005\u0001,&AD(cU\u0016\u001cG/T3uC\u0012\fG/Y\u0001\u0004O\u0016$HcA2gOB\u0019!\u0004Z*\n\u0005\u0015\\\"AB(qi&|g\u000eC\u0003O\r\u0001\u0007A\u0005C\u0003Q\r\u0001\u0007A%\u0001\u0004eK2,G/\u001a\u000b\u0004\u0015*\\\u0007\"\u0002(\b\u0001\u0004!\u0003\"\u0002)\b\u0001\u0004!\u0013A\u0002:f[>4X\r\u0006\u0002K]\")a\n\u0003a\u0001I\u0005!An\\1e)\ri\u0014O\u001d\u0005\u0006G%\u0001\r\u0001\n\u0005\u0006\u001d&\u0001\r\u0001J\u0001\u000b[\u0016$\u0018M\r2zi\u0016\u001cHCA;|!\rQb\u000f_\u0005\u0003on\u0011Q!\u0011:sCf\u0004\"AG=\n\u0005i\\\"\u0001\u0002\"zi\u0016DQA\u0015\u0006A\u0002M\u000b!BY=uKN\u0014T.\u001a;b)\t\u0019f\u0010C\u0003\u0000\u0017\u0001\u0007Q/A\u0003csR,7\u000f")
public class MapMetadataStore
implements MetadataStore {
    private final String path;
    private final Map<String, DB> bucketMetadata;

    public Map<String, DB> bucketMetadata() {
        return this.bucketMetadata;
    }

    @Override
    public void put(String bucket, String key, ObjectMetadata meta) {
        DB map = this.load(this.path, bucket);
        map.put(Iq80DBFactory.bytes((String)key), this.meta2bytes(meta));
    }

    @Override
    public Option<ObjectMetadata> get(String bucket, String key) {
        DB map = this.load(this.path, bucket);
        Option meta = Option$.MODULE$.apply((Object)map.get(Iq80DBFactory.bytes((String)key))).map((Function1 & Serializable)bytes -> this.bytes2meta((byte[])bytes));
        return meta;
    }

    @Override
    public void delete(String bucket, String key) {
        DB map = this.load(this.path, bucket);
        map.delete(Iq80DBFactory.bytes((String)key));
    }

    @Override
    public void remove(String bucket) {
        block0: {
            this.bucketMetadata().get((Object)bucket).foreach((Function1 & Serializable)db -> {
                db.close();
                return this.bucketMetadata().remove((Object)bucket);
            });
            File file = File$.MODULE$.apply(new StringBuilder(10).append(this.path).append("/").append(bucket).append(".metadata").toString(), (Seq)Nil$.MODULE$);
            if (!file.exists(file.exists$default$1())) break block0;
            file.delete(file.delete$default$1(), file.delete$default$2());
        }
    }

    private synchronized DB load(String path, String bucket) {
        DB dB;
        Option option = this.bucketMetadata().get((Object)bucket);
        if (option instanceof Some) {
            DB db;
            Some some = (Some)option;
            dB = db = (DB)some.value();
        } else if (None$.MODULE$.equals(option)) {
            Options options = new Options();
            options.createIfMissing(true);
            DB db = Iq80DBFactory.factory.open(File$.MODULE$.apply(new StringBuilder(10).append(path).append("/").append(bucket).append(".metadata").toString(), (Seq)Nil$.MODULE$).toJava(), options);
            this.bucketMetadata().put((Object)bucket, (Object)db);
            dB = db;
        } else {
            throw new MatchError((Object)option);
        }
        return dB;
    }

    private byte[] meta2bytes(ObjectMetadata meta) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutputStream stream = new ObjectOutputStream(out);
        stream.writeObject(meta);
        stream.close();
        return out.toByteArray();
    }

    private ObjectMetadata bytes2meta(byte[] bytes) {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        ObjectInputStream stream = new ObjectInputStream(in);
        return (ObjectMetadata)stream.readObject();
    }

    public MapMetadataStore(String path) {
        this.path = path;
        this.bucketMetadata = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

