/*
 * Decompiled with CFR 0.152.
 */
package io.fria.lilo;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JsonUtils {
    private static final ObjectMapper OBJECT_MAPPER = JsonUtils.createMapper();

    private JsonUtils() {
    }

    @NotNull
    public static Optional<Map<String, Object>> getMap(@NotNull Map<String, Object> map, @NotNull String key) {
        try {
            return Optional.ofNullable((Map)JsonUtils.getValue(map, key));
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Map item is not in map type");
        }
    }

    @NotNull
    public static Optional<List<Map<String, Object>>> getMapList(@NotNull Map<String, Object> map, @NotNull String key) {
        try {
            return Optional.ofNullable((List)JsonUtils.getValue(map, key));
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Map item is not in list type");
        }
    }

    @NotNull
    public static Optional<String> getName(@NotNull Map<String, Object> map) {
        return JsonUtils.getStr(map, "name");
    }

    @NotNull
    public static Optional<String> getStr(@NotNull Map<String, Object> map, @NotNull String key) {
        try {
            return Optional.ofNullable((String)JsonUtils.getValue(map, key));
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Map item is not in string type");
        }
    }

    @NotNull
    public static Optional<Map<String, Object>> toMap(@NotNull String jsonText) {
        try {
            return Optional.ofNullable((Map)OBJECT_MAPPER.readValue(Objects.requireNonNull(jsonText), (TypeReference)new TypeReference<Map<String, Object>>(){}));
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Deserialization exception", e);
        }
    }

    @NotNull
    public static <T> Optional<T> toObj(@NotNull String jsonText, Class<T> clazz) {
        try {
            return Optional.ofNullable(OBJECT_MAPPER.readValue(Objects.requireNonNull(jsonText), clazz));
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Deserialization exception", e);
        }
    }

    @NotNull
    public static String toStr(@Nullable Object obj) {
        try {
            return OBJECT_MAPPER.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Deserialization exception", e);
        }
    }

    @NotNull
    private static ObjectMapper createMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return mapper;
    }

    @Nullable
    private static Object getValue(@NotNull Map<String, Object> map, @NotNull String key) {
        return Objects.requireNonNull(map).get(Objects.requireNonNull(key));
    }
}

