/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.app;

import io.gatling.app.RunResult;
import io.gatling.app.cli.StatusCode;
import io.gatling.app.cli.StatusCode$AssertionsFailed$;
import io.gatling.app.cli.StatusCode$Success$;
import io.gatling.charts.report.ReportsGenerationInputs;
import io.gatling.charts.report.ReportsGenerator;
import io.gatling.charts.stats.LogFileData;
import io.gatling.charts.stats.LogFileReader$;
import io.gatling.commons.shared.unstable.model.stats.GeneralStatsSource;
import io.gatling.commons.shared.unstable.model.stats.assertion.AssertionResult;
import io.gatling.commons.shared.unstable.model.stats.assertion.AssertionValidator$;
import io.gatling.core.config.GatlingConfiguration;
import java.io.Serializable;
import java.nio.file.Path;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005E4A\u0001C\u0005\u0007!!Aq\u0003\u0001B\u0001B\u0003%\u0001\u0004C\u0003!\u0001\u0011\u0005\u0011\u0005C\u0003&\u0001\u0011\u0005a\u0005C\u00033\u0001\u0011%1\u0007C\u0003A\u0001\u0011%\u0011\tC\u0003F\u0001\u0011%a\tC\u0003S\u0001\u0011%1K\u0001\nSk:\u0014Vm];miB\u0013xnY3tg>\u0014(B\u0001\u0006\f\u0003\r\t\u0007\u000f\u001d\u0006\u0003\u00195\tqaZ1uY&twMC\u0001\u000f\u0003\tIwn\u0001\u0001\u0014\u0005\u0001\t\u0002C\u0001\n\u0016\u001b\u0005\u0019\"\"\u0001\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u0019\"AB!osJ+g-A\u0007d_:4\u0017nZ;sCRLwN\u001c\t\u00033yi\u0011A\u0007\u0006\u00037q\taaY8oM&<'BA\u000f\f\u0003\u0011\u0019wN]3\n\u0005}Q\"\u0001F$bi2LgnZ\"p]\u001aLw-\u001e:bi&|g.\u0001\u0004=S:LGO\u0010\u000b\u0003E\u0011\u0002\"a\t\u0001\u000e\u0003%AQa\u0006\u0002A\u0002a\t\u0001\u0003\u001d:pG\u0016\u001c8OU;o%\u0016\u001cX\u000f\u001c;\u0015\u0005\u001dj\u0003C\u0001\u0015,\u001b\u0005I#B\u0001\u0016\n\u0003\r\u0019G.[\u0005\u0003Y%\u0012!b\u0015;biV\u001c8i\u001c3f\u0011\u0015q3\u00011\u00010\u0003%\u0011XO\u001c*fgVdG\u000f\u0005\u0002$a%\u0011\u0011'\u0003\u0002\n%Vt'+Z:vYR\fq\"\u001b8ji2{wMR5mK\u0012\u000bG/\u0019\u000b\u0003i}\u00022AE\u001b8\u0013\t14C\u0001\u0004PaRLwN\u001c\t\u0003quj\u0011!\u000f\u0006\u0003um\nQa\u001d;biNT!\u0001P\u0006\u0002\r\rD\u0017M\u001d;t\u0013\tq\u0014HA\u0006M_\u001e4\u0015\u000e\\3ECR\f\u0007\"\u0002\u0018\u0005\u0001\u0004y\u0013\u0001\u0007:fa>\u0014Ho]$f]\u0016\u0014\u0018\r^5p]\u0016s\u0017M\u00197fIV\t!\t\u0005\u0002\u0013\u0007&\u0011Ai\u0005\u0002\b\u0005>|G.Z1o\u0003=9WM\\3sCR,'+\u001a9peR\u001cHCA$K!\t\u0011\u0002*\u0003\u0002J'\t!QK\\5u\u0011\u0015Ye\u00011\u0001M\u0003]\u0011X\r]8siN<UM\\3sCRLwN\\%oaV$8\u000f\u0005\u0002N!6\taJ\u0003\u0002Pw\u00051!/\u001a9peRL!!\u0015(\u0003/I+\u0007o\u001c:ug\u001e+g.\u001a:bi&|g.\u00138qkR\u001c\u0018!\u0003:v]N#\u0018\r^;t)\t9C\u000bC\u0003V\u000f\u0001\u0007a+\u0001\tbgN,'\u000f^5p]J+7/\u001e7ugB\u0019qk\u00182\u000f\u0005akfBA-]\u001b\u0005Q&BA.\u0010\u0003\u0019a$o\\8u}%\tA#\u0003\u0002_'\u00059\u0001/Y2lC\u001e,\u0017B\u00011b\u0005\u0011a\u0015n\u001d;\u000b\u0005y\u001b\u0002CA2p\u001b\u0005!'BA3g\u0003%\t7o]3si&|gN\u0003\u0002;O*\u0011\u0001.[\u0001\u0006[>$W\r\u001c\u0006\u0003U.\f\u0001\"\u001e8ti\u0006\u0014G.\u001a\u0006\u0003Y6\faa\u001d5be\u0016$'B\u00018\f\u0003\u001d\u0019w.\\7p]NL!\u0001\u001d3\u0003\u001f\u0005\u001b8/\u001a:uS>t'+Z:vYR\u0004")
public final class RunResultProcessor {
    private final GatlingConfiguration configuration;

    public StatusCode processRunResult(RunResult runResult) {
        Option<LogFileData> option = this.initLogFileData(runResult);
        if (option instanceof Some) {
            Some some = (Some)option;
            LogFileData logFileData = (LogFileData)some.value();
            List assertionResults = AssertionValidator$.MODULE$.validateAssertions((GeneralStatsSource)logFileData);
            if (this.reportsGenerationEnabled()) {
                ReportsGenerationInputs reportsGenerationInputs = new ReportsGenerationInputs(runResult.runId(), logFileData, assertionResults);
                this.generateReports(reportsGenerationInputs);
            }
            return this.runStatus((List<AssertionResult>)assertionResults);
        }
        return StatusCode$Success$.MODULE$;
    }

    private Option<LogFileData> initLogFileData(RunResult runResult) {
        if (this.reportsGenerationEnabled() || runResult.hasAssertions()) {
            Predef$.MODULE$.println((Object)"Parsing log file(s)...");
            LogFileData logFileData = LogFileReader$.MODULE$.apply(runResult.runId(), this.configuration).read();
            Predef$.MODULE$.println((Object)"Parsing log file(s) done");
            return new Some((Object)logFileData);
        }
        return None$.MODULE$;
    }

    private boolean reportsGenerationEnabled() {
        return this.configuration.core().directory().reportsOnly().isDefined() || this.configuration.data().fileDataWriterEnabled() && !this.configuration.charting().noReports();
    }

    private void generateReports(ReportsGenerationInputs reportsGenerationInputs) {
        Predef$.MODULE$.println((Object)"Generating reports...");
        long start = System.currentTimeMillis();
        Path indexFile = new ReportsGenerator(this.configuration).generateFor(reportsGenerationInputs);
        Predef$.MODULE$.println((Object)new StringBuilder(23).append("Reports generated in ").append((System.currentTimeMillis() - start) / 1000L).append("s.").toString());
        Predef$.MODULE$.println((Object)new StringBuilder(32).append("Please open the following file: ").append(indexFile.toUri()).toString());
    }

    private StatusCode runStatus(List<AssertionResult> assertionResults) {
        boolean consolidatedAssertionResult = BoxesRunTime.unboxToBoolean((Object)assertionResults.foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2 & Serializable)(isValid, assertionResult) -> BoxesRunTime.boxToBoolean((boolean)RunResultProcessor.$anonfun$runStatus$1(BoxesRunTime.unboxToBoolean((Object)isValid), assertionResult))));
        if (consolidatedAssertionResult) {
            return StatusCode$Success$.MODULE$;
        }
        return StatusCode$AssertionsFailed$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$runStatus$1(boolean isValid, AssertionResult assertionResult) {
        Predef$.MODULE$.println((Object)new StringBuilder(3).append(assertionResult.message()).append(" : ").append(assertionResult.result()).toString());
        return isValid && assertionResult.result();
    }

    public RunResultProcessor(GatlingConfiguration configuration) {
        this.configuration = configuration;
    }
}

