/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.charts.component;

import io.gatling.charts.component.Component;
import io.gatling.charts.stats.RunInfo;
import io.gatling.charts.util.HtmlHelper$;
import io.gatling.charts.util.HtmlHelper$HtmlRichString$;
import io.gatling.commons.util.GatlingVersion$;
import io.gatling.commons.util.StringHelper;
import io.gatling.commons.util.StringHelper$;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005}2QAB\u0004\u0003\u0013=A\u0001B\u0007\u0001\u0003\u0002\u0003\u0006I\u0001\b\u0005\u0006E\u0001!\ta\t\u0005\u0006M\u0001!\te\n\u0005\u0006g\u0001!\te\n\u0005\u0006i\u0001!\t%\u000e\u0002\u0018'&lW\u000f\\1uS>t7)\u0019:e\u0007>l\u0007o\u001c8f]RT!\u0001C\u0005\u0002\u0013\r|W\u000e]8oK:$(B\u0001\u0006\f\u0003\u0019\u0019\u0007.\u0019:ug*\u0011A\"D\u0001\bO\u0006$H.\u001b8h\u0015\u0005q\u0011AA5p'\r\u0001\u0001C\u0006\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)1oY1mC&\u0011QC\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005]AR\"A\u0004\n\u0005e9!!C\"p[B|g.\u001a8u\u0003\u001d\u0011XO\\%oM>\u001c\u0001\u0001\u0005\u0002\u001eA5\taD\u0003\u0002 \u0013\u0005)1\u000f^1ug&\u0011\u0011E\b\u0002\b%Vt\u0017J\u001c4p\u0003\u0019a\u0014N\\5u}Q\u0011A%\n\t\u0003/\u0001AQA\u0007\u0002A\u0002q\tA\u0001\u001b;nYV\t\u0001\u0006\u0005\u0002*a9\u0011!F\f\t\u0003WIi\u0011\u0001\f\u0006\u0003[m\ta\u0001\u0010:p_Rt\u0014BA\u0018\u0013\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011G\r\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005=\u0012\u0012A\u00016t\u0003\u001dQ7OR5mKN,\u0012A\u000e\t\u0004oqBcB\u0001\u001d;\u001d\tY\u0013(C\u0001\u0014\u0013\tY$#A\u0004qC\u000e\\\u0017mZ3\n\u0005ur$aA*fc*\u00111H\u0005")
public final class SimulationCardComponent
implements Component {
    private final RunInfo runInfo;

    @Override
    public String html() {
        String printableRunDateTime = DateTimeFormatter.ofPattern("uuuu-MM-dd HH:mm:ss").withZone(ZoneId.of("UTC")).format(Instant.ofEpochMilli(this.runInfo.injectStart()));
        String printableGatlingReleaseDate = GatlingVersion$.MODULE$.ThisVersion().releaseDate().toLocalDate().toString();
        Duration duration = Duration.ofMillis(this.runInfo.injectEnd() - this.runInfo.injectStart());
        long days = duration.toDays();
        Duration minusDays = duration.minusDays(days);
        long hours = minusDays.toHours();
        Duration minusHours = minusDays.minusHours(hours);
        long minutes = minusHours.toMinutes();
        long seconds = minusHours.minusMinutes(minutes).getSeconds();
        String printableDuration = new StringBuilder(0).append(days > 0L ? new StringBuilder(2).append(days).append("d ").toString() : "").append((Object)(hours > 0L ? new StringBuilder(2).append(hours).append("h ").toString() : (days > 0L ? "0h" : ""))).append((Object)(minutes > 0L ? new StringBuilder(2).append(minutes).append("m ").toString() : (days > 0L || hours > 0L ? "0m" : ""))).append((Object)(seconds > 0L ? new StringBuilder(2).append(seconds).append("s ").toString() : "0s")).toString();
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(1190).append("<div class=\"simulation-card\">\n       |  <div class=\"simulation-version-information\">\n       |  <span class=\"simulation-information-title\">Gatling Version</span>\n       |    <span class=\"simulation-information-item\">\n       |      <span class=\"simulation-information-label\">Version: </span>\n       |      <span>").append(GatlingVersion$.MODULE$.ThisVersion().fullVersion()).append("</span>\n       |    </span>\n       |    <span class=\"simulation-information-item\">\n       |      <span class=\"simulation-information-label\">Released: </span>\n       |      <span>").append(printableGatlingReleaseDate).append("</span>\n       |    </span>\n       |  </div>\n       |  <div id=\"simulation-information\" class=\"simulation-version-information\">\n       |    <span class=\"simulation-information-title\">Run Information</span>\n       |    <div class=\"simulation-information-container\">\n       |      <span class=\"simulation-information-item\">\n       |        <span class=\"simulation-information-label\">Date: </span>\n       |        <span>").append(printableRunDateTime).append(" GMT</span>\n       |      </span>\n       |      <span class=\"simulation-information-item\">\n       |        <span class=\"simulation-information-label\">Duration: </span>\n       |        <span>").append(printableDuration).append("</span>\n       |      </span>\n       |      ").append((Object)(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.runInfo.runDescription())) ? StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(250).append("<span class=\"simulation-tooltip simulation-information-item description\" title=\"Description\" data-content=\"").append(HtmlHelper$HtmlRichString$.MODULE$.htmlEscape$extension(HtmlHelper$.MODULE$.HtmlRichString(this.runInfo.runDescription()))).append("\">\n       |        <span class=\"simulation-information-label\">Description: </span>\n       |        <span>").append(HtmlHelper$HtmlRichString$.MODULE$.htmlEscape$extension(HtmlHelper$.MODULE$.HtmlRichString(StringHelper.RichString$.MODULE$.truncate$extension(StringHelper$.MODULE$.RichString(this.runInfo.runDescription()), 2300)))).append("</span>\n       |      </span>\n       |").toString())) : StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("<span class=\"simulation-information-item\">\n        |        <span class=\"simulation-information-label\">Description: </span>\n        |        <span>&mdash;</span>\n        |      </span>\n        |")))).append("\n       |    </div>\n       |  </div>\n       |</div>").toString()));
    }

    @Override
    public String js() {
        return "";
    }

    @Override
    public Seq<String> jsFiles() {
        return package$.MODULE$.Nil();
    }

    public SimulationCardComponent(RunInfo runInfo) {
        this.runInfo = runInfo;
    }
}

