/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.javaapi.core;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.protocol.Protocol;
import io.gatling.core.scenario.Simulation$;
import io.gatling.core.scenario.SimulationParams;
import io.gatling.javaapi.core.Assertion;
import io.gatling.javaapi.core.PauseType;
import io.gatling.javaapi.core.PopulationBuilder;
import io.gatling.javaapi.core.ProtocolBuilder;
import io.gatling.javaapi.core.Session;
import io.gatling.javaapi.core.ThrottleStep;
import io.gatling.javaapi.core.internal.Converters;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import scala.Option;

public abstract class Simulation {
    private List<PopulationBuilder> _populationBuilders = new ArrayList<PopulationBuilder>();
    private Map<Class<? extends Protocol>, Protocol> _globalProtocols = new HashMap<Class<? extends Protocol>, Protocol>();
    private List<Assertion> _assertions = new ArrayList<Assertion>();
    private Duration _maxDuration;
    private PauseType _globalPauseType = PauseType.Constant;
    private List<ThrottleStep> _globalThrottleSteps = new ArrayList<ThrottleStep>();

    public void before() {
    }

    public void after() {
    }

    @NonNull
    public SetUp setUp(PopulationBuilder ... populationBuilderArray) {
        return this.setUp(Arrays.asList(populationBuilderArray));
    }

    @NonNull
    public SetUp setUp(@NonNull List<PopulationBuilder> list) {
        if (!this._populationBuilders.isEmpty()) {
            throw new UnsupportedOperationException("Can only call setUp once");
        }
        this._populationBuilders = list;
        return new SetUp();
    }

    public SimulationParams params(GatlingConfiguration gatlingConfiguration, @Nullable String string) {
        return Simulation$.MODULE$.params(string != null ? string : this.getClass().getName(), Converters.toScalaSeq(this._populationBuilders.stream().map(PopulationBuilder::asScala).collect(Collectors.toList())).toList(), Converters.toScalaMap(this._globalProtocols), Converters.toScalaSeq(this._assertions.stream().map(Assertion::asScala).collect(Collectors.toList())), Option.apply((Object)this._maxDuration).map(Converters::toScalaDuration), this._globalPauseType.asScala(), Converters.toScalaSeq(this._globalThrottleSteps.stream().map(ThrottleStep::asScala).collect(Collectors.toList())), () -> {
            this.before();
            return null;
        }, () -> {
            this.after();
            return null;
        }, gatlingConfiguration);
    }

    public class SetUp {
        private SetUp() {
        }

        @NonNull
        public SetUp protocols(ProtocolBuilder ... protocolBuilderArray) {
            return this.protocols(Arrays.asList(protocolBuilderArray));
        }

        @NonNull
        public SetUp protocols(@NonNull List<ProtocolBuilder> list) {
            Simulation.this._globalProtocols = list.stream().map(ProtocolBuilder::protocol).collect(Collectors.toMap(Protocol::getClass, Function.identity()));
            return this;
        }

        @NonNull
        public SetUp assertions(Assertion ... assertionArray) {
            return this.assertions(Arrays.asList(assertionArray));
        }

        @NonNull
        public SetUp assertions(@NonNull List<Assertion> list) {
            Simulation.this._assertions = list;
            return this;
        }

        @NonNull
        public SetUp maxDuration(long l) {
            return this.maxDuration(Duration.ofSeconds(l));
        }

        @NonNull
        public SetUp maxDuration(@NonNull Duration duration) {
            Simulation.this._maxDuration = duration;
            return this;
        }

        @NonNull
        public SetUp throttle(ThrottleStep ... throttleStepArray) {
            return this.throttle(Arrays.asList(throttleStepArray));
        }

        @NonNull
        public SetUp throttle(@NonNull List<ThrottleStep> list) {
            Simulation.this._globalThrottleSteps = list;
            return this;
        }

        @NonNull
        public SetUp disablePauses() {
            return this.pauses(PauseType.Disabled);
        }

        @NonNull
        public SetUp constantPauses() {
            return this.pauses(PauseType.Constant);
        }

        @NonNull
        public SetUp exponentialPauses() {
            return this.pauses(PauseType.Exponential);
        }

        @NonNull
        public SetUp customPauses(@NonNull Function<Session, Long> function) {
            return this.pauses(new PauseType.Custom(function));
        }

        @NonNull
        public SetUp uniformPauses(double d) {
            return this.pauses(new PauseType.UniformPercentage(d));
        }

        @NonNull
        public SetUp uniformPauses(@NonNull Duration duration) {
            return this.pauses(new PauseType.UniformDuration(duration));
        }

        @NonNull
        public SetUp normalPausesWithStdDevDuration(Duration duration) {
            return this.pauses(new PauseType.NormalWithStdDevDuration(duration));
        }

        @NonNull
        public SetUp normalPausesWithPercentageDuration(double d) {
            return this.pauses(new PauseType.NormalWithPercentageDuration(d));
        }

        @NonNull
        public SetUp pauses(@NonNull PauseType pauseType) {
            Simulation.this._globalPauseType = pauseType;
            return this;
        }
    }
}

