/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.stats.writer;

import io.gatling.commons.stats.KO$;
import io.gatling.commons.stats.OK$;
import io.gatling.commons.stats.Status;
import io.gatling.commons.util.Clock;
import io.gatling.core.actor.Cancellable;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.stats.writer.ConsoleData;
import io.gatling.core.stats.writer.ConsoleSummary;
import io.gatling.core.stats.writer.ConsoleSummary$;
import io.gatling.core.stats.writer.DataWriter;
import io.gatling.core.stats.writer.DataWriterMessage;
import io.gatling.core.stats.writer.DataWriterMessage$Flush$;
import io.gatling.core.stats.writer.RequestCounters;
import io.gatling.core.stats.writer.RequestCounters$;
import io.gatling.core.stats.writer.UserCounters;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005ua!\u0002\u0007\u000e\u0005M9\u0002\u0002C\u0010\u0001\u0005\u0003\u0005\u000b\u0011B\u0011\t\u0011%\u0002!\u0011!Q\u0001\n)BQ\u0001\r\u0001\u0005\u0002EBQ!\u000e\u0001\u0005BYBQ\u0001\u0011\u0001\u0005B\u0005CQA\u0013\u0001\u0005B-CQA\u0015\u0001\u0005\nMCQA\u0018\u0001\u0005\n}CQa\u001d\u0001\u0005\nQDQa\u001f\u0001\u0005BqDq!a\u0006\u0001\t\u0003\nIBA\tD_:\u001cx\u000e\\3ECR\fwK]5uKJT!AD\b\u0002\r]\u0014\u0018\u000e^3s\u0015\t\u0001\u0012#A\u0003ti\u0006$8O\u0003\u0002\u0013'\u0005!1m\u001c:f\u0015\t!R#A\u0004hCRd\u0017N\\4\u000b\u0003Y\t!![8\u0014\u0005\u0001A\u0002cA\r\u001b95\tQ\"\u0003\u0002\u001c\u001b\tQA)\u0019;b/JLG/\u001a:\u0011\u0005ei\u0012B\u0001\u0010\u000e\u0005-\u0019uN\\:pY\u0016$\u0015\r^1\u0002\u000b\rdwnY6\u0004\u0001A\u0011!eJ\u0007\u0002G)\u0011A%J\u0001\u0005kRLGN\u0003\u0002''\u000591m\\7n_:\u001c\u0018B\u0001\u0015$\u0005\u0015\u0019En\\2l\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]B\u00111FL\u0007\u0002Y)\u0011Q&E\u0001\u0007G>tg-[4\n\u0005=b#\u0001F$bi2LgnZ\"p]\u001aLw-\u001e:bi&|g.\u0001\u0004=S:LGO\u0010\u000b\u0004eM\"\u0004CA\r\u0001\u0011\u0015y2\u00011\u0001\"\u0011\u0015I3\u00011\u0001+\u0003\u0019yg.\u00138jiR\u0011Ad\u000e\u0005\u0006q\u0011\u0001\r!O\u0001\u0005S:LG\u000f\u0005\u0002;{9\u0011\u0011dO\u0005\u0003y5\t\u0011\u0003R1uC^\u0013\u0018\u000e^3s\u001b\u0016\u001c8/Y4f\u0013\tqtH\u0001\u0003J]&$(B\u0001\u001f\u000e\u0003\u001dygN\u00127vg\"$\"A\u0011%\u0011\u0005\r3U\"\u0001#\u000b\u0003\u0015\u000bQa]2bY\u0006L!a\u0012#\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u0013\u0016\u0001\r\u0001H\u0001\u0005I\u0006$\u0018-A\u0005p]6+7o]1hKR\u0019!\tT)\t\u000b53\u0001\u0019\u0001(\u0002\u000f5,7o]1hKB\u0011!hT\u0005\u0003!~\u0012\u0011\u0002T8bI\u00163XM\u001c;\t\u000b%3\u0001\u0019\u0001\u000f\u0002\u001b=tWk]3s\u001b\u0016\u001c8/Y4f)\r\u0011E+\u0018\u0005\u0006+\u001e\u0001\rAV\u0001\u0005kN,'\u000f\u0005\u0002X5:\u0011!\bW\u0005\u00033~\n\u0011\u0002T8bI\u00163XM\u001c;\n\u0005mc&\u0001B+tKJT!!W \t\u000b%;\u0001\u0019\u0001\u000f\u0002#=t'+Z:q_:\u001cX-T3tg\u0006<W\rF\u0002CA\u0016DQ!\u0019\u0005A\u0002\t\f\u0001B]3ta>t7/\u001a\t\u0003/\u000eL!\u0001\u001a/\u0003\u0011I+7\u000f]8og\u0016DQ!\u0013\u0005A\u0002qAC\u0001C4paB\u0011\u0001.\\\u0007\u0002S*\u0011!n[\u0001\u0005Y\u0006twMC\u0001m\u0003\u0011Q\u0017M^1\n\u00059L'\u0001E*vaB\u0014Xm]:XCJt\u0017N\\4t\u0003\u00151\u0018\r\\;fY\u0005\t\u0018%\u0001:\u0002A=\u0014xML<beR\u0014X-\\8wKJts/\u0019:ug:b\u0015n\u001d;BaB,g\u000eZ\u0001\u000f_:,%O]8s\u001b\u0016\u001c8/Y4f)\r\u0011UO\u001f\u0005\u0006m&\u0001\ra^\u0001\u0006KJ\u0014xN\u001d\t\u0003/bL!!\u001f/\u0003\u000b\u0015\u0013(o\u001c:\t\u000b%K\u0001\u0019\u0001\u000f\u0002\u000f=t7I]1tQR!!)`A\u000b\u0011\u0015q(\u00021\u0001\u0000\u0003\u0015\u0019\u0017-^:f!\u0011\t\t!a\u0004\u000f\t\u0005\r\u00111\u0002\t\u0004\u0003\u000b!UBAA\u0004\u0015\r\tI\u0001I\u0001\u0007yI|w\u000e\u001e \n\u0007\u00055A)\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003#\t\u0019B\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u001b!\u0005\"B%\u000b\u0001\u0004a\u0012AB8o'R|\u0007\u000fF\u0002C\u00037AQ!S\u0006A\u0002q\u0001")
public final class ConsoleDataWriter
extends DataWriter<ConsoleData> {
    private final Clock clock;
    private final GatlingConfiguration configuration;

    @Override
    public ConsoleData onInit(DataWriterMessage.Init init2) {
        Cancellable timer = this.scheduler().scheduleAtFixedRate(this.configuration.data().console().writePeriod(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.self().$bang(DataWriterMessage$Flush$.MODULE$));
        ConsoleData data = new ConsoleData(this.clock.nowMillis(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss O").withZone(init2.runMessage().zoneId()), timer);
        init2.scenarios().foreach((Function1 & Serializable)scenario -> data.usersCounters().put((Object)scenario.name(), (Object)new UserCounters(scenario.totalUserCount())));
        return data;
    }

    @Override
    public void onFlush(ConsoleData data) {
        long runDuration = (this.clock.nowMillis() - data.startUpTime()) / 1000L;
        ConsoleSummary summary = ConsoleSummary$.MODULE$.apply(runDuration, data.usersCounters(), data.globalRequestCounters(), data.requestsCounters(), data.errorsCounters(), this.configuration, ZonedDateTime.now(), data.dateTimeFormatter());
        data.complete_$eq(summary.complete());
        Predef$.MODULE$.println((Object)summary.text());
    }

    @Override
    public void onMessage(DataWriterMessage.LoadEvent message, ConsoleData data) {
        DataWriterMessage.LoadEvent loadEvent = message;
        if (loadEvent instanceof DataWriterMessage.LoadEvent.User) {
            DataWriterMessage.LoadEvent.User user = (DataWriterMessage.LoadEvent.User)loadEvent;
            this.onUserMessage(user, data);
            return;
        }
        if (loadEvent instanceof DataWriterMessage.LoadEvent.Response) {
            DataWriterMessage.LoadEvent.Response response = (DataWriterMessage.LoadEvent.Response)loadEvent;
            this.onResponseMessage(response, data);
            return;
        }
        if (loadEvent instanceof DataWriterMessage.LoadEvent.Error) {
            DataWriterMessage.LoadEvent.Error error = (DataWriterMessage.LoadEvent.Error)loadEvent;
            this.onErrorMessage(error, data);
            return;
        }
    }

    private void onUserMessage(DataWriterMessage.LoadEvent.User user, ConsoleData data) {
        Option option = data.usersCounters().get((Object)user.scenario());
        if (option instanceof Some) {
            Some some = (Some)option;
            UserCounters userCounters = (UserCounters)some.value();
            if (user.start()) {
                userCounters.userStart();
                return;
            }
            userCounters.userDone();
            return;
        }
        if (this.logger().underlying().isErrorEnabled()) {
            this.logger().underlying().error("Internal error, scenario '{}' has not been correctly initialized", (Object)user.scenario());
            return;
        }
    }

    private void onResponseMessage(DataWriterMessage.LoadEvent.Response response, ConsoleData data) {
        String requestPath = ((IterableOnceOps)response.groupHierarchy().$colon$plus((Object)response.name())).mkString(" / ");
        RequestCounters requestCounters = (RequestCounters)data.requestsCounters().getOrElseUpdate((Object)requestPath, (Function0 & Serializable)() -> RequestCounters$.MODULE$.empty());
        Status status = response.status();
        if (OK$.MODULE$.equals(status)) {
            data.globalRequestCounters().successfulCount_$eq(data.globalRequestCounters().successfulCount() + 1);
            requestCounters.successfulCount_$eq(requestCounters.successfulCount() + 1);
            return;
        }
        if (KO$.MODULE$.equals(status)) {
            data.globalRequestCounters().failedCount_$eq(data.globalRequestCounters().failedCount() + 1);
            requestCounters.failedCount_$eq(requestCounters.failedCount() + 1);
            String errorMessage = (String)response.message().getOrElse((Function0 & Serializable)() -> "<no-message>");
            data.errorsCounters().update((Object)errorMessage, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)data.errorsCounters().getOrElse((Object)errorMessage, (Function0)(JFunction0.mcI.sp & Serializable)() -> 0)) + 1)));
            return;
        }
        throw new MatchError((Object)status);
    }

    private void onErrorMessage(DataWriterMessage.LoadEvent.Error error, ConsoleData data) {
        data.errorsCounters().update((Object)error.message(), (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)data.errorsCounters().getOrElse((Object)error.message(), (Function0)(JFunction0.mcI.sp & Serializable)() -> 0)) + 1)));
    }

    @Override
    public void onCrash(String cause, ConsoleData data) {
    }

    @Override
    public void onStop(ConsoleData data) {
        data.timer().cancel();
        if (!data.complete()) {
            this.onFlush(data);
            return;
        }
    }

    public ConsoleDataWriter(Clock clock, GatlingConfiguration configuration) {
        this.clock = clock;
        this.configuration = configuration;
        super("console-data-writer");
    }
}

