/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.plugin.client.http.api;

import com.fasterxml.jackson.core.type.TypeReference;
import io.gatling.plugin.client.http.api.AbstractApi;
import io.gatling.plugin.client.http.api.ApiPath;
import io.gatling.plugin.client.http.api.HttpResponse;
import io.gatling.plugin.client.http.responses.RequestsSummaryResponse;
import io.gatling.plugin.client.http.responses.RunInformationResponse;
import io.gatling.plugin.client.http.responses.SeriesResponse;
import io.gatling.plugin.exceptions.EnterprisePluginException;
import io.gatling.plugin.exceptions.RunNotFoundException;
import java.net.URL;
import java.util.List;
import java.util.UUID;

public class RunsApi
extends AbstractApi {
    private static final ApiPath RUN_PATH = ApiPath.of("run");
    private static final ApiPath SERIES_PATH = ApiPath.of("series");
    private static final ApiPath SUMMARY_PATH = ApiPath.of("summaries", "requests");

    public RunsApi(URL uRL, String string) {
        super(uRL, string);
    }

    public RunInformationResponse getRunInformation(UUID uUID) throws EnterprisePluginException {
        return this.getJson(RUN_PATH.addQueryParam("run", uUID.toString()), RunInformationResponse.class, (HttpResponse httpResponse) -> {
            if (httpResponse.code == 404) {
                throw new RunNotFoundException(uUID);
            }
        });
    }

    public List<SeriesResponse> getConcurrentUserMetric(UUID uUID, String string) throws EnterprisePluginException {
        return this.getJson(SERIES_PATH.addQueryParam("run", uUID.toString()).addQueryParam("scenario", string).addQueryParam("group", "").addQueryParam("request", "").addQueryParam("node", "").addQueryParam("remote", "").addQueryParam("metric", "usrActive"), new TypeReference<List<SeriesResponse>>(){});
    }

    public RequestsSummaryResponse getRequestsSummary(UUID uUID) throws EnterprisePluginException {
        return this.getJson(SUMMARY_PATH.addQueryParam("run", uUID.toString()), RequestsSummaryResponse.class);
    }
}

