/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.plugin.util;

import io.gatling.plugin.io.PluginLogger;
import io.gatling.plugin.util.ForkMain;
import io.gatling.plugin.util.Os;
import io.gatling.plugin.util.SystemProperties;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.stream.Collectors;

public final class Fork {
    private static final String GATLING_MANIFEST_VALUE = "GATLING_ZINC";
    private final File javaExecutable;
    private final String mainClassName;
    private final List<String> classpath;
    private final PluginLogger log;
    private final File workingDirectory;
    private final List<String> jvmArgs;
    private final List<String> args;

    public Fork(String string, List<String> list, List<String> list2, List<String> list3, File file, PluginLogger pluginLogger, File file2) {
        this.mainClassName = string;
        this.classpath = list;
        this.jvmArgs = Collections.unmodifiableList(list2);
        this.args = Collections.unmodifiableList(list3);
        this.javaExecutable = file;
        this.log = pluginLogger;
        this.workingDirectory = file2;
    }

    private static String toWindowsShortName(String string) {
        int n;
        if (Os.IS_WINDOWS && (n = string.indexOf("Program Files")) >= 0) {
            int n2 = string.indexOf(File.separator, n + "Program Files".length());
            File file = n2 < 0 ? new File(string) : new File(string.substring(0, n2));
            for (int i = 0; i < 10; ++i) {
                File file2 = new File(file.getParent(), "Progra~" + i);
                if (!file2.equals(file)) continue;
                return file2.toString();
            }
        }
        return string;
    }

    private String safe(String string) {
        return string.contains(" ") ? "\"" + string + "\"" : string;
    }

    private static String escape(String string) {
        StringBuilder stringBuilder = new StringBuilder(2 * string.length());
        block12: for (char c : string.toCharArray()) {
            if (c > '\u0fff') {
                stringBuilder.append("\\u").append(Integer.toHexString(c));
                continue;
            }
            if (c > '\u00ff') {
                stringBuilder.append("\\u0").append(Integer.toHexString(c));
                continue;
            }
            if (c > '\u007f') {
                stringBuilder.append("\\u00").append(Integer.toHexString(c));
                continue;
            }
            if (c < ' ') {
                switch (c) {
                    case '\b': {
                        stringBuilder.append('\\').append('b');
                        break;
                    }
                    case '\n': {
                        stringBuilder.append('\\').append('n');
                        break;
                    }
                    case '\t': {
                        stringBuilder.append('\\').append('t');
                        break;
                    }
                    case '\f': {
                        stringBuilder.append('\\').append('f');
                        break;
                    }
                    case '\r': {
                        stringBuilder.append('\\').append('r');
                        break;
                    }
                    default: {
                        if (c > '\u000f') {
                            stringBuilder.append("\\u00").append(Integer.toHexString(c));
                            break;
                        }
                        stringBuilder.append("\\u000").append(Integer.toHexString(c));
                        break;
                    }
                }
                continue;
            }
            switch (c) {
                case '\'': {
                    stringBuilder.append('\\').append('\'');
                    continue block12;
                }
                case '\"': {
                    stringBuilder.append('\\').append('\"');
                    continue block12;
                }
                case '\\': {
                    stringBuilder.append('\\').append('\\');
                    continue block12;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    public void run() throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>(this.jvmArgs.size() + 5);
        arrayList.add(Fork.toWindowsShortName(this.javaExecutable.getCanonicalPath()));
        arrayList.addAll(this.jvmArgs);
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            String string = entry.getKey().toString();
            if (!SystemProperties.isSystemPropertyPropagated(string)) continue;
            String string2 = Fork.toWindowsShortName(entry.getValue().toString());
            if (string.contains(" ")) {
                this.log.error("System property (" + string + ", " + string2 + "') has a name that contains a whitespace and can't be propagated");
                continue;
            }
            if (Os.IS_WINDOWS && string2.contains(" ")) {
                this.log.error("System property (" + string + ", " + string2 + "') has a value that contains a whitespace and can't be propagated on Windows");
                continue;
            }
            arrayList.add("-D" + string + "=" + this.safe(Fork.escape(string2)));
        }
        arrayList.add("-jar");
        arrayList.add(Fork.createBooterJar(this.classpath, this.args).getCanonicalPath());
        arrayList.add(this.mainClassName);
        Process process = new ProcessBuilder(arrayList).directory(this.workingDirectory).inheritIO().start();
        process.getOutputStream().close();
        int n = process.waitFor();
        if (n != 0) {
            throw new ForkException(n);
        }
    }

    private static File createBooterJar(List<String> list, List<String> list2) throws IOException {
        File file = File.createTempFile("gatlingbooter", ".jar");
        file.deleteOnExit();
        String string2 = list.stream().map(string -> Fork.getURL(new File((String)string)).toExternalForm()).collect(Collectors.joining(" "));
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().putValue(Attributes.Name.MANIFEST_VERSION.toString(), "1.0");
        manifest.getMainAttributes().putValue(Attributes.Name.CLASS_PATH.toString(), string2);
        manifest.getMainAttributes().putValue(Attributes.Name.MAIN_CLASS.toString(), ForkMain.class.getName());
        manifest.getMainAttributes().putValue(GATLING_MANIFEST_VALUE, "true");
        try (JarOutputStream jarOutputStream = new JarOutputStream(new BufferedOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0])));){
            jarOutputStream.setLevel(0);
            JarEntry jarEntry = new JarEntry("META-INF/MANIFEST.MF");
            jarOutputStream.putNextEntry(jarEntry);
            manifest.write(jarOutputStream);
            jarOutputStream.closeEntry();
            JarEntry jarEntry2 = new JarEntry("META-INF/args.txt");
            jarOutputStream.putNextEntry(jarEntry2);
            byte[] byArray = list2.stream().collect(Collectors.joining("\n")).getBytes(StandardCharsets.UTF_8);
            jarOutputStream.write(byArray);
            jarOutputStream.closeEntry();
        }
        return file;
    }

    private static URL getURL(File file) {
        try {
            return new URL(file.toURI().toASCIIString());
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    public static final class ForkException
    extends Exception {
        public final int exitValue;

        public ForkException(int n) {
            this.exitValue = n;
        }
    }
}

