/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.plugin.util;

import io.gatling.plugin.io.PluginLogger;
import io.gatling.plugin.util.MainWithArgsInFile;
import io.gatling.plugin.util.Os;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;

public final class Fork {
    private static final String ARG_FILE_PREFIX = "gatling-";
    private static final String ARG_FILE_SUFFIX = ".args";
    private static final String GATLING_MANIFEST_VALUE = "GATLING_ZINC";
    private final File javaExecutable;
    private final String mainClassName;
    private final List<String> classpath;
    private final boolean propagateSystemProperties;
    private final PluginLogger log;
    private final File workingDirectory;
    private final List<String> jvmArgs = new ArrayList<String>();
    private final List<String> args = new ArrayList<String>();

    public Fork(String string, List<String> list, List<String> list2, List<String> list3, File file, boolean bl, PluginLogger pluginLogger) {
        this(string, list, list2, list3, file, bl, pluginLogger, null);
    }

    public Fork(String string, List<String> list, List<String> list2, List<String> list3, File file, boolean bl, PluginLogger pluginLogger, File file2) {
        this.mainClassName = string;
        this.classpath = list;
        this.jvmArgs.addAll(list2);
        this.args.addAll(list3);
        this.javaExecutable = file;
        this.propagateSystemProperties = bl;
        this.log = pluginLogger;
        this.workingDirectory = file2;
    }

    public static String toWindowsShortName(String string) {
        int n;
        if (Os.IS_WINDOWS && (n = string.indexOf("Program Files")) >= 0) {
            int n2 = string.indexOf(File.separator, n + "Program Files".length());
            File file = n2 < 0 ? new File(string) : new File(string.substring(0, n2));
            for (int i = 0; i < 10; ++i) {
                File file2 = new File(file.getParent(), "Progra~" + i);
                if (!file2.equals(file)) continue;
                return file2.toString();
            }
        }
        return string;
    }

    private String safe(String string) {
        return string.contains(" ") ? '\"' + string + '\"' : string;
    }

    private static String escape(String string) {
        StringBuilder stringBuilder = new StringBuilder(2 * string.length());
        block12: for (char c : string.toCharArray()) {
            if (c > '\u0fff') {
                stringBuilder.append("\\u" + Integer.toHexString(c));
                continue;
            }
            if (c > '\u00ff') {
                stringBuilder.append("\\u0" + Integer.toHexString(c));
                continue;
            }
            if (c > '\u007f') {
                stringBuilder.append("\\u00" + Integer.toHexString(c));
                continue;
            }
            if (c < ' ') {
                switch (c) {
                    case '\b': {
                        stringBuilder.append('\\').append('b');
                        break;
                    }
                    case '\n': {
                        stringBuilder.append('\\').append('n');
                        break;
                    }
                    case '\t': {
                        stringBuilder.append('\\').append('t');
                        break;
                    }
                    case '\f': {
                        stringBuilder.append('\\').append('f');
                        break;
                    }
                    case '\r': {
                        stringBuilder.append('\\').append('r');
                        break;
                    }
                    default: {
                        if (c > '\u000f') {
                            stringBuilder.append("\\u00" + Integer.toHexString(c));
                            break;
                        }
                        stringBuilder.append("\\u000" + Integer.toHexString(c));
                        break;
                    }
                }
                continue;
            }
            switch (c) {
                case '\'': {
                    stringBuilder.append('\\').append('\'');
                    continue block12;
                }
                case '\"': {
                    stringBuilder.append('\\').append('\"');
                    continue block12;
                }
                case '\\': {
                    stringBuilder.append('\\').append('\\');
                    continue block12;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    public void run() throws Exception {
        if (this.propagateSystemProperties) {
            for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
                String string = entry.getKey().toString();
                String string2 = Fork.toWindowsShortName(entry.getValue().toString());
                if (!this.isPropagatableProperty(string)) continue;
                if (string.contains(" ")) {
                    this.log.error("System property name '" + string + "' contains a whitespace and can't be propagated");
                    continue;
                }
                if (Os.IS_WINDOWS && string2.contains(" ")) {
                    this.log.error("System property value '" + string2 + "' contains a whitespace and can't be propagated on Windows");
                    continue;
                }
                this.jvmArgs.add("-D" + string + "=" + this.safe(Fork.escape(string2)));
            }
        }
        this.jvmArgs.add("-jar");
        this.jvmArgs.add(Fork.createBooterJar(this.classpath, MainWithArgsInFile.class.getName()).getCanonicalPath());
        Process process = new ProcessBuilder(this.buildCommand()).directory(this.workingDirectory).inheritIO().start();
        process.getOutputStream().close();
        int n = process.waitFor();
        if (n != 0) {
            throw new ForkException(n);
        }
    }

    private List<String> buildCommand() throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>(this.jvmArgs.size() + 3);
        arrayList.add(Fork.toWindowsShortName(this.javaExecutable.getCanonicalPath()));
        arrayList.addAll(this.jvmArgs);
        arrayList.add(this.mainClassName);
        arrayList.add(this.createArgFile(this.args).getCanonicalPath());
        return arrayList;
    }

    private static File createBooterJar(List<String> list, String string) throws IOException {
        File file = File.createTempFile("gatlingbooter", ".jar");
        file.deleteOnExit();
        try (JarOutputStream jarOutputStream = new JarOutputStream(new FileOutputStream(file));){
            jarOutputStream.setLevel(0);
            JarEntry jarEntry = new JarEntry("META-INF/MANIFEST.MF");
            jarOutputStream.putNextEntry(jarEntry);
            Manifest manifest = new Manifest();
            StringBuilder stringBuilder = new StringBuilder();
            for (String string2 : list) {
                stringBuilder.append(Fork.getURL(new File(string2)).toExternalForm()).append(" ");
            }
            stringBuilder.setLength(stringBuilder.length() - 1);
            manifest.getMainAttributes().putValue(Attributes.Name.MANIFEST_VERSION.toString(), "1.0");
            manifest.getMainAttributes().putValue(Attributes.Name.CLASS_PATH.toString(), stringBuilder.toString());
            manifest.getMainAttributes().putValue(Attributes.Name.MAIN_CLASS.toString(), string);
            manifest.getMainAttributes().putValue(GATLING_MANIFEST_VALUE, "true");
            manifest.write(jarOutputStream);
        }
        return file;
    }

    private static URL getURL(File file) throws MalformedURLException {
        return new URL(file.toURI().toASCIIString());
    }

    private boolean isPropagatableProperty(String string) {
        return !string.startsWith("java.") && !string.startsWith("sun.") && !string.startsWith("maven.") && !string.startsWith("file.") && !string.startsWith("awt.") && !string.startsWith("os.") && !string.startsWith("user.") && !string.startsWith("idea.") && !string.startsWith("guice.") && !string.startsWith("hudson.") && !string.equals("line.separator") && !string.equals("path.separator") && !string.equals("classworlds.conf") && !string.equals("org.slf4j.simpleLogger.defaultLogLevel");
    }

    private File createArgFile(List<String> list) throws IOException {
        File file = File.createTempFile(ARG_FILE_PREFIX, ARG_FILE_SUFFIX);
        file.deleteOnExit();
        try (PrintWriter printWriter = new PrintWriter(file);){
            for (String string : list) {
                printWriter.println(string);
            }
            File file2 = file;
            return file2;
        }
    }

    public static final class ForkException
    extends Exception {
        public final int exitValue;

        public ForkException(int n) {
            this.exitValue = n;
        }
    }
}

