/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.resolver;

import io.gatling.http.client.HttpListener;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;

public interface InetAddressNameResolver
extends AutoCloseable {
    public static final InetAddressNameResolver JAVA_RESOLVER = new InetAddressNameResolver(){

        @Override
        public Future<List<InetAddress>> resolveAll(String string, Promise<List<InetAddress>> promise, HttpListener httpListener) {
            try {
                promise.setSuccess(Arrays.asList(InetAddress.getAllByName(string)));
            }
            catch (UnknownHostException unknownHostException) {
                promise.setFailure((Throwable)unknownHostException);
            }
            return promise;
        }

        @Override
        public void close() {
        }
    };

    public Future<List<InetAddress>> resolveAll(String var1, Promise<List<InetAddress>> var2, HttpListener var3);
}

