/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.request.builder;

import io.gatling.commons.validation.Validation;
import io.gatling.commons.validation.Validation$;
import io.gatling.commons.validation.package;
import io.gatling.core.body.Body;
import io.gatling.core.body.ByteArrayBody;
import io.gatling.core.body.CompositeByteArrayBody;
import io.gatling.core.body.InputStreamBody;
import io.gatling.core.body.PebbleBody;
import io.gatling.core.body.RawFileBody;
import io.gatling.core.body.RawFileBody$;
import io.gatling.core.body.ResourceAndCachedBytes;
import io.gatling.core.body.StringBody;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.session.Session;
import io.gatling.core.util.FileResource;
import io.gatling.core.util.Resource;
import io.gatling.http.HeaderNames$;
import io.gatling.http.cache.ContentCacheEntry;
import io.gatling.http.cache.HttpCaches;
import io.gatling.http.client.Request;
import io.gatling.http.client.RequestBuilder;
import io.gatling.http.client.body.RequestBodyBuilder;
import io.gatling.http.client.body.bytearray.ByteArrayRequestBodyBuilder;
import io.gatling.http.client.body.bytearrays.ByteArraysRequestBodyBuilder;
import io.gatling.http.client.body.file.FileRequestBodyBuilder;
import io.gatling.http.client.body.form.FormUrlEncodedRequestBodyBuilder;
import io.gatling.http.client.body.is.InputStreamRequestBodyBuilder;
import io.gatling.http.client.body.multipart.MultipartFormDataRequestBodyBuilder;
import io.gatling.http.client.body.multipart.StringPart;
import io.gatling.http.client.body.string.StringRequestBodyBuilder;
import io.gatling.http.protocol.HttpProtocol;
import io.gatling.http.protocol.Remote$;
import io.gatling.http.request.BodyPart;
import io.gatling.http.request.builder.CommonAttributes;
import io.gatling.http.request.builder.HttpAttributes;
import io.gatling.http.request.builder.RequestExpressionBuilder;
import io.gatling.http.request.builder.RequestExpressionBuilder$;
import io.gatling.http.request.builder.package$;
import io.gatling.http.request.builder.package$HttpParams$;
import java.io.File;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005ec\u0001\u0002\n\u0014\u0001yA\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\tO\u0001\u0011\t\u0011)A\u0005Q!A1\u0006\u0001B\u0001B\u0003%A\u0006\u0003\u00053\u0001\t\u0005\t\u0015!\u00034\u0011!I\u0004A!A!\u0002\u0013Q\u0004\"\u0002\"\u0001\t\u0003\u0019\u0005b\u0002&\u0001\u0005\u0004%Ia\u0013\u0005\u0007'\u0002\u0001\u000b\u0011\u0002'\t\u000bQ\u0003A\u0011B+\t\u000f\u0005\r\u0001\u0001\"\u0003\u0002\u0006!A\u0011\u0011\u0004\u0001C\u0002\u0013%1\nC\u0004\u0002\u001c\u0001\u0001\u000b\u0011\u0002'\t\u0011\u0005u\u0001A1A\u0005\n-Cq!a\b\u0001A\u0003%A\nC\u0004\u0002\"\u0001!\t&a\t\t\u000f\u0005%\u0002\u0001\"\u0003\u0002,!9\u0011\u0011\b\u0001\u0005B\u0005m\"\u0001\b%uiB\u0014V-];fgR,\u0005\u0010\u001d:fgNLwN\u001c\"vS2$WM\u001d\u0006\u0003)U\tqAY;jY\u0012,'O\u0003\u0002\u0017/\u00059!/Z9vKN$(B\u0001\r\u001a\u0003\u0011AG\u000f\u001e9\u000b\u0005iY\u0012aB4bi2Lgn\u001a\u0006\u00029\u0005\u0011\u0011n\\\u0002\u0001'\t\u0001q\u0004\u0005\u0002!C5\t1#\u0003\u0002#'\tA\"+Z9vKN$X\t\u001f9sKN\u001c\u0018n\u001c8Ck&dG-\u001a:\u0002!\r|W.\\8o\u0003R$(/\u001b2vi\u0016\u001c\bC\u0001\u0011&\u0013\t13C\u0001\tD_6lwN\\!uiJL'-\u001e;fg\u0006q\u0001\u000e\u001e;q\u0003R$(/\u001b2vi\u0016\u001c\bC\u0001\u0011*\u0013\tQ3C\u0001\bIiR\u0004\u0018\t\u001e;sS\n,H/Z:\u0002\u0015!$H\u000f]\"bG\",7\u000f\u0005\u0002.a5\taF\u0003\u00020/\u0005)1-Y2iK&\u0011\u0011G\f\u0002\u000b\u0011R$\boQ1dQ\u0016\u001c\u0018\u0001\u00045uiB\u0004&o\u001c;pG>d\u0007C\u0001\u001b8\u001b\u0005)$B\u0001\u001c\u0018\u0003!\u0001(o\u001c;pG>d\u0017B\u0001\u001d6\u00051AE\u000f\u001e9Qe>$xnY8m\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]B\u00111\bQ\u0007\u0002y)\u0011QHP\u0001\u0007G>tg-[4\u000b\u0005}J\u0012\u0001B2pe\u0016L!!\u0011\u001f\u0003)\u001d\u000bG\u000f\\5oO\u000e{gNZ5hkJ\fG/[8o\u0003\u0019a\u0014N\\5u}Q1A)\u0012$H\u0011&\u0003\"\u0001\t\u0001\t\u000b\r2\u0001\u0019\u0001\u0013\t\u000b\u001d2\u0001\u0019\u0001\u0015\t\u000b-2\u0001\u0019\u0001\u0017\t\u000bI2\u0001\u0019A\u001a\t\u000be2\u0001\u0019\u0001\u001e\u0002'\r{gNZ5hkJ,gi\u001c:n!\u0006\u0014\u0018-\\:\u0016\u00031\u0003\"!\u0014)\u000f\u0005\u0001r\u0015BA(\u0014\u0003a\u0011V-];fgR,\u0005\u0010\u001d:fgNLwN\u001c\"vS2$WM]\u0005\u0003#J\u0013qCU3rk\u0016\u001cHOQ;jY\u0012,'oQ8oM&<WO]3\u000b\u0005=\u001b\u0012\u0001F\"p]\u001aLw-\u001e:f\r>\u0014X\u000eU1sC6\u001c\b%\u0001\nd_:4\u0017nZ;sK\n{G-\u001f)beR\u001cH\u0003\u0002,eW6\u00042a\u0016/_\u001b\u0005A&BA-[\u0003)1\u0018\r\\5eCRLwN\u001c\u0006\u00037f\tqaY8n[>t7/\u0003\u0002^1\nQa+\u00197jI\u0006$\u0018n\u001c8\u0011\u0005}\u0013W\"\u00011\u000b\u0005\u0005<\u0012AB2mS\u0016tG/\u0003\u0002dA\nq!+Z9vKN$()^5mI\u0016\u0014\b\"B3\n\u0001\u00041\u0017aB:fgNLwN\u001c\t\u0003O&l\u0011\u0001\u001b\u0006\u0003KzJ!A\u001b5\u0003\u000fM+7o]5p]\")A.\u0003a\u0001=\u0006q!/Z9vKN$()^5mI\u0016\u0014\b\"\u00028\n\u0001\u0004y\u0017!\u00032pIf\u0004\u0016M\u001d;t!\r\u0001(0 \b\u0003c^t!A];\u000e\u0003MT!\u0001^\u000f\u0002\rq\u0012xn\u001c;?\u0013\u00051\u0018!B:dC2\f\u0017B\u0001=z\u0003\u001d\u0001\u0018mY6bO\u0016T\u0011A^\u0005\u0003wr\u0014A\u0001T5ti*\u0011\u00010\u001f\t\u0003}~l\u0011!F\u0005\u0004\u0003\u0003)\"\u0001\u0003\"pIf\u0004\u0016M\u001d;\u0002\u000fM,GOQ8esR9a+a\u0002\u0002\n\u0005-\u0001\"B3\u000b\u0001\u00041\u0007\"\u00027\u000b\u0001\u0004q\u0006bBA\u0007\u0015\u0001\u0007\u0011qB\u0001\u0005E>$\u0017\u0010\u0005\u0003\u0002\u0012\u0005UQBAA\n\u0015\r\tiAP\u0005\u0005\u0003/\t\u0019B\u0001\u0003C_\u0012L\u0018!D2p]\u001aLw-\u001e:f\u0005>$\u00170\u0001\bd_:4\u0017nZ;sK\n{G-\u001f\u0011\u0002/\r|gNZ5hkJ,\u0007K]5pe.swn\u001e7fI\u001e,\u0017\u0001G2p]\u001aLw-\u001e:f!JLwN]&o_^dW\rZ4fA\u000592m\u001c8gS\u001e,(/\u001a*fcV,7\u000f\u001e\"vS2$WM\u001d\u000b\u0006-\u0006\u0015\u0012q\u0005\u0005\u0006K>\u0001\rA\u001a\u0005\u0006Y>\u0001\rAX\u0001\u0018G>tg-[4ve\u0016\u001c\u0015m\u00195j]\u001eDU-\u00193feN$B!!\f\u00028Q!\u0011qFA\u001b!\ry\u0016\u0011G\u0005\u0004\u0003g\u0001'a\u0002*fcV,7\u000f\u001e\u0005\u0007-A\u0001\r!a\f\t\u000b\u0015\u0004\u0002\u0019\u00014\u0002\u000b\t,\u0018\u000e\u001c3\u0016\u0005\u0005u\u0002CBA \u0003'\nyC\u0004\u0003\u0002B\u0005Ec\u0002BA\"\u0003\u001frA!!\u0012\u0002N9!\u0011qIA&\u001d\r\u0011\u0018\u0011J\u0005\u00029%\u0011!dG\u0005\u0003\u007feI!!\u001a \n\u0005aD\u0017\u0002BA+\u0003/\u0012!\"\u0012=qe\u0016\u001c8/[8o\u0015\tA\b\u000e")
public class HttpRequestExpressionBuilder
extends RequestExpressionBuilder {
    private final HttpAttributes httpAttributes;
    private final HttpCaches httpCaches;
    private final HttpProtocol httpProtocol;
    private final Function1<Session, Function1<RequestBuilder, Validation<RequestBuilder>>> ConfigureFormParams;
    private final Function1<Session, Function1<RequestBuilder, Validation<RequestBuilder>>> configureBody;
    private final Function1<Session, Function1<RequestBuilder, Validation<RequestBuilder>>> configurePriorKnowledge;

    private Function1<Session, Function1<RequestBuilder, Validation<RequestBuilder>>> ConfigureFormParams() {
        return this.ConfigureFormParams;
    }

    private Validation<RequestBuilder> configureBodyParts(Session session, RequestBuilder requestBuilder, List<BodyPart> bodyParts) {
        return package$HttpParams$.MODULE$.mergeWithFormIntoParamJList$extension(package$.MODULE$.HttpParams(this.httpAttributes.formParams()), this.httpAttributes.form(), session).map((Function1 & Serializable & scala.Serializable)params -> {
            Buffer stringParts = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(params).asScala()).map((Function1 & Serializable & scala.Serializable)param -> new StringPart(param.getName(), param.getValue(), this.charset(), null, null, null, null), Buffer$.MODULE$.canBuildFrom());
            return new Tuple2(params, (Object)stringParts);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> {
            Tuple2 tuple2 = x$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Buffer stringParts = (Buffer)tuple2._2();
            Validation validation = Validation$.MODULE$.sequence((Seq)bodyParts.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toMultiPart(session), List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)parts -> requestBuilder.setBodyBuilder((RequestBodyBuilder)new MultipartFormDataRequestBodyBuilder((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)parts.$plus$plus((GenTraversableOnce)stringParts, Seq$.MODULE$.canBuildFrom())).asJava())));
            return validation;
        });
    }

    private Validation<RequestBuilder> setBody(Session session, RequestBuilder requestBuilder, Body body) {
        RawFileBody rawFileBody;
        Some some;
        Validation validation;
        Body body2 = body;
        if (body2 instanceof StringBody) {
            StringBody stringBody = (StringBody)body2;
            Function1 string = stringBody.string();
            validation = ((Validation)string.apply((Object)session)).map((Function1 & Serializable & scala.Serializable)s -> requestBuilder.setBodyBuilder((RequestBodyBuilder)new StringRequestBodyBuilder(s)));
        } else if (body2 instanceof RawFileBody && !(some = RawFileBody$.MODULE$.unapply(rawFileBody = (RawFileBody)body2)).isEmpty()) {
            Function1 resourceWithCachedBytes = (Function1)some.get();
            validation = ((Validation)resourceWithCachedBytes.apply((Object)session)).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                RequestBuilder requestBuilder;
                ResourceAndCachedBytes resourceAndCachedBytes = x0$1;
                if (resourceAndCachedBytes == null) throw new MatchError((Object)resourceAndCachedBytes);
                Resource resource = resourceAndCachedBytes.resource();
                Option cachedBytes = resourceAndCachedBytes.cachedBytes();
                Option option = cachedBytes;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    byte[] bytes = (byte[])some.value();
                    requestBuilder = requestBuilder.setBodyBuilder((RequestBodyBuilder)new ByteArrayRequestBodyBuilder(bytes));
                    return requestBuilder;
                } else {
                    RequestBuilder requestBuilder2;
                    if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                    Resource resource2 = resource;
                    if (resource2 instanceof FileResource) {
                        FileResource fileResource = (FileResource)resource2;
                        File file = fileResource.file();
                        requestBuilder2 = requestBuilder.setBodyBuilder((RequestBodyBuilder)new FileRequestBodyBuilder(file));
                    } else {
                        requestBuilder2 = requestBuilder.setBodyBuilder((RequestBodyBuilder)new ByteArrayRequestBodyBuilder(resource.bytes()));
                    }
                    requestBuilder = requestBuilder2;
                }
                return requestBuilder;
            });
        } else if (body2 instanceof ByteArrayBody) {
            ByteArrayBody byteArrayBody = (ByteArrayBody)body2;
            Function1 bytes = byteArrayBody.bytes();
            validation = ((Validation)bytes.apply((Object)session)).map((Function1 & Serializable & scala.Serializable)b -> requestBuilder.setBodyBuilder((RequestBodyBuilder)new ByteArrayRequestBodyBuilder(b)));
        } else if (body2 instanceof CompositeByteArrayBody) {
            CompositeByteArrayBody compositeByteArrayBody = (CompositeByteArrayBody)body2;
            Function1 byteArrays = compositeByteArrayBody.bytes();
            validation = ((Validation)byteArrays.apply((Object)session)).map((Function1 & Serializable & scala.Serializable)bs -> requestBuilder.setBodyBuilder((RequestBodyBuilder)new ByteArraysRequestBodyBuilder((byte[][])bs.toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))))));
        } else if (body2 instanceof InputStreamBody) {
            InputStreamBody inputStreamBody = (InputStreamBody)body2;
            Function1 is2 = inputStreamBody.is();
            validation = ((Validation)is2.apply((Object)session)).map((Function1 & Serializable & scala.Serializable)is -> requestBuilder.setBodyBuilder((RequestBodyBuilder)new InputStreamRequestBodyBuilder(is)));
        } else if (body2 instanceof PebbleBody) {
            PebbleBody pebbleBody = (PebbleBody)body2;
            validation = pebbleBody.apply(session).map((Function1 & Serializable & scala.Serializable)s -> requestBuilder.setBodyBuilder((RequestBodyBuilder)new StringRequestBodyBuilder(s)));
        } else {
            throw new MatchError((Object)body2);
        }
        return validation;
    }

    private Function1<Session, Function1<RequestBuilder, Validation<RequestBuilder>>> configureBody() {
        return this.configureBody;
    }

    private Function1<Session, Function1<RequestBuilder, Validation<RequestBuilder>>> configurePriorKnowledge() {
        return this.configurePriorKnowledge;
    }

    @Override
    public Validation<RequestBuilder> configureRequestBuilder(Session session, RequestBuilder requestBuilder) {
        return super.configureRequestBuilder(session, requestBuilder).flatMap((Function1)this.configureBody().apply((Object)session)).flatMap((Function1)this.configurePriorKnowledge().apply((Object)session));
    }

    private Request configureCachingHeaders(Session session, Request request) {
        this.httpCaches.contentCacheEntry(session, request).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            HttpRequestExpressionBuilder.$anonfun$configureCachingHeaders$1(request, x0$1);
            return BoxedUnit.UNIT;
        });
        return request;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Function1<Session, Validation<Request>> build() {
        void var1_1;
        Function1<Session, Validation<Request>> exp = super.build();
        return this.httpProtocol.requestPart().cache() ? session -> ((Validation)exp.apply(session)).map((Function1 & Serializable & scala.Serializable)request -> this.configureCachingHeaders((Session)session, (Request)request)) : var1_1;
    }

    public static final /* synthetic */ boolean $anonfun$configurePriorKnowledge$3(boolean x$3) {
        return x$3;
    }

    public static final /* synthetic */ void $anonfun$configureCachingHeaders$1(Request request$1, ContentCacheEntry x0$1) {
        ContentCacheEntry contentCacheEntry = x0$1;
        if (contentCacheEntry == null) {
            throw new MatchError((Object)contentCacheEntry);
        }
        Option<String> etag = contentCacheEntry.etag();
        Option<String> lastModified = contentCacheEntry.lastModified();
        etag.foreach((Function1 & Serializable & scala.Serializable)x$4 -> request$1.getHeaders().set(HeaderNames$.MODULE$.IfNoneMatch(), x$4));
        lastModified.foreach((Function1 & Serializable & scala.Serializable)x$5 -> request$1.getHeaders().set(HeaderNames$.MODULE$.IfModifiedSince(), x$5));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public HttpRequestExpressionBuilder(CommonAttributes commonAttributes, HttpAttributes httpAttributes, HttpCaches httpCaches, HttpProtocol httpProtocol, GatlingConfiguration configuration) {
        Function1<Session, Function1<RequestBuilder, Validation<RequestBuilder>>> function1;
        this.httpAttributes = httpAttributes;
        this.httpCaches = httpCaches;
        this.httpProtocol = httpProtocol;
        super(commonAttributes, httpCaches, httpProtocol, configuration);
        this.ConfigureFormParams = (Function1 & Serializable & scala.Serializable)session -> (Function1 & Serializable & scala.Serializable)requestBuilder -> package$HttpParams$.MODULE$.mergeWithFormIntoParamJList$extension(package$.MODULE$.HttpParams($this.httpAttributes.formParams()), $this.httpAttributes.form(), (Session)session).map((Function1 & Serializable & scala.Serializable)resolvedFormParams -> requestBuilder.setBodyBuilder((RequestBodyBuilder)new FormUrlEncodedRequestBodyBuilder(resolvedFormParams)));
        Predef$.MODULE$.require(httpAttributes.body().isEmpty() || httpAttributes.bodyParts().isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Can't have both a body and body parts!");
        Option<Body> option = httpAttributes.body();
        if (option instanceof Some) {
            Some some = (Some)option;
            Body body = (Body)some.value();
            function1 = session -> (Function1 & Serializable & scala.Serializable)requestBuilder -> this.setBody((Session)session, (RequestBuilder)requestBuilder, body);
        } else {
            function1 = httpAttributes.bodyParts().nonEmpty() ? session -> (Function1 & Serializable & scala.Serializable)requestBuilder -> this.configureBodyParts((Session)session, (RequestBuilder)requestBuilder, $this.httpAttributes.bodyParts()) : (httpAttributes.formParams().nonEmpty() || httpAttributes.form().nonEmpty() ? this.ConfigureFormParams() : RequestExpressionBuilder$.MODULE$.ConfigureIdentity());
        }
        this.configureBody = function1;
        this.configurePriorKnowledge = httpProtocol.enginePart().enableHttp2() ? session -> (Function1 & Serializable & scala.Serializable)requestBuilder -> {
            Option<Object> http2PriorKnowledge = $this.httpCaches.isHttp2PriorKnowledge((Session)session, Remote$.MODULE$.apply(requestBuilder.getUri()));
            return package.SuccessWrapper$.MODULE$.success$extension(io.gatling.commons.validation.package$.MODULE$.SuccessWrapper((Object)requestBuilder.setHttp2Enabled(true).setAlpnRequired(http2PriorKnowledge.forall((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)HttpRequestExpressionBuilder.$anonfun$configurePriorKnowledge$3(BoxesRunTime.unboxToBoolean((Object)x$3))))).setHttp2PriorKnowledge(http2PriorKnowledge.contains((Object)BoxesRunTime.boxToBoolean((boolean)true)))));
        } : RequestExpressionBuilder$.MODULE$.ConfigureIdentity();
    }
}

