/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.action.ws.fsm;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.stats.OK$;
import io.gatling.commons.stats.Status;
import io.gatling.commons.util.Throwables;
import io.gatling.commons.util.Throwables$;
import io.gatling.core.action.Action;
import io.gatling.core.session.Session;
import io.gatling.http.action.ws.fsm.NextWsState;
import io.gatling.http.action.ws.fsm.NextWsState$;
import io.gatling.http.action.ws.fsm.SendFrame;
import io.gatling.http.action.ws.fsm.WsClosingState;
import io.gatling.http.action.ws.fsm.WsCrashedState;
import io.gatling.http.action.ws.fsm.WsFsm;
import io.gatling.http.action.ws.fsm.WsPerformingCheckState;
import io.gatling.http.action.ws.fsm.WsState;
import io.gatling.http.check.ws.WsBinaryFrameCheck;
import io.gatling.http.check.ws.WsFrameCheck;
import io.gatling.http.check.ws.WsFrameCheckSequence;
import io.gatling.http.check.ws.WsTextFrameCheck;
import io.gatling.http.client.WebSocket;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import java.io.Serializable;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0001\u0005Uc\u0001\u0002\u0007\u000e\u0005iA\u0001B\u0004\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\tY\u0001\u0011\t\u0011)A\u0005[!AA\u0007\u0001B\u0001B\u0003%Q\u0007C\u0003<\u0001\u0011\u0005A\bC\u0003B\u0001\u0011\u0005#\tC\u0003u\u0001\u0011\u0005S\u000fC\u0004\u0002\u0010\u0001!\t%!\u0005\t\u000f\u0005}\u0001\u0001\"\u0011\u0002\"!9\u0011q\u0005\u0001\u0005B\u0005%\u0002bBA\u001e\u0001\u0011\u0005\u0013Q\b\u0005\b\u0003\u0017\u0002A\u0011IA'\u0005-96/\u00133mKN#\u0018\r^3\u000b\u00059y\u0011a\u00014t[*\u0011\u0001#E\u0001\u0003oNT!AE\n\u0002\r\u0005\u001cG/[8o\u0015\t!R#\u0001\u0003iiR\u0004(B\u0001\f\u0018\u0003\u001d9\u0017\r\u001e7j]\u001eT\u0011\u0001G\u0001\u0003S>\u001c\u0001aE\u0002\u00017}\u0001\"\u0001H\u000f\u000e\u00035I!AH\u0007\u0003\u000f]\u001b8\u000b^1uKB\u0011\u0001eJ\u0007\u0002C)\u0011!eI\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003I\u0015\n\u0001\u0002^=qKN\fg-\u001a\u0006\u0002M\u0005\u00191m\\7\n\u0005!\n#!D*ue&\u001cG\u000fT8hO&tw\r\u0005\u0002\u001dU%\u00111&\u0004\u0002\u0006/N45/\\\u0001\bg\u0016\u001c8/[8o!\tq#'D\u00010\u0015\ta\u0003G\u0003\u00022+\u0005!1m\u001c:f\u0013\t\u0019tFA\u0004TKN\u001c\u0018n\u001c8\u0002\u0013],'mU8dW\u0016$\bC\u0001\u001c:\u001b\u00059$B\u0001\u001d\u0014\u0003\u0019\u0019G.[3oi&\u0011!h\u000e\u0002\n/\u0016\u00147k\\2lKR\fa\u0001P5oSRtD\u0003B\u001f?\u007f\u0001\u0003\"\u0001\b\u0001\t\u000b9!\u0001\u0019A\u0015\t\u000b1\"\u0001\u0019A\u0017\t\u000bQ\"\u0001\u0019A\u001b\u0002\u001f=t7+\u001a8e)\u0016DHO\u0012:b[\u0016$ba\u0011$V/2l\u0007C\u0001\u000fE\u0013\t)UBA\u0006OKb$xk]*uCR,\u0007\"B$\u0006\u0001\u0004A\u0015AC1di&|gNT1nKB\u0011\u0011J\u0015\b\u0003\u0015B\u0003\"a\u0013(\u000e\u00031S!!T\r\u0002\rq\u0012xn\u001c;?\u0015\u0005y\u0015!B:dC2\f\u0017BA)O\u0003\u0019\u0001&/\u001a3fM&\u00111\u000b\u0016\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Es\u0005\"\u0002,\u0006\u0001\u0004A\u0015aB7fgN\fw-\u001a\u0005\u00061\u0016\u0001\r!W\u0001\u000fG\",7m[*fcV,gnY3t!\rQvL\u0019\b\u00037vs!a\u0013/\n\u0003=K!A\u0018(\u0002\u000fA\f7m[1hK&\u0011\u0001-\u0019\u0002\u0005\u0019&\u001cHO\u0003\u0002_\u001dB\u00191mZ5\u000e\u0003\u0011T!\u0001E3\u000b\u0005\u0019\u001c\u0012!B2iK\u000e\\\u0017B\u00015e\u0005Q96O\u0012:b[\u0016\u001c\u0005.Z2l'\u0016\fX/\u001a8dKB\u00111M[\u0005\u0003W\u0012\u0014\u0001cV:UKb$hI]1nK\u000eCWmY6\t\u000b1*\u0001\u0019A\u0017\t\u000b9,\u0001\u0019A8\u0002\t9,\u0007\u0010\u001e\t\u0003aJl\u0011!\u001d\u0006\u0003%AJ!a]9\u0003\r\u0005\u001bG/[8o\u0003EygnU3oI\nKg.\u0019:z\rJ\fW.\u001a\u000b\t\u0007Z<x0a\u0003\u0002\u000e!)qI\u0002a\u0001\u0011\")aK\u0002a\u0001qB\u0019\u0011P\u001f?\u000e\u00039K!a\u001f(\u0003\u000b\u0005\u0013(/Y=\u0011\u0005el\u0018B\u0001@O\u0005\u0011\u0011\u0015\u0010^3\t\ra3\u0001\u0019AA\u0001!\u0011Qv,a\u0001\u0011\t\r<\u0017Q\u0001\t\u0004G\u0006\u001d\u0011bAA\u0005I\n\u0011rk\u001d\"j]\u0006\u0014\u0018P\u0012:b[\u0016\u001c\u0005.Z2l\u0011\u0015ac\u00011\u0001.\u0011\u0015qg\u00011\u0001p\u0003Myg\u000eV3yi\u001a\u0013\u0018-\\3SK\u000e,\u0017N^3e)\u0015\u0019\u00151CA\u000b\u0011\u00151v\u00011\u0001I\u0011\u001d\t9b\u0002a\u0001\u00033\t\u0011\u0002^5nKN$\u0018-\u001c9\u0011\u0007e\fY\"C\u0002\u0002\u001e9\u0013A\u0001T8oO\u0006)rN\u001c\"j]\u0006\u0014\u0018P\u0012:b[\u0016\u0014VmY3jm\u0016$G#B\"\u0002$\u0005\u0015\u0002\"\u0002,\t\u0001\u0004A\bbBA\f\u0011\u0001\u0007\u0011\u0011D\u0001\u0012_:<VMY*pG.,Go\u00117pg\u0016$GcB\"\u0002,\u0005U\u0012\u0011\b\u0005\b\u0003[I\u0001\u0019AA\u0018\u0003\u0011\u0019w\u000eZ3\u0011\u0007e\f\t$C\u0002\u000249\u00131!\u00138u\u0011\u0019\t9$\u0003a\u0001\u0011\u00061!/Z1t_:Dq!a\u0006\n\u0001\u0004\tI\"\u0001\np]^+'mU8dW\u0016$8I]1tQ\u0016$G#B\"\u0002@\u0005%\u0003bBA!\u0015\u0001\u0007\u00111I\u0001\u0002iB\u0019!,!\u0012\n\u0007\u0005\u001d\u0013MA\u0005UQJ|w/\u00192mK\"9\u0011q\u0003\u0006A\u0002\u0005e\u0011\u0001F8o\u00072LWM\u001c;DY>\u001cXMU3rk\u0016\u001cH\u000fF\u0004D\u0003\u001f\n\t&a\u0015\t\u000b\u001d[\u0001\u0019\u0001%\t\u000b1Z\u0001\u0019A\u0017\t\u000b9\\\u0001\u0019A8")
public final class WsIdleState
extends WsState
implements StrictLogging {
    private final WsFsm fsm;
    private final Session session;
    private final WebSocket webSocket;
    private final Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public NextWsState onSendTextFrame(String actionName, String message, List<WsFrameCheckSequence<WsTextFrameCheck>> checkSequences, Session session, Action next) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Send text frame {} {}", (Object[])new String[]{actionName, message});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        long now = this.fsm.clock().nowMillis();
        this.webSocket.sendFrame((WebSocketFrame)new TextWebSocketFrame(message));
        this.fsm.statsEngine().logResponse(session.scenario(), session.groups(), actionName, now, now, (Status)OK$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
        List<WsFrameCheckSequence<WsTextFrameCheck>> list = checkSequences;
        if (!(list instanceof .colon.colon)) return new NextWsState(this, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> next.$bang(session));
        .colon.colon colon2 = (.colon.colon)list;
        WsFrameCheckSequence wsFrameCheckSequence = (WsFrameCheckSequence)colon2.head();
        List remainingCheckSequences = colon2.tl$access$1();
        if (wsFrameCheckSequence == null) return new NextWsState(this, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> next.$bang(session));
        FiniteDuration timeout = wsFrameCheckSequence.timeout();
        List list2 = wsFrameCheckSequence.checks();
        if (!(list2 instanceof .colon.colon)) return new NextWsState(this, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> next.$bang(session));
        .colon.colon colon3 = (.colon.colon)list2;
        WsTextFrameCheck currentCheck = (WsTextFrameCheck)colon3.head();
        List remainingChecks = colon3.tl$access$1();
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Trigger check after sending text frame");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.fsm.scheduleTimeout(timeout);
        return new NextWsState(new WsPerformingCheckState(this.fsm, this.webSocket, currentCheck, (List<WsFrameCheck>)remainingChecks, now, (List<WsFrameCheckSequence<WsFrameCheck>>)remainingCheckSequences, session, (Either<Action, SendFrame>)package$.MODULE$.Left().apply((Object)next)), NextWsState$.MODULE$.apply$default$2());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public NextWsState onSendBinaryFrame(String actionName, byte[] message, List<WsFrameCheckSequence<WsBinaryFrameCheck>> checkSequences, Session session, Action next) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Send binary frame {} length={}", new Object[]{actionName, BoxesRunTime.boxToInteger((int)message.length)});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        long now = this.fsm.clock().nowMillis();
        this.webSocket.sendFrame((WebSocketFrame)new BinaryWebSocketFrame(Unpooled.wrappedBuffer((byte[])message)));
        this.fsm.statsEngine().logResponse(session.scenario(), session.groups(), actionName, now, now, (Status)OK$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
        List<WsFrameCheckSequence<WsBinaryFrameCheck>> list = checkSequences;
        if (!(list instanceof .colon.colon)) return new NextWsState(this, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> next.$bang(session));
        .colon.colon colon2 = (.colon.colon)list;
        WsFrameCheckSequence wsFrameCheckSequence = (WsFrameCheckSequence)colon2.head();
        List remainingCheckSequences = colon2.tl$access$1();
        if (wsFrameCheckSequence == null) return new NextWsState(this, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> next.$bang(session));
        FiniteDuration timeout = wsFrameCheckSequence.timeout();
        List list2 = wsFrameCheckSequence.checks();
        if (!(list2 instanceof .colon.colon)) return new NextWsState(this, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> next.$bang(session));
        .colon.colon colon3 = (.colon.colon)list2;
        WsBinaryFrameCheck currentCheck = (WsBinaryFrameCheck)colon3.head();
        List remainingChecks = colon3.tl$access$1();
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Trigger check after sending binary frame");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.fsm.scheduleTimeout(timeout);
        return new NextWsState(new WsPerformingCheckState(this.fsm, this.webSocket, currentCheck, (List<WsFrameCheck>)remainingChecks, now, (List<WsFrameCheckSequence<WsFrameCheck>>)remainingCheckSequences, session, (Either<Action, SendFrame>)package$.MODULE$.Left().apply((Object)next)), NextWsState$.MODULE$.apply$default$2());
    }

    @Override
    public NextWsState onTextFrameReceived(String message, long timestamp) {
        this.logUnmatchedServerMessage(this.session);
        return new NextWsState(this, NextWsState$.MODULE$.apply$default$2());
    }

    @Override
    public NextWsState onBinaryFrameReceived(byte[] message, long timestamp) {
        this.logUnmatchedServerMessage(this.session);
        return new NextWsState(this, NextWsState$.MODULE$.apply$default$2());
    }

    @Override
    public NextWsState onWebSocketClosed(int code, String reason, long timestamp) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("WebSocket was forcefully closed ({}:{}) by the server while in Idle state", new Object[]{BoxesRunTime.boxToInteger((int)code), reason});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new NextWsState(new WsCrashedState(this.fsm, (Option<String>)None$.MODULE$), NextWsState$.MODULE$.apply$default$2());
    }

    @Override
    public NextWsState onWebSocketCrashed(Throwable t, long timestamp) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("WebSocket crashed by the server while in Idle state", t);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new NextWsState(new WsCrashedState(this.fsm, (Option<String>)new Some((Object)Throwables.PimpedException$.MODULE$.rootMessage$extension(Throwables$.MODULE$.PimpedException(t)))), NextWsState$.MODULE$.apply$default$2());
    }

    @Override
    public NextWsState onClientCloseRequest(String actionName, Session session, Action next) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Client requested WebSocket close");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.webSocket.sendFrame((WebSocketFrame)new CloseWebSocketFrame());
        return new NextWsState(new WsClosingState(this.fsm, actionName, session, next, this.fsm.clock().nowMillis()), NextWsState$.MODULE$.apply$default$2());
    }

    public WsIdleState(WsFsm fsm, Session session, WebSocket webSocket) {
        this.fsm = fsm;
        this.session = session;
        this.webSocket = webSocket;
        super(fsm);
        StrictLogging.$init$((StrictLogging)this);
    }
}

