/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.cache;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.gatling.commons.util.CircularIterator$;
import io.gatling.commons.validation.Validation;
import io.gatling.commons.validation.package;
import io.gatling.core.session.Session;
import io.gatling.core.session.Session$;
import io.gatling.core.session.SessionPrivateAttributes$;
import io.gatling.core.session.package;
import io.gatling.core.session.package$;
import io.gatling.http.client.uri.Uri;
import io.gatling.http.protocol.HttpProtocol;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.InetAddress;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

public final class BaseUrlSupport$
implements LazyLogging {
    public static BaseUrlSupport$ MODULE$;
    private final String BaseUrlAttributeName;
    private final String WsBaseUrlAttributeName;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new BaseUrlSupport$();
    }

    private Logger logger$lzycompute() {
        BaseUrlSupport$ baseUrlSupport$ = this;
        synchronized (baseUrlSupport$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    private String BaseUrlAttributeName() {
        return this.BaseUrlAttributeName;
    }

    private String WsBaseUrlAttributeName() {
        return this.WsBaseUrlAttributeName;
    }

    private void preResolve(String baseUrl) {
        try {
            Uri uri = Uri.create((String)baseUrl);
            InetAddress.getAllByName(uri.getHost());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                BoxedUnit boxedUnit;
                Throwable e = (Throwable)option.get();
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringBuilder(43).append("Couldn't pre-resolve hostname from baseUrl ").append(baseUrl).toString(), e);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Function1<Session, Session> setBaseUrl(List<String> baseUrls, String attributeName) {
        baseUrls.foreach((Function1 & Serializable & scala.Serializable)baseUrl -> {
            BaseUrlSupport$.MODULE$.preResolve(baseUrl);
            return BoxedUnit.UNIT;
        });
        List<String> list = baseUrls;
        if (Nil$.MODULE$.equals(list)) {
            return Session$.MODULE$.Identity();
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            String url = (String)colon2.head();
            List list2 = colon2.tl$access$1();
            if (Nil$.MODULE$.equals(list2)) {
                return (Function1 & Serializable & scala.Serializable)x$1 -> x$1.set(attributeName, (Object)url);
            }
        }
        Iterator it = CircularIterator$.MODULE$.apply((IndexedSeq)list.toVector(), true);
        return (Function1 & Serializable & scala.Serializable)x$2 -> x$2.set(attributeName, it.next());
    }

    public Function1<Session, Session> setHttpBaseUrl(HttpProtocol httpProtocol) {
        return this.setBaseUrl(httpProtocol.baseUrls(), this.BaseUrlAttributeName());
    }

    public Function1<Session, Session> setWsBaseUrl(HttpProtocol httpProtocol) {
        return this.setBaseUrl(httpProtocol.wsPart().wsBaseUrls(), this.WsBaseUrlAttributeName());
    }

    private Option<String> baseUrl(Session session, String attributeName) {
        return session.attributes().get((Object)attributeName).map((Function1 & Serializable & scala.Serializable)x$3 -> (String)x$3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Function1<Session, Option<String>> httpBaseUrl(HttpProtocol httpProtocol) {
        List<String> list = httpProtocol.baseUrls();
        if (Nil$.MODULE$.equals(list)) {
            return (Function1 & Serializable & scala.Serializable)x$4 -> None$.MODULE$;
        }
        if (!(list instanceof .colon.colon)) return (Function1 & Serializable & scala.Serializable)x$6 -> MODULE$.baseUrl((Session)x$6, MODULE$.BaseUrlAttributeName());
        .colon.colon colon2 = (.colon.colon)list;
        String single = (String)colon2.head();
        List list2 = colon2.tl$access$1();
        if (!Nil$.MODULE$.equals(list2)) return (Function1 & Serializable & scala.Serializable)x$6 -> MODULE$.baseUrl((Session)x$6, MODULE$.BaseUrlAttributeName());
        Some s = new Some((Object)single);
        return (Function1 & Serializable & scala.Serializable)x$5 -> s;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Function1<Session, Option<String>> wsBaseUrl(HttpProtocol httpProtocol) {
        List<String> list = httpProtocol.wsPart().wsBaseUrls();
        if (Nil$.MODULE$.equals(list)) {
            return (Function1 & Serializable & scala.Serializable)x$7 -> None$.MODULE$;
        }
        if (!(list instanceof .colon.colon)) return (Function1 & Serializable & scala.Serializable)x$9 -> MODULE$.baseUrl((Session)x$9, MODULE$.WsBaseUrlAttributeName());
        .colon.colon colon2 = (.colon.colon)list;
        String single = (String)colon2.head();
        List list2 = colon2.tl$access$1();
        if (!Nil$.MODULE$.equals(list2)) return (Function1 & Serializable & scala.Serializable)x$9 -> MODULE$.baseUrl((Session)x$9, MODULE$.WsBaseUrlAttributeName());
        Some s = new Some((Object)single);
        return (Function1 & Serializable & scala.Serializable)x$8 -> s;
    }

    /*
     * Unable to fully structure code
     */
    public Function1<Session, Validation<String>> defaultDomain(HttpProtocol httpProtocol, Function1<Session, Validation<String>> failure) {
        block7: {
            block4: {
                block6: {
                    block5: {
                        var5_3 = httpProtocol.baseUrls();
                        if (!Nil$.MODULE$.equals(var5_3)) break block4;
                        var6_4 = httpProtocol.wsPart().wsBaseUrls();
                        if (!Nil$.MODULE$.equals(var6_4)) break block5;
                        var4_5 = failure;
                        break block6;
                    }
                    if (!(var6_4 instanceof .colon.colon)) ** GOTO lbl-1000
                    var7_6 = (.colon.colon)var6_4;
                    single = (String)var7_6.head();
                    var9_8 = var7_6.tl$access$1();
                    if (Nil$.MODULE$.equals(var9_8)) {
                        var4_5 = package.ExpressionSuccessWrapper$.MODULE$.expressionSuccess$extension(package$.MODULE$.ExpressionSuccessWrapper((Object)Uri.create((String)single).getHost()));
                    } else lbl-1000:
                    // 2 sources

                    {
                        var4_5 = (Function1)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$defaultDomain$1(io.gatling.core.session.Session ), (Lio/gatling/core/session/Session;)Lio/gatling/commons/validation/Validation;)();
                    }
                }
                var3_9 = var4_5;
                break block7;
            }
            if (!(var5_3 instanceof .colon.colon)) ** GOTO lbl-1000
            var10_10 = (.colon.colon)var5_3;
            single = (String)var10_10.head();
            var12_12 = var10_10.tl$access$1();
            if (Nil$.MODULE$.equals(var12_12)) {
                var3_9 = package.ExpressionSuccessWrapper$.MODULE$.expressionSuccess$extension(package$.MODULE$.ExpressionSuccessWrapper((Object)Uri.create((String)single).getHost()));
            } else lbl-1000:
            // 2 sources

            {
                var3_9 = (Function1)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$defaultDomain$2(io.gatling.core.session.Session ), (Lio/gatling/core/session/Session;)Lio/gatling/commons/validation/Validation;)();
            }
        }
        return var3_9;
    }

    public static final /* synthetic */ Validation $anonfun$defaultDomain$1(Session session) {
        return package.SuccessWrapper$.MODULE$.success$extension(io.gatling.commons.validation.package$.MODULE$.SuccessWrapper((Object)Uri.create((String)((String)MODULE$.baseUrl(session, MODULE$.WsBaseUrlAttributeName()).get())).getHost()));
    }

    public static final /* synthetic */ Validation $anonfun$defaultDomain$2(Session session) {
        return package.SuccessWrapper$.MODULE$.success$extension(io.gatling.commons.validation.package$.MODULE$.SuccessWrapper((Object)Uri.create((String)((String)MODULE$.baseUrl(session, MODULE$.BaseUrlAttributeName()).get())).getHost()));
    }

    private BaseUrlSupport$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        this.BaseUrlAttributeName = new StringBuilder(18).append(SessionPrivateAttributes$.MODULE$.PrivateAttributePrefix()).append("http.cache.baseUrl").toString();
        this.WsBaseUrlAttributeName = new StringBuilder(20).append(SessionPrivateAttributes$.MODULE$.PrivateAttributePrefix()).append("http.cache.wsBaseUrl").toString();
    }
}

