/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.util;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.netty.util.NetUtil;
import java.io.Serializable;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.ThreadLocalRandom;
import scala.Function1;
import scala.Option;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.control.NonFatal$;

public final class InetAddresses$
implements LazyLogging {
    public static InetAddresses$ MODULE$;
    private final List<InetAddress> AllLocalAddresses;
    private final List<InetAddress> AllIpV4LocalAddresses;
    private final List<InetAddress> AllIpV6LocalAddresses;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new InetAddresses$();
    }

    private Logger logger$lzycompute() {
        InetAddresses$ inetAddresses$ = this;
        synchronized (inetAddresses$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    private boolean isBindable(InetAddress localAddress) {
        boolean bl;
        InetSocketAddress socketAddress = new InetSocketAddress(localAddress, 0);
        try (Socket socket = new Socket();){
            try {
                socket.bind(socketAddress);
                bl = true;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    BoxedUnit boxedUnit;
                    Throwable e = (Throwable)option.get();
                    if (this.logger().underlying().isDebugEnabled()) {
                        this.logger().underlying().debug(new StringBuilder(24).append("Address ").append(localAddress).append(" is not bindable").toString(), e);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    throw throwable;
                }
                boolean bl2 = false;
                bl = bl2;
            }
        }
        return bl;
    }

    private List<InetAddress> AllLocalAddresses() {
        return this.AllLocalAddresses;
    }

    public List<InetAddress> AllIpV4LocalAddresses() {
        return this.AllIpV4LocalAddresses;
    }

    public List<InetAddress> AllIpV6LocalAddresses() {
        return this.AllIpV6LocalAddresses;
    }

    public java.util.List<InetAddress> shuffleInetAddresses(java.util.List<InetAddress> originalAddresses, boolean isIpV4StackPreferred, boolean isIpV6AddressesPreferred) {
        java.util.List list;
        if (originalAddresses.size() == 1) {
            list = originalAddresses;
        } else {
            ObjectRef ipV4 = ObjectRef.create(null);
            ObjectRef ipV6 = ObjectRef.create(null);
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(originalAddresses).asScala()).foreach((Function1 & Serializable & scala.Serializable)inetAddress -> {
                Object object;
                if (inetAddress instanceof Inet4Address) {
                    if ((java.util.List)ipV4$1.elem == null) {
                        ipV4$1.elem = new ArrayList(originalAddresses.size());
                    }
                    object = BoxesRunTime.boxToBoolean((boolean)((java.util.List)ipV4$1.elem).add(inetAddress));
                } else if (!isIpV4StackPreferred) {
                    if ((java.util.List)ipV6$1.elem == null) {
                        ipV6$1.elem = new ArrayList(originalAddresses.size());
                    }
                    object = BoxesRunTime.boxToBoolean((boolean)((java.util.List)ipV6$1.elem).add(inetAddress));
                } else {
                    object = BoxedUnit.UNIT;
                }
                return object;
            });
            java.util.List higher = isIpV6AddressesPreferred ? (java.util.List)ipV6.elem : (java.util.List)ipV4.elem;
            java.util.List lower = isIpV6AddressesPreferred ? (java.util.List)ipV4.elem : (java.util.List)ipV6.elem;
            ThreadLocalRandom random = ThreadLocalRandom.current();
            if (higher != null) {
                Object object;
                this.shuffle(higher, random);
                if (lower != null) {
                    this.shuffle(lower, random);
                    object = BoxesRunTime.boxToBoolean((boolean)higher.addAll(lower));
                } else {
                    object = BoxedUnit.UNIT;
                }
                list = higher;
            } else {
                this.shuffle(lower, random);
                list = lower;
            }
        }
        return list;
    }

    private void shuffle(java.util.List<InetAddress> list, ThreadLocalRandom random) {
        block0: {
            if (list.size() <= 1) break block0;
            Collections.shuffle(list, random);
        }
    }

    public static final /* synthetic */ boolean $anonfun$AllLocalAddresses$2(InetAddress inetAddress) {
        return !inetAddress.isLoopbackAddress() && !inetAddress.isLinkLocalAddress() && !inetAddress.isMulticastAddress() && MODULE$.isBindable(inetAddress);
    }

    public static final /* synthetic */ boolean $anonfun$AllIpV4LocalAddresses$1(InetAddress x$1) {
        return x$1 instanceof Inet4Address;
    }

    public static final /* synthetic */ boolean $anonfun$AllIpV6LocalAddresses$1(InetAddress x$2) {
        return x$2 instanceof Inet6Address;
    }

    private InetAddresses$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        this.AllLocalAddresses = (List)((TraversableOnce)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(NetworkInterface.getNetworkInterfaces()).asScala()).toList().flatMap((Function1 & Serializable & scala.Serializable)networkInterface -> ((Iterator)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(networkInterface.getInetAddresses()).asScala()).withFilter((Function1 & Serializable & scala.Serializable)inetAddress -> BoxesRunTime.boxToBoolean((boolean)InetAddresses$.$anonfun$AllLocalAddresses$2(inetAddress))), List$.MODULE$.canBuildFrom());
        this.AllIpV4LocalAddresses = (List)this.AllLocalAddresses().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)InetAddresses$.$anonfun$AllIpV4LocalAddresses$1(x$1)));
        this.AllIpV6LocalAddresses = NetUtil.isIpV4StackPreferred() ? Nil$.MODULE$ : (List)this.AllLocalAddresses().filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)InetAddresses$.$anonfun$AllIpV6LocalAddresses$1(x$2)));
    }
}

