/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.jms.client;

import akka.actor.ActorSystem;
import io.gatling.commons.model.Credentials;
import io.gatling.commons.util.Clock;
import io.gatling.commons.validation.Validation;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.session.package;
import io.gatling.core.session.package$;
import io.gatling.core.stats.StatsEngine;
import io.gatling.jms.client.JmsProducer;
import io.gatling.jms.client.JmsProducerPool;
import io.gatling.jms.client.JmsSessionPool;
import io.gatling.jms.client.JmsTracker;
import io.gatling.jms.client.JmsTrackerPool;
import io.gatling.jms.protocol.JmsMessageMatcher;
import io.gatling.jms.request.JmsDestination;
import io.gatling.jms.request.JmsQueue;
import io.gatling.jms.request.JmsTemporaryQueue$;
import io.gatling.jms.request.JmsTemporaryTopic$;
import io.gatling.jms.request.JmsTopic;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Session;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005%f\u0001B\f\u0019\u0001\u0005B\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\ta\u0001\u0011)\u0019!C\u0001c!AQ\b\u0001B\u0001B\u0003%!\u0007\u0003\u0005?\u0001\t\u0005\t\u0015!\u0003@\u0011!9\u0005A!A!\u0002\u0013A\u0005\u0002\u0003)\u0001\u0005\u0003\u0005\u000b\u0011B)\t\u0011]\u0003!\u0011!Q\u0001\naCQA\u0018\u0001\u0005\u0002}Cq\u0001\u001b\u0001C\u0002\u0013%\u0011\u000e\u0003\u0004n\u0001\u0001\u0006IA\u001b\u0005\b]\u0002\u0011\r\u0011\"\u0003p\u0011\u001d\ty\u0001\u0001Q\u0001\nAD\u0001\"!\u0005\u0001\u0005\u0004%Ia\u001c\u0005\b\u0003'\u0001\u0001\u0015!\u0003q\u0011\u001d\t)\u0002\u0001C\u0001\u0003/A\u0011\"a\u0013\u0001\u0005\u0004%I!!\u0014\t\u0011\u0005U\u0003\u0001)A\u0005\u0003\u001fBq!a\u0016\u0001\t\u0003\tI\u0006C\u0005\u0002n\u0001\u0011\r\u0011\"\u0003\u0002p!A\u0011q\u000f\u0001!\u0002\u0013\t\t\bC\u0004\u0002z\u0001!\t!a\u001f\t\u000f\u0005}\u0005\u0001\"\u0001\u0002\"\ni!*\\:D_:tWm\u0019;j_:T!!\u0007\u000e\u0002\r\rd\u0017.\u001a8u\u0015\tYB$A\u0002k[NT!!\b\u0010\u0002\u000f\u001d\fG\u000f\\5oO*\tq$\u0001\u0002j_\u000e\u00011C\u0001\u0001#!\t\u0019c%D\u0001%\u0015\u0005)\u0013!B:dC2\f\u0017BA\u0014%\u0005\u0019\te.\u001f*fM\u0006Q1m\u001c8oK\u000e$\u0018n\u001c8\u0011\u0005)rS\"A\u0016\u000b\u0005ma#\"A\u0017\u0002\u000b)\fg/\u0019=\n\u0005=Z#AC\"p]:,7\r^5p]\u0006Y1M]3eK:$\u0018.\u00197t+\u0005\u0011\u0004cA\u00124k%\u0011A\u0007\n\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005YZT\"A\u001c\u000b\u0005aJ\u0014!B7pI\u0016d'B\u0001\u001e\u001d\u0003\u001d\u0019w.\\7p]NL!\u0001P\u001c\u0003\u0017\r\u0013X\rZ3oi&\fGn]\u0001\rGJ,G-\u001a8uS\u0006d7\u000fI\u0001\u0007gf\u001cH/Z7\u0011\u0005\u0001+U\"A!\u000b\u0005\t\u001b\u0015!B1di>\u0014(\"\u0001#\u0002\t\u0005\\7.Y\u0005\u0003\r\u0006\u00131\"Q2u_J\u001c\u0016p\u001d;f[\u0006Y1\u000f^1ug\u0016sw-\u001b8f!\tIe*D\u0001K\u0015\tYE*A\u0003ti\u0006$8O\u0003\u0002N9\u0005!1m\u001c:f\u0013\ty%JA\u0006Ti\u0006$8/\u00128hS:,\u0017!B2m_\u000e\\\u0007C\u0001*V\u001b\u0005\u0019&B\u0001+:\u0003\u0011)H/\u001b7\n\u0005Y\u001b&!B\"m_\u000e\\\u0017!D2p]\u001aLw-\u001e:bi&|g\u000e\u0005\u0002Z96\t!L\u0003\u0002\\\u0019\u000611m\u001c8gS\u001eL!!\u0018.\u0003)\u001d\u000bG\u000f\\5oO\u000e{gNZ5hkJ\fG/[8o\u0003\u0019a\u0014N\\5u}Q9\u0001MY2eK\u001a<\u0007CA1\u0001\u001b\u0005A\u0002\"\u0002\u0015\t\u0001\u0004I\u0003\"\u0002\u0019\t\u0001\u0004\u0011\u0004\"\u0002 \t\u0001\u0004y\u0004\"B$\t\u0001\u0004A\u0005\"\u0002)\t\u0001\u0004\t\u0006\"B,\t\u0001\u0004A\u0016aC:fgNLwN\u001c)p_2,\u0012A\u001b\t\u0003C.L!\u0001\u001c\r\u0003\u001d)k7oU3tg&|g\u000eU8pY\u0006a1/Z:tS>t\u0007k\\8mA\u0005a1\u000f^1uS\u000e\fV/Z;fgV\t\u0001\u000fE\u0003rof\fI!D\u0001s\u0015\t\u0019H/\u0001\u0006d_:\u001cWO\u001d:f]RT!\u0001V;\u000b\u0003Y\fAA[1wC&\u0011\u0001P\u001d\u0002\u0012\u0007>t7-\u001e:sK:$\b*Y:i\u001b\u0006\u0004\bc\u0001>\u0002\u00049\u00111p \t\u0003y\u0012j\u0011! \u0006\u0003}\u0002\na\u0001\u0010:p_Rt\u0014bAA\u0001I\u00051\u0001K]3eK\u001aLA!!\u0002\u0002\b\t11\u000b\u001e:j]\u001eT1!!\u0001%!\rQ\u00131B\u0005\u0004\u0003\u001bY#a\u0003#fgRLg.\u0019;j_:\fQb\u001d;bi&\u001c\u0017+^3vKN\u0004\u0013\u0001D:uCRL7\rV8qS\u000e\u001c\u0018!D:uCRL7\rV8qS\u000e\u001c\b%A\u0006eKN$\u0018N\\1uS>tG\u0003BA\r\u0003w\u0001b!a\u0007\u00026\u0005%a\u0002BA\u000f\u0003_qA!a\b\u0002,9!\u0011\u0011EA\u0015\u001d\u0011\t\u0019#a\n\u000f\u0007q\f)#C\u0001 \u0013\tib$\u0003\u0002N9%\u0019\u0011Q\u0006'\u0002\u000fM,7o]5p]&!\u0011\u0011GA\u001a\u0003\u001d\u0001\u0018mY6bO\u0016T1!!\fM\u0013\u0011\t9$!\u000f\u0003\u0015\u0015C\bO]3tg&|gN\u0003\u0003\u00022\u0005M\u0002bBA\u001f\u001f\u0001\u0007\u0011qH\u0001\u000fU6\u001cH)Z:uS:\fG/[8o!\u0011\t\t%a\u0012\u000e\u0005\u0005\r#bAA#5\u00059!/Z9vKN$\u0018\u0002BA%\u0003\u0007\u0012aBS7t\t\u0016\u001cH/\u001b8bi&|g.\u0001\u0007qe>$WoY3s!>|G.\u0006\u0002\u0002PA\u0019\u0011-!\u0015\n\u0007\u0005M\u0003DA\bK[N\u0004&o\u001c3vG\u0016\u0014\bk\\8m\u00035\u0001(o\u001c3vG\u0016\u0014\bk\\8mA\u0005A\u0001O]8ek\u000e,'\u000f\u0006\u0004\u0002\\\u0005\u0005\u00141\r\t\u0004C\u0006u\u0013bAA01\tY!*\\:Qe>$WoY3s\u0011\u001d\t)B\u0005a\u0001\u0003\u0013Aq!!\u001a\u0013\u0001\u0004\t9'\u0001\u0007eK2Lg/\u001a:z\u001b>$W\rE\u0002$\u0003SJ1!a\u001b%\u0005\rIe\u000e^\u0001\fiJ\f7m[3s!>|G.\u0006\u0002\u0002rA\u0019\u0011-a\u001d\n\u0007\u0005U\u0004D\u0001\bK[N$&/Y2lKJ\u0004vn\u001c7\u0002\u0019Q\u0014\u0018mY6feB{w\u000e\u001c\u0011\u0002\u000fQ\u0014\u0018mY6feRQ\u0011QPAB\u0003\u000b\u000bY)a$\u0011\u0007\u0005\fy(C\u0002\u0002\u0002b\u0011!BS7t)J\f7m[3s\u0011\u001d\t)\"\u0006a\u0001\u0003\u0013Aq!a\"\u0016\u0001\u0004\tI)\u0001\u0005tK2,7\r^8s!\r\u00193'\u001f\u0005\b\u0003\u001b+\u0002\u0019AA4\u0003Ma\u0017n\u001d;f]\u0016\u0014H\u000b\u001b:fC\u0012\u001cu.\u001e8u\u0011\u001d\t\t*\u0006a\u0001\u0003'\u000ba\"\\3tg\u0006<W-T1uG\",'\u000f\u0005\u0003\u0002\u0016\u0006mUBAAL\u0015\r\tIJG\u0001\taJ|Go\\2pY&!\u0011QTAL\u0005EQUn]'fgN\fw-Z'bi\u000eDWM]\u0001\u0006G2|7/\u001a\u000b\u0003\u0003G\u00032aIAS\u0013\r\t9\u000b\n\u0002\u0005+:LG\u000f")
public class JmsConnection {
    private final Connection connection;
    private final Option<Credentials> credentials;
    private final JmsSessionPool sessionPool;
    private final ConcurrentHashMap<String, Destination> staticQueues;
    private final ConcurrentHashMap<String, Destination> staticTopics;
    private final JmsProducerPool producerPool;
    private final JmsTrackerPool trackerPool;

    public Option<Credentials> credentials() {
        return this.credentials;
    }

    private JmsSessionPool sessionPool() {
        return this.sessionPool;
    }

    private ConcurrentHashMap<String, Destination> staticQueues() {
        return this.staticQueues;
    }

    private ConcurrentHashMap<String, Destination> staticTopics() {
        return this.staticTopics;
    }

    public Function1<io.gatling.core.session.Session, Validation<Destination>> destination(JmsDestination jmsDestination) {
        Function1 function1;
        Session jmsSession = this.sessionPool().jmsSession();
        JmsDestination jmsDestination2 = jmsDestination;
        if (JmsTemporaryQueue$.MODULE$.equals(jmsDestination2)) {
            function1 = package.ExpressionSuccessWrapper$.MODULE$.expressionSuccess$extension(package$.MODULE$.ExpressionSuccessWrapper((Object)jmsSession.createTemporaryQueue()));
        } else if (JmsTemporaryTopic$.MODULE$.equals(jmsDestination2)) {
            function1 = package.ExpressionSuccessWrapper$.MODULE$.expressionSuccess$extension(package$.MODULE$.ExpressionSuccessWrapper((Object)jmsSession.createTemporaryTopic()));
        } else if (jmsDestination2 instanceof JmsQueue) {
            JmsQueue jmsQueue = (JmsQueue)jmsDestination2;
            Function1<io.gatling.core.session.Session, Validation<String>> name = jmsQueue.name();
            function1 = package.RichExpression$.MODULE$.map$extension(package$.MODULE$.RichExpression(name), (Function1 & Serializable & scala.Serializable)n -> (Destination)this.staticQueues().computeIfAbsent((String)n, x$1 -> jmsSession.createQueue(x$1)));
        } else if (jmsDestination2 instanceof JmsTopic) {
            JmsTopic jmsTopic = (JmsTopic)jmsDestination2;
            Function1<io.gatling.core.session.Session, Validation<String>> name = jmsTopic.name();
            function1 = package.RichExpression$.MODULE$.map$extension(package$.MODULE$.RichExpression(name), (Function1 & Serializable & scala.Serializable)n -> (Destination)this.staticTopics().computeIfAbsent((String)n, x$1 -> jmsSession.createTopic(x$1)));
        } else {
            throw new MatchError((Object)jmsDestination2);
        }
        return function1;
    }

    private JmsProducerPool producerPool() {
        return this.producerPool;
    }

    public JmsProducer producer(Destination destination, int deliveryMode) {
        return this.producerPool().producer(destination, deliveryMode);
    }

    private JmsTrackerPool trackerPool() {
        return this.trackerPool;
    }

    public JmsTracker tracker(Destination destination, Option<String> selector, int listenerThreadCount, JmsMessageMatcher messageMatcher) {
        return this.trackerPool().tracker(destination, selector, listenerThreadCount, messageMatcher);
    }

    public void close() {
        this.producerPool().close();
        this.sessionPool().close();
        this.connection.close();
    }

    public JmsConnection(Connection connection, Option<Credentials> credentials, ActorSystem system, StatsEngine statsEngine, Clock clock, GatlingConfiguration configuration) {
        this.connection = connection;
        this.credentials = credentials;
        this.sessionPool = new JmsSessionPool(connection);
        this.staticQueues = new ConcurrentHashMap();
        this.staticTopics = new ConcurrentHashMap();
        this.producerPool = new JmsProducerPool(this.sessionPool());
        this.trackerPool = new JmsTrackerPool(this.sessionPool(), system, statsEngine, clock, configuration);
    }
}

