/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.mojo;

import io.gatling.mojo.AbstractGatlingMojo;
import io.gatling.mojo.CompilationException;
import io.gatling.mojo.Fork;
import io.gatling.mojo.GatlingSimulationAssertionsFailedException;
import io.gatling.mojo.MojoConstants;
import io.gatling.mojo.MojoUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.exec.ExecuteException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.toolchain.Toolchain;
import org.codehaus.plexus.util.DirectoryScanner;

@Mojo(name="execute", defaultPhase=LifecyclePhase.INTEGRATION_TEST, requiresDependencyResolution=ResolutionScope.TEST)
public class GatlingMojo
extends AbstractGatlingMojo {
    @Parameter(property="gatling.noReports", alias="nr", defaultValue="false")
    private boolean noReports;
    @Parameter(property="gatling.reportsOnly", alias="ro")
    private String reportsOnly;
    @Parameter(property="gatling.simulationsFolder", alias="sf", defaultValue="${project.basedir}/src/test/scala")
    private File simulationsFolder;
    @Parameter(property="gatling.simulationClass", alias="sc")
    private String simulationClass;
    @Parameter(property="gatling.dataFolder", alias="df", defaultValue="${project.basedir}/src/test/resources/data")
    private File dataFolder;
    @Parameter(property="gatling.resultsFolder", alias="rf", defaultValue="${project.basedir}/target/gatling")
    private File resultsFolder;
    @Parameter(property="gatling.jvmArgs")
    private List<String> jvmArgs;
    @Parameter(property="gatling.zincJvmArgs")
    private List<String> zincJvmArgs;
    @Parameter(property="gatling.failOnError", defaultValue="true")
    private boolean failOnError;
    @Parameter(property="gatling.continueOnAssertionFailure", defaultValue="false")
    private boolean continueOnAssertionFailure;
    @Parameter(property="gatling.outputName", alias="on")
    private String outputDirectoryBaseName;
    @Parameter(property="gatling.propagateSystemProperties", defaultValue="true")
    private boolean propagateSystemProperties;
    @Parameter(property="gatling.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="gatling.disableCompiler", defaultValue="false")
    private boolean disableCompiler;
    @Parameter
    private String[] includes;
    @Parameter
    private String[] excludes;
    @Parameter(defaultValue="false")
    private boolean runMultipleSimulations;
    @Parameter(defaultValue="false")
    private boolean overrideGatlingJvmArgs;
    @Parameter(defaultValue="false")
    private boolean overrideZincJvmArgs;
    @Parameter(defaultValue="${plugin.artifacts}", readonly=true)
    private List<Artifact> artifacts;
    @Parameter(defaultValue="${basedir}/target/gatling", readonly=true)
    private File reportsDirectory;
    @Parameter(property="gatling.useOldJenkinsJUnitSupport", defaultValue="false")
    private boolean useOldJenkinsJUnitSupport;
    @Parameter(property="gatling.runDescription")
    private String runDescription;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        if (!this.skip) {
            this.resultsFolder.mkdirs();
            try {
                Toolchain toolchain = this.toolchainManager.getToolchainFromBuildContext("jdk", this.session);
                if (!this.disableCompiler) {
                    this.executeCompiler(this.zincJvmArgs(), this.buildTestClasspath(true), toolchain);
                }
                List<String> jvmArgs = this.gatlingJvmArgs();
                List<String> testClasspath = this.buildTestClasspath(false);
                if (this.reportsOnly != null) {
                    this.executeGatling(jvmArgs, this.gatlingArgs(null), testClasspath, toolchain);
                }
                List<String> simulations = this.simulations();
                this.iterateBySimulations(toolchain, jvmArgs, testClasspath, simulations);
            }
            catch (Exception e) {
                if (this.failOnError) {
                    throw new MojoExecutionException("Gatling failed.", e);
                }
                this.getLog().warn((CharSequence)"There were some errors while running your simulation, but failOnError was set to false won't fail your build.");
            }
            finally {
                this.copyJUnitReports();
            }
        } else {
            this.getLog().info((CharSequence)"Skipping gatling-maven-plugin");
        }
    }

    private void iterateBySimulations(Toolchain toolchain, List<String> jvmArgs, List<String> testClasspath, List<String> simulations) throws Exception {
        GatlingSimulationAssertionsFailedException exc = null;
        int simulationsCount = simulations.size();
        for (int i = 0; i < simulationsCount; ++i) {
            try {
                this.executeGatling(jvmArgs, this.gatlingArgs(simulations.get(i)), testClasspath, toolchain);
                continue;
            }
            catch (GatlingSimulationAssertionsFailedException e) {
                if (exc == null && i == simulationsCount - 1) {
                    throw e;
                }
                if (this.continueOnAssertionFailure) {
                    if (exc != null) continue;
                    exc = e;
                    continue;
                }
                throw e;
            }
        }
        if (exc != null) {
            this.getLog().warn((CharSequence)"There were some errors while running your simulation, but continueOnAssertionFailure was set to true, so your simulations continue to perform.");
            throw exc;
        }
    }

    private void executeCompiler(List<String> zincJvmArgs, List<String> testClasspath, Toolchain toolchain) throws Exception {
        List<String> compilerClasspath = this.buildCompilerClasspath();
        List<String> compilerArguments = this.compilerArgs(testClasspath);
        Fork forkedCompiler = new Fork("io.gatling.compiler.ZincCompiler", compilerClasspath, zincJvmArgs, compilerArguments, toolchain, false, this.getLog());
        try {
            forkedCompiler.run();
        }
        catch (ExecuteException e) {
            throw new CompilationException(e);
        }
    }

    private void executeGatling(List<String> gatlingJvmArgs, List<String> gatlingArgs, List<String> testClasspath, Toolchain toolchain) throws Exception {
        Fork forkedGatling = new Fork("io.gatling.app.Gatling", testClasspath, gatlingJvmArgs, gatlingArgs, toolchain, this.propagateSystemProperties, this.getLog());
        try {
            forkedGatling.run();
        }
        catch (ExecuteException e) {
            if (e.getExitValue() == 2) {
                throw new GatlingSimulationAssertionsFailedException(e);
            }
            throw e;
        }
    }

    private void copyJUnitReports() throws MojoExecutionException {
        try {
            if (this.useOldJenkinsJUnitSupport) {
                File[] runDirectories;
                for (File runDirectory : runDirectories = this.reportsDirectory.listFiles(File::isDirectory)) {
                    File assertionFile;
                    File jsDir = new File(runDirectory, "js");
                    if (!jsDir.exists() || !jsDir.isDirectory() || !(assertionFile = new File(jsDir, "assertions.xml")).exists()) continue;
                    File newAssertionFile = new File(this.reportsDirectory, "assertions-" + runDirectory.getName() + ".xml");
                    Files.copy(assertionFile.toPath(), newAssertionFile.toPath(), StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
                    this.getLog().info((CharSequence)("Copying assertion file " + assertionFile.getCanonicalPath() + " to " + newAssertionFile.getCanonicalPath()));
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to copy JUnit reports", (Exception)e);
        }
    }

    private List<String> buildCompilerClasspath() throws Exception {
        ArrayList<String> compilerClasspathElements = new ArrayList<String>();
        for (Artifact artifact : this.artifacts) {
            String groupId = artifact.getGroupId();
            if (groupId.startsWith("org.codehaus.plexus") || groupId.startsWith("org.apache.maven") || groupId.startsWith("org.sonatype")) continue;
            compilerClasspathElements.add(artifact.getFile().getCanonicalPath());
        }
        String gatlingVersion = this.getVersion("io.gatling", "gatling-core");
        Set gatlingCompilerAndDeps = this.resolve("io.gatling", "gatling-compiler", gatlingVersion, true).getArtifacts();
        for (Artifact artifact : gatlingCompilerAndDeps) {
            compilerClasspathElements.add(artifact.getFile().getCanonicalPath());
        }
        compilerClasspathElements.add(MojoUtils.locateJar(GatlingMojo.class));
        return compilerClasspathElements;
    }

    private List<String> gatlingJvmArgs() {
        ArrayList<String> completeGatlingJvmArgs = new ArrayList<String>();
        if (this.jvmArgs != null) {
            completeGatlingJvmArgs.addAll(this.jvmArgs);
        }
        if (this.overrideGatlingJvmArgs) {
            completeGatlingJvmArgs.addAll(MojoConstants.GATLING_JVM_ARGS);
        }
        return completeGatlingJvmArgs;
    }

    private List<String> zincJvmArgs() {
        ArrayList<String> completeZincJvmArgs = new ArrayList<String>();
        if (this.zincJvmArgs != null) {
            completeZincJvmArgs.addAll(this.zincJvmArgs);
        }
        if (this.overrideZincJvmArgs) {
            completeZincJvmArgs.addAll(MojoConstants.ZINC_JVM_ARGS);
        }
        return completeZincJvmArgs;
    }

    private List<String> simulations() throws MojoFailureException {
        if (this.simulationClass != null) {
            return Collections.singletonList(this.simulationClass);
        }
        List<String> simulations = this.resolveSimulations();
        if (simulations.isEmpty()) {
            this.getLog().error((CharSequence)"No simulations to run");
            throw new MojoFailureException("No simulations to run");
        }
        if (simulations.size() > 1 && !this.runMultipleSimulations) {
            String message = "More than 1 simulation to run, need to specify one, or enable runMultipleSimulations";
            this.getLog().error((CharSequence)message);
            throw new MojoFailureException(message);
        }
        return simulations;
    }

    private List<String> gatlingArgs(String simulationClass) throws Exception {
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(Arrays.asList("-df", this.dataFolder.getCanonicalPath(), "-rf", this.resultsFolder.getCanonicalPath(), "-bdf", this.bodiesFolder.getCanonicalPath(), "-sf", this.simulationsFolder.getCanonicalPath(), "-rd", this.runDescription, "-m"));
        if (this.noReports) {
            args.add("-nr");
        }
        this.addToArgsIfNotNull(args, simulationClass, "s");
        this.addToArgsIfNotNull(args, this.reportsOnly, "ro");
        this.addToArgsIfNotNull(args, this.outputDirectoryBaseName, "on");
        return args;
    }

    private List<String> compilerArgs(List<String> classpathElements) throws Exception {
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(Arrays.asList("-ccp", MojoUtils.toMultiPath(classpathElements)));
        args.addAll(Arrays.asList("-sf", this.simulationsFolder.getCanonicalPath()));
        args.addAll(Arrays.asList("-bf", this.compiledClassesFolder.getCanonicalPath()));
        return args;
    }

    private List<String> resolveSimulations() {
        try {
            URLClassLoader testClassLoader = new URLClassLoader(this.testClassPathUrls());
            Class<?> simulationClass = testClassLoader.loadClass("io.gatling.core.scenario.Simulation");
            List<String> includes = MojoUtils.arrayAsListEmptyIfNull(this.includes);
            List<String> excludes = MojoUtils.arrayAsListEmptyIfNull(this.excludes);
            ArrayList<String> simulationsClasses = new ArrayList<String>();
            for (String classFile : this.compiledClassFiles()) {
                Class<?> clazz;
                String className = this.pathToClassName(classFile);
                boolean isIncluded = includes.isEmpty() || includes.contains(className);
                boolean isExcluded = excludes.contains(className);
                if (!isIncluded || isExcluded || !simulationClass.isAssignableFrom(clazz = testClassLoader.loadClass(className)) || !this.isConcreteClass(clazz)) continue;
                simulationsClasses.add(className);
            }
            return simulationsClasses;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private URL[] testClassPathUrls() throws DependencyResolutionRequiredException, MalformedURLException {
        List testClasspathElements = this.mavenProject.getTestClasspathElements();
        URL[] urls = new URL[testClasspathElements.size()];
        for (int i = 0; i < testClasspathElements.size(); ++i) {
            URL url;
            String testClasspathElement = (String)testClasspathElements.get(i);
            urls[i] = url = Paths.get(testClasspathElement, new String[0]).toUri().toURL();
        }
        return urls;
    }

    private String[] compiledClassFiles() throws IOException {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(this.compiledClassesFolder.getCanonicalPath());
        scanner.setIncludes(new String[]{"**/*.class"});
        scanner.scan();
        return scanner.getIncludedFiles();
    }

    private String pathToClassName(String path) {
        return path.substring(0, path.length() - ".class".length()).replace(File.separatorChar, '.');
    }

    private boolean isConcreteClass(Class<?> clazz) {
        return !clazz.isInterface() && !Modifier.isAbstract(clazz.getModifiers());
    }
}

