/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.mojo;

import io.gatling.mojo.AbstractGatlingExecutionMojo;
import io.gatling.mojo.AssertionsSummary;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="verify", defaultPhase=LifecyclePhase.VERIFY)
public class VerifyMojo
extends AbstractGatlingExecutionMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping gatling-maven-plugin");
        } else {
            this.executePlugin();
        }
    }

    private void executePlugin() throws MojoFailureException, MojoExecutionException {
        try {
            this.verifyLastRun();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not read result files.", (Exception)e);
        }
    }

    private void verifyLastRun() throws IOException, MojoFailureException, MojoExecutionException {
        Path results = this.resultsFolder.toPath().resolve("lastRun.txt");
        if (results.toFile().exists()) {
            for (String line : Files.readAllLines(results)) {
                File directory = new File(this.resultsFolder, line);
                this.searchForAssertionFailures(directory);
            }
        }
    }

    private void searchForAssertionFailures(File runDirectory) throws MojoExecutionException, MojoFailureException {
        File assertionFile;
        File jsDir = new File(runDirectory, "js");
        if (jsDir.exists() && jsDir.isDirectory() && (assertionFile = new File(jsDir, "assertions.xml")).exists()) {
            this.analyzeFile(assertionFile);
        }
    }

    private void analyzeFile(File assertionFile) throws MojoExecutionException, MojoFailureException {
        AssertionsSummary summary;
        try {
            summary = AssertionsSummary.fromAssertionsFile(assertionFile);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to parse " + assertionFile.toString(), e);
        }
        if (summary.hasFailures()) {
            this.getLog().error((CharSequence)"Gatling simulation assertions failed.");
            this.getLog().error((CharSequence)("See the reports in " + this.resultsFolder.getPath() + " for details."));
            throw new MojoFailureException("Gatling simulation assertions failed!");
        }
    }
}

