/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.mojo;

import io.gatling.mojo.AbstractEnterprisePluginMojo;
import io.gatling.plugin.BatchEnterprisePlugin;
import io.gatling.plugin.deployment.DeploymentConfiguration;
import io.gatling.plugin.exceptions.EnterprisePluginException;
import io.gatling.plugin.model.DeploymentInfo;
import java.io.File;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Execute(goal="enterprisePackage")
@Mojo(name="enterpriseDeploy", requiresDependencyResolution=ResolutionScope.TEST)
public final class EnterpriseDeployMojo
extends AbstractEnterprisePluginMojo {
    public static final String CONTEXT_ENTERPRISE_DEPLOY_INFO = "enterprise_deploy_info";
    @Parameter(property="gatling.enterprise.validateSimulationId")
    private String validateSimulationId;
    @Parameter(property="gatling.enterprise.packageDescriptorFilename")
    private String customPackageFilename;

    public void execute() throws MojoFailureException {
        File packageFile = this.enterprisePackage();
        File deploymentFile = this.getDeploymentFile();
        Boolean isPrivateRepositoryEnabled = this.controlPlaneUrl != null;
        BatchEnterprisePlugin plugin = this.initBatchEnterprisePlugin();
        try {
            DeploymentInfo deploymentInfo = this.validateSimulationId == null ? plugin.deployFromDescriptor(deploymentFile, packageFile, this.mavenProject.getArtifactId(), isPrivateRepositoryEnabled) : plugin.deployFromDescriptor(deploymentFile, packageFile, this.mavenProject.getArtifactId(), isPrivateRepositoryEnabled, this.validateSimulationId);
            this.getPluginContext().put(CONTEXT_ENTERPRISE_DEPLOY_INFO, deploymentInfo);
        }
        catch (EnterprisePluginException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }

    private File getDeploymentFile() {
        File baseDir = this.mavenProject.getBasedir();
        if (this.customPackageFilename == null) {
            return DeploymentConfiguration.fromBaseDirectory((File)baseDir, null);
        }
        return baseDir.toPath().resolve(this.customPackageFilename).toFile();
    }
}

