/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.netty.util;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.incubator.channel.uring.IOUring;
import io.netty.incubator.channel.uring.IOUringDatagramChannel;
import io.netty.incubator.channel.uring.IOUringEventLoopGroup;
import io.netty.incubator.channel.uring.IOUringSocketChannel;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.concurrent.ThreadFactory;

public final class Transports {
    private static final ChannelFactory<? extends SocketChannel> EPOLL_SOCKET_CHANNEL_FACTORY = EpollSocketChannel::new;
    private static final ChannelFactory<? extends SocketChannel> IOURING_SOCKET_CHANNEL_FACTORY = IOUringSocketChannel::new;
    private static final ChannelFactory<? extends SocketChannel> NIO_SOCKET_CHANNEL_FACTORY = NioSocketChannel::new;
    private static final ChannelFactory<? extends DatagramChannel> EPOLL_DATAGRAM_CHANNEL_FACTORY = EpollDatagramChannel::new;
    private static final ChannelFactory<? extends DatagramChannel> IOURING_DATAGRAM_CHANNEL_FACTORY = IOUringDatagramChannel::new;
    private static final ChannelFactory<? extends DatagramChannel> NIO_DATAGRAM_CHANNEL_FACTORY = NioDatagramChannel::new;

    private Transports() {
    }

    public static EventLoopGroup newEventLoopGroup(boolean bl, boolean bl2, int n, String string) {
        DefaultThreadFactory defaultThreadFactory = new DefaultThreadFactory(string);
        if (bl) {
            if (bl2 && IOUring.isAvailable()) {
                return new IOUringEventLoopGroup(n, (ThreadFactory)defaultThreadFactory);
            }
            if (Epoll.isAvailable()) {
                return new EpollEventLoopGroup(n, (ThreadFactory)defaultThreadFactory);
            }
        }
        return new NioEventLoopGroup(n, (ThreadFactory)defaultThreadFactory);
    }

    public static ChannelFactory<? extends SocketChannel> newSocketChannelFactory(boolean bl, boolean bl2) {
        if (bl) {
            if (bl2 && IOUring.isAvailable()) {
                return IOURING_SOCKET_CHANNEL_FACTORY;
            }
            if (Epoll.isAvailable()) {
                return EPOLL_SOCKET_CHANNEL_FACTORY;
            }
        }
        return NIO_SOCKET_CHANNEL_FACTORY;
    }

    public static ChannelFactory<? extends DatagramChannel> newDatagramChannelFactory(boolean bl, boolean bl2) {
        if (bl) {
            if (bl2 && IOUring.isAvailable()) {
                return IOURING_DATAGRAM_CHANNEL_FACTORY;
            }
            if (Epoll.isAvailable()) {
                return EPOLL_DATAGRAM_CHANNEL_FACTORY;
            }
        }
        return NIO_DATAGRAM_CHANNEL_FACTORY;
    }

    public static void configureOptions(Bootstrap bootstrap, int n, boolean bl, boolean bl2) {
        ((Bootstrap)((Bootstrap)bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)n)).option(ChannelOption.TCP_NODELAY, (Object)bl)).option(ChannelOption.SO_KEEPALIVE, (Object)bl2);
    }
}

