/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.internal.bouncycastle.pqc.crypto.sphincsplus;

import io.gatling.recorder.internal.bouncycastle.crypto.Digest;
import io.gatling.recorder.internal.bouncycastle.pqc.crypto.sphincsplus.HarakaSBase;
import io.gatling.recorder.internal.bouncycastle.pqc.crypto.sphincsplus.HarakaSXof;

class HarakaS256Digest
extends HarakaSBase
implements Digest {
    public HarakaS256Digest(HarakaSXof harakaSXof) {
        this.haraka256_rc = harakaSXof.haraka256_rc;
    }

    @Override
    public String getAlgorithmName() {
        return "HarakaS-256";
    }

    @Override
    public int getDigestSize() {
        return 32;
    }

    @Override
    public void update(byte by) {
        if (this.off + 1 > 32) {
            throw new IllegalArgumentException("total input cannot be more than 32 bytes");
        }
        this.buffer[this.off++] = by;
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        if (this.off + n2 > 32) {
            throw new IllegalArgumentException("total input cannot be more than 32 bytes");
        }
        System.arraycopy(byArray, n, this.buffer, this.off, n2);
        this.off += n2;
    }

    @Override
    public int doFinal(byte[] byArray, int n) {
        byte[] byArray2 = new byte[64];
        this.haraka256Perm(byArray2);
        System.arraycopy(byArray2, 0, byArray, n, byArray.length - n);
        this.reset();
        return byArray.length;
    }

    @Override
    public void reset() {
        super.reset();
    }
}

