/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.internal.bouncycastle.dvcs;

import io.gatling.recorder.internal.bouncycastle.asn1.dvcs.Data;
import io.gatling.recorder.internal.bouncycastle.asn1.dvcs.TargetEtcChain;
import io.gatling.recorder.internal.bouncycastle.dvcs.DVCSConstructionException;
import io.gatling.recorder.internal.bouncycastle.dvcs.DVCSRequestData;
import io.gatling.recorder.internal.bouncycastle.dvcs.TargetChain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class VPKCRequestData
extends DVCSRequestData {
    private List chains;

    VPKCRequestData(Data data) throws DVCSConstructionException {
        super(data);
        TargetEtcChain[] targetEtcChainArray = data.getCerts();
        if (targetEtcChainArray == null) {
            throw new DVCSConstructionException("DVCSRequest.data.certs should be specified for VPKC service");
        }
        this.chains = new ArrayList(targetEtcChainArray.length);
        for (int i = 0; i != targetEtcChainArray.length; ++i) {
            this.chains.add(new TargetChain(targetEtcChainArray[i]));
        }
    }

    public List getCerts() {
        return Collections.unmodifiableList(this.chains);
    }
}

