/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.internal.bouncycastle.est;

import io.gatling.recorder.internal.bouncycastle.asn1.ASN1InputStream;
import io.gatling.recorder.internal.bouncycastle.asn1.ASN1Sequence;
import io.gatling.recorder.internal.bouncycastle.asn1.DERPrintableString;
import io.gatling.recorder.internal.bouncycastle.asn1.cms.ContentInfo;
import io.gatling.recorder.internal.bouncycastle.asn1.est.CsrAttrs;
import io.gatling.recorder.internal.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import io.gatling.recorder.internal.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import io.gatling.recorder.internal.bouncycastle.cert.X509CertificateHolder;
import io.gatling.recorder.internal.bouncycastle.cmc.CMCException;
import io.gatling.recorder.internal.bouncycastle.cmc.SimplePKIResponse;
import io.gatling.recorder.internal.bouncycastle.est.CACertsResponse;
import io.gatling.recorder.internal.bouncycastle.est.CSRAttributesResponse;
import io.gatling.recorder.internal.bouncycastle.est.CSRRequestResponse;
import io.gatling.recorder.internal.bouncycastle.est.ESTAuth;
import io.gatling.recorder.internal.bouncycastle.est.ESTClient;
import io.gatling.recorder.internal.bouncycastle.est.ESTClientProvider;
import io.gatling.recorder.internal.bouncycastle.est.ESTException;
import io.gatling.recorder.internal.bouncycastle.est.ESTRequest;
import io.gatling.recorder.internal.bouncycastle.est.ESTRequestBuilder;
import io.gatling.recorder.internal.bouncycastle.est.ESTResponse;
import io.gatling.recorder.internal.bouncycastle.est.ESTSourceConnectionListener;
import io.gatling.recorder.internal.bouncycastle.est.EnrollmentResponse;
import io.gatling.recorder.internal.bouncycastle.est.Source;
import io.gatling.recorder.internal.bouncycastle.est.TLSUniqueProvider;
import io.gatling.recorder.internal.bouncycastle.mime.BasicMimeParser;
import io.gatling.recorder.internal.bouncycastle.mime.ConstantMimeContext;
import io.gatling.recorder.internal.bouncycastle.mime.Headers;
import io.gatling.recorder.internal.bouncycastle.mime.MimeContext;
import io.gatling.recorder.internal.bouncycastle.mime.MimeParserContext;
import io.gatling.recorder.internal.bouncycastle.mime.MimeParserListener;
import io.gatling.recorder.internal.bouncycastle.operator.ContentSigner;
import io.gatling.recorder.internal.bouncycastle.pkcs.PKCS10CertificationRequest;
import io.gatling.recorder.internal.bouncycastle.pkcs.PKCS10CertificationRequestBuilder;
import io.gatling.recorder.internal.bouncycastle.util.Selector;
import io.gatling.recorder.internal.bouncycastle.util.Store;
import io.gatling.recorder.internal.bouncycastle.util.encoders.Base64;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Pattern;

public class ESTService {
    protected static final String CACERTS = "/cacerts";
    protected static final String SIMPLE_ENROLL = "/simpleenroll";
    protected static final String SIMPLE_REENROLL = "/simplereenroll";
    protected static final String FULLCMC = "/fullcmc";
    protected static final String SERVERGEN = "/serverkeygen";
    protected static final String CSRATTRS = "/csrattrs";
    protected static final Set<String> illegalParts = new HashSet<String>();
    private final String server;
    private final ESTClientProvider clientProvider;
    private static final Pattern pathInValid;

    ESTService(String string, String string2, ESTClientProvider eSTClientProvider) {
        string = this.verifyServer(string);
        if (string2 != null) {
            string2 = this.verifyLabel(string2);
            this.server = "https://" + string + "/.well-known/est/" + string2;
        } else {
            this.server = "https://" + string + "/.well-known/est";
        }
        this.clientProvider = eSTClientProvider;
    }

    public static X509CertificateHolder[] storeToArray(Store<X509CertificateHolder> store) {
        return ESTService.storeToArray(store, null);
    }

    public static X509CertificateHolder[] storeToArray(Store<X509CertificateHolder> store, Selector<X509CertificateHolder> selector) {
        Collection<X509CertificateHolder> collection = store.getMatches(selector);
        return collection.toArray(new X509CertificateHolder[collection.size()]);
    }

    /*
     * Unable to fully structure code
     */
    public CACertsResponse getCACerts() throws ESTException {
        var1_1 = null;
        var2_2 = null;
        var3_3 = null;
        var4_4 = null;
        var5_5 = false;
        try {
            var4_4 = new URL(this.server + "/cacerts");
            var6_6 = this.clientProvider.makeClient();
            var7_9 = new ESTRequestBuilder("GET", var4_4).withClient(var6_6).build();
            var1_1 = var6_6.doRequest(var7_9);
            var8_10 = null;
            var9_11 = null;
            if (var1_1.getStatusCode() == 200) {
                var10_12 = var1_1.getHeaders().getFirstValue("Content-Type");
                if (var10_12 == null || !var10_12.startsWith("application/pkcs7-mime")) {
                    var11_13 = var10_12 != null ? " got " + var10_12 : " but was not present.";
                    throw new ESTException("Response : " + var4_4.toString() + "Expecting application/pkcs7-mime " + var11_13, null, var1_1.getStatusCode(), var1_1.getInputStream());
                }
                try {
                    if (var1_1.getContentLength() == null || var1_1.getContentLength() <= 0L) ** GOTO lbl29
                    var11_14 = new ASN1InputStream(var1_1.getInputStream());
                    var12_16 = new SimplePKIResponse(ContentInfo.getInstance((ASN1Sequence)var11_14.readObject()));
                    var8_10 = var12_16.getCertificates();
                    var9_11 = var12_16.getCRLs();
                }
                catch (Throwable var11_15) {
                    throw new ESTException("Decoding CACerts: " + var4_4.toString() + " " + var11_15.getMessage(), var11_15, var1_1.getStatusCode(), var1_1.getInputStream());
                }
            } else if (var1_1.getStatusCode() != 204) {
                throw new ESTException("Get CACerts: " + var4_4.toString(), null, var1_1.getStatusCode(), var1_1.getInputStream());
            }
lbl29:
            // 4 sources

            var3_3 = new CACertsResponse(var8_10, var9_11, var7_9, var1_1.getSource(), this.clientProvider.isTrusted());
        }
        catch (Throwable var6_8) {
            var5_5 = true;
            if (var6_8 instanceof ESTException) {
                throw (ESTException)var6_8;
            }
            throw new ESTException(var6_8.getMessage(), var6_8);
        }
        finally {
            if (var1_1 != null) {
                try {
                    var1_1.close();
                }
                catch (Exception var6_7) {
                    var2_2 = var6_7;
                }
            }
        }
        if (var2_2 != null) {
            if (var2_2 instanceof ESTException) {
                throw (ESTException)var2_2;
            }
            throw new ESTException("Get CACerts: " + var4_4.toString(), (Throwable)var2_2, var1_1.getStatusCode(), null);
        }
        return var3_3;
    }

    public EnrollmentResponse simpleEnroll(EnrollmentResponse enrollmentResponse) throws Exception {
        if (!this.clientProvider.isTrusted()) {
            throw new IllegalStateException("No trust anchors.");
        }
        try (ESTResponse eSTResponse = null;){
            ESTClient eSTClient = this.clientProvider.makeClient();
            eSTResponse = eSTClient.doRequest(new ESTRequestBuilder(enrollmentResponse.getRequestToRetry()).withClient(eSTClient).build());
            EnrollmentResponse enrollmentResponse2 = this.handleEnrollResponse(eSTResponse);
            return enrollmentResponse2;
        }
    }

    protected EnrollmentResponse enroll(boolean bl, PKCS10CertificationRequest pKCS10CertificationRequest, ESTAuth eSTAuth, boolean bl2) throws IOException {
        if (!this.clientProvider.isTrusted()) {
            throw new IllegalStateException("No trust anchors.");
        }
        try (ESTResponse eSTResponse = null;){
            byte[] byArray = this.annotateRequest(pKCS10CertificationRequest.getEncoded()).getBytes();
            URL uRL = new URL(this.server + (bl2 ? SERVERGEN : (bl ? SIMPLE_REENROLL : SIMPLE_ENROLL)));
            ESTClient eSTClient = this.clientProvider.makeClient();
            ESTRequestBuilder eSTRequestBuilder = new ESTRequestBuilder("POST", uRL).withData(byArray).withClient(eSTClient);
            eSTRequestBuilder.addHeader("Content-Type", "application/pkcs10");
            eSTRequestBuilder.addHeader("Content-Length", "" + byArray.length);
            eSTRequestBuilder.addHeader("Content-Transfer-Encoding", "base64");
            if (eSTAuth != null) {
                eSTAuth.applyAuth(eSTRequestBuilder);
            }
            eSTResponse = eSTClient.doRequest(eSTRequestBuilder.build());
            EnrollmentResponse enrollmentResponse = this.handleEnrollResponse(eSTResponse);
            return enrollmentResponse;
        }
    }

    public EnrollmentResponse simpleEnroll(boolean bl, PKCS10CertificationRequest pKCS10CertificationRequest, ESTAuth eSTAuth) throws IOException {
        return this.enroll(bl, pKCS10CertificationRequest, eSTAuth, false);
    }

    public EnrollmentResponse simpleEnrollWithServersideCreation(PKCS10CertificationRequest pKCS10CertificationRequest, ESTAuth eSTAuth) throws IOException {
        return this.enroll(false, pKCS10CertificationRequest, eSTAuth, true);
    }

    public EnrollmentResponse enrollPop(boolean bl, final PKCS10CertificationRequestBuilder pKCS10CertificationRequestBuilder, final ContentSigner contentSigner, ESTAuth eSTAuth, boolean bl2) throws IOException {
        if (!this.clientProvider.isTrusted()) {
            throw new IllegalStateException("No trust anchors.");
        }
        try (ESTResponse eSTResponse = null;){
            URL uRL = new URL(this.server + (bl ? SIMPLE_REENROLL : SIMPLE_ENROLL));
            ESTClient eSTClient = this.clientProvider.makeClient();
            ESTRequestBuilder eSTRequestBuilder = new ESTRequestBuilder("POST", uRL).withClient(eSTClient).withConnectionListener(new ESTSourceConnectionListener(){

                public ESTRequest onConnection(Source source, ESTRequest eSTRequest) throws IOException {
                    if (source instanceof TLSUniqueProvider && ((TLSUniqueProvider)((Object)source)).isTLSUniqueAvailable()) {
                        PKCS10CertificationRequestBuilder pKCS10CertificationRequestBuilder2 = new PKCS10CertificationRequestBuilder(pKCS10CertificationRequestBuilder);
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        byte[] byArray = ((TLSUniqueProvider)((Object)source)).getTLSUnique();
                        pKCS10CertificationRequestBuilder2.setAttribute(PKCSObjectIdentifiers.pkcs_9_at_challengePassword, new DERPrintableString(Base64.toBase64String(byArray)));
                        byteArrayOutputStream.write(ESTService.this.annotateRequest(pKCS10CertificationRequestBuilder2.build(contentSigner).getEncoded()).getBytes());
                        byteArrayOutputStream.flush();
                        ESTRequestBuilder eSTRequestBuilder = new ESTRequestBuilder(eSTRequest).withData(byteArrayOutputStream.toByteArray());
                        eSTRequestBuilder.setHeader("Content-Type", "application/pkcs10");
                        eSTRequestBuilder.setHeader("Content-Transfer-Encoding", "base64");
                        eSTRequestBuilder.setHeader("Content-Length", Long.toString(byteArrayOutputStream.size()));
                        return eSTRequestBuilder.build();
                    }
                    throw new IOException("Source does not supply TLS unique.");
                }
            });
            if (eSTAuth != null) {
                eSTAuth.applyAuth(eSTRequestBuilder);
            }
            eSTResponse = eSTClient.doRequest(eSTRequestBuilder.build());
            EnrollmentResponse enrollmentResponse = this.handleEnrollResponse(eSTResponse);
            return enrollmentResponse;
        }
    }

    public EnrollmentResponse simpleEnrollPoP(boolean bl, PKCS10CertificationRequestBuilder pKCS10CertificationRequestBuilder, ContentSigner contentSigner, ESTAuth eSTAuth) throws IOException {
        return this.enrollPop(bl, pKCS10CertificationRequestBuilder, contentSigner, eSTAuth, false);
    }

    public EnrollmentResponse simpleEnrollPopWithServersideCreation(PKCS10CertificationRequestBuilder pKCS10CertificationRequestBuilder, ContentSigner contentSigner, ESTAuth eSTAuth) throws IOException {
        return this.enrollPop(false, pKCS10CertificationRequestBuilder, contentSigner, eSTAuth, true);
    }

    protected EnrollmentResponse handleEnrollResponse(ESTResponse eSTResponse) throws IOException {
        ESTRequest eSTRequest = eSTResponse.getOriginalRequest();
        Store<X509CertificateHolder> store = null;
        if (eSTResponse.getStatusCode() == 202) {
            String string = eSTResponse.getHeader("Retry-After");
            if (string == null) {
                throw new ESTException("Got Status 202 but not Retry-After header from: " + eSTRequest.getURL().toString());
            }
            long l = -1L;
            try {
                l = System.currentTimeMillis() + Long.parseLong(string) * 1000L;
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
                    simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                    l = simpleDateFormat.parse(string).getTime();
                }
                catch (Exception exception) {
                    throw new ESTException("Unable to parse Retry-After header:" + eSTRequest.getURL().toString() + " " + exception.getMessage(), null, eSTResponse.getStatusCode(), eSTResponse.getInputStream());
                }
            }
            return new EnrollmentResponse(null, l, eSTRequest, eSTResponse.getSource());
        }
        if (eSTResponse.getStatusCode() == 200 && eSTResponse.getHeaderOrEmpty("content-type").contains("multipart/mixed")) {
            Headers headers = new Headers(eSTResponse.getHeaderOrEmpty("content-type"), "base64");
            BasicMimeParser basicMimeParser = new BasicMimeParser(headers, eSTResponse.getInputStream());
            final Object[] objectArray = new Object[2];
            basicMimeParser.parse(new MimeParserListener(){

                @Override
                public MimeContext createContext(MimeParserContext mimeParserContext, Headers headers) {
                    return ConstantMimeContext.Instance;
                }

                @Override
                public void object(MimeParserContext mimeParserContext, Headers headers, InputStream inputStream) throws IOException {
                    if (headers.getContentType().contains("application/pkcs8")) {
                        ASN1InputStream aSN1InputStream = new ASN1InputStream(inputStream);
                        objectArray[0] = PrivateKeyInfo.getInstance(aSN1InputStream.readObject());
                        if (aSN1InputStream.readObject() != null) {
                            throw new ESTException("Unexpected ASN1 object after private key info");
                        }
                    } else if (headers.getContentType().contains("application/pkcs7-mime")) {
                        ASN1InputStream aSN1InputStream = new ASN1InputStream(inputStream);
                        try {
                            objectArray[1] = new SimplePKIResponse(ContentInfo.getInstance(aSN1InputStream.readObject()));
                        }
                        catch (CMCException cMCException) {
                            throw new IOException(cMCException.getMessage());
                        }
                        if (aSN1InputStream.readObject() != null) {
                            throw new ESTException("Unexpected ASN1 object after reading certificates");
                        }
                    }
                }
            });
            if (objectArray[0] == null || objectArray[1] == null) {
                throw new ESTException("received neither private key info and certificates");
            }
            store = ((SimplePKIResponse)objectArray[1]).getCertificates();
            return new EnrollmentResponse(store, -1L, null, eSTResponse.getSource(), PrivateKeyInfo.getInstance(objectArray[0]));
        }
        if (eSTResponse.getStatusCode() == 200) {
            ASN1InputStream aSN1InputStream = new ASN1InputStream(eSTResponse.getInputStream());
            SimplePKIResponse simplePKIResponse = null;
            try {
                simplePKIResponse = new SimplePKIResponse(ContentInfo.getInstance(aSN1InputStream.readObject()));
            }
            catch (CMCException cMCException) {
                throw new ESTException(cMCException.getMessage(), cMCException.getCause());
            }
            store = simplePKIResponse.getCertificates();
            return new EnrollmentResponse(store, -1L, null, eSTResponse.getSource());
        }
        throw new ESTException("Simple Enroll: " + eSTRequest.getURL().toString(), null, eSTResponse.getStatusCode(), eSTResponse.getInputStream());
    }

    /*
     * Unable to fully structure code
     */
    public CSRRequestResponse getCSRAttributes() throws ESTException {
        if (!this.clientProvider.isTrusted()) {
            throw new IllegalStateException("No trust anchors.");
        }
        var1_1 = null;
        var2_2 = null;
        var3_3 = null;
        var4_4 = null;
        try {
            var4_4 = new URL(this.server + "/csrattrs");
            var5_5 = this.clientProvider.makeClient();
            var6_8 = new ESTRequestBuilder("GET", var4_4).withClient(var5_5).build();
            var1_1 = var5_5.doRequest(var6_8);
            switch (var1_1.getStatusCode()) {
                case 200: {
                    try {
                        if (var1_1.getContentLength() != null && var1_1.getContentLength() > 0L) {
                            var7_9 = new ASN1InputStream(var1_1.getInputStream());
                            var8_11 = ASN1Sequence.getInstance(var7_9.readObject());
                            var2_2 = new CSRAttributesResponse(CsrAttrs.getInstance(var8_11));
                            ** break;
                        }
lbl20:
                        // 3 sources

                        break;
                    }
                    catch (Throwable var7_10) {
                        throw new ESTException("Decoding CACerts: " + var4_4.toString() + " " + var7_10.getMessage(), var7_10, var1_1.getStatusCode(), var1_1.getInputStream());
                    }
                }
                case 204: {
                    var2_2 = null;
                    ** break;
lbl26:
                    // 1 sources

                    break;
                }
                case 404: {
                    var2_2 = null;
                    ** break;
lbl30:
                    // 1 sources

                    break;
                }
                default: {
                    throw new ESTException("CSR Attribute request: " + var6_8.getURL().toString(), null, var1_1.getStatusCode(), var1_1.getInputStream());
                }
            }
        }
        catch (Throwable var5_7) {
            if (var5_7 instanceof ESTException) {
                throw (ESTException)var5_7;
            }
            throw new ESTException(var5_7.getMessage(), var5_7);
        }
        finally {
            if (var1_1 != null) {
                try {
                    var1_1.close();
                }
                catch (Exception var5_6) {
                    var3_3 = var5_6;
                }
            }
        }
        if (var3_3 != null) {
            if (var3_3 instanceof ESTException) {
                throw (ESTException)var3_3;
            }
            throw new ESTException(var3_3.getMessage(), (Throwable)var3_3, var1_1.getStatusCode(), null);
        }
        return new CSRRequestResponse(var2_2, var1_1.getSource());
    }

    private String annotateRequest(byte[] byArray) {
        int n = 0;
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        do {
            if (n + 48 < byArray.length) {
                printWriter.print(Base64.toBase64String(byArray, n, 48));
                n += 48;
            } else {
                printWriter.print(Base64.toBase64String(byArray, n, byArray.length - n));
                n = byArray.length;
            }
            printWriter.print('\n');
        } while (n < byArray.length);
        printWriter.flush();
        return stringWriter.toString();
    }

    private String verifyLabel(String string) {
        while (string.endsWith("/") && string.length() > 0) {
            string = string.substring(0, string.length() - 1);
        }
        while (string.startsWith("/") && string.length() > 0) {
            string = string.substring(1);
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("Label set but after trimming '/' is not zero length string.");
        }
        if (!pathInValid.matcher(string).matches()) {
            throw new IllegalArgumentException("Server path " + string + " contains invalid characters");
        }
        if (illegalParts.contains(string)) {
            throw new IllegalArgumentException("Label " + string + " is a reserved path segment.");
        }
        return string;
    }

    private String verifyServer(String string) {
        try {
            while (string.endsWith("/") && string.length() > 0) {
                string = string.substring(0, string.length() - 1);
            }
            if (string.contains("://")) {
                throw new IllegalArgumentException("Server contains scheme, must only be <dnsname/ipaddress>:port, https:// will be added arbitrarily.");
            }
            URL uRL = new URL("https://" + string);
            if (uRL.getPath().length() == 0 || uRL.getPath().equals("/")) {
                return string;
            }
            throw new IllegalArgumentException("Server contains path, must only be <dnsname/ipaddress>:port, a path of '/.well-known/est/<label>' will be added arbitrarily.");
        }
        catch (Exception exception) {
            if (exception instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)exception;
            }
            throw new IllegalArgumentException("Scheme and host is invalid: " + exception.getMessage(), exception);
        }
    }

    static {
        illegalParts.add(CACERTS.substring(1));
        illegalParts.add(SIMPLE_ENROLL.substring(1));
        illegalParts.add(SIMPLE_REENROLL.substring(1));
        illegalParts.add(FULLCMC.substring(1));
        illegalParts.add(SERVERGEN.substring(1));
        illegalParts.add(CSRATTRS.substring(1));
        pathInValid = Pattern.compile("^[0-9a-zA-Z_\\-.~!$&'()*+,;:=]+");
    }
}

