/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.internal.bouncycastle.pqc.crypto.sike;

import io.gatling.recorder.internal.bouncycastle.crypto.AsymmetricCipherKeyPair;
import io.gatling.recorder.internal.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import io.gatling.recorder.internal.bouncycastle.crypto.CryptoServicePurpose;
import io.gatling.recorder.internal.bouncycastle.crypto.CryptoServicesRegistrar;
import io.gatling.recorder.internal.bouncycastle.crypto.KeyGenerationParameters;
import io.gatling.recorder.internal.bouncycastle.crypto.constraints.DefaultServiceProperties;
import io.gatling.recorder.internal.bouncycastle.pqc.crypto.sike.SIKEEngine;
import io.gatling.recorder.internal.bouncycastle.pqc.crypto.sike.SIKEKeyGenerationParameters;
import io.gatling.recorder.internal.bouncycastle.pqc.crypto.sike.SIKEPrivateKeyParameters;
import io.gatling.recorder.internal.bouncycastle.pqc.crypto.sike.SIKEPublicKeyParameters;
import java.security.SecureRandom;

public class SIKEKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private SIKEKeyGenerationParameters sikeParams;
    private SecureRandom random;

    private void initialize(KeyGenerationParameters keyGenerationParameters) {
        this.sikeParams = (SIKEKeyGenerationParameters)keyGenerationParameters;
        this.random = keyGenerationParameters.getRandom();
    }

    private AsymmetricCipherKeyPair genKeyPair() {
        System.err.println("WARNING: the SIKE algorithm is only for research purposes, insecure");
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties("SIKEKeyGen", 0, this.sikeParams.getParameters(), CryptoServicePurpose.KEYGEN));
        SIKEEngine sIKEEngine = this.sikeParams.getParameters().getEngine();
        byte[] byArray = new byte[sIKEEngine.getPrivateKeySize()];
        byte[] byArray2 = new byte[sIKEEngine.getPublicKeySize()];
        sIKEEngine.crypto_kem_keypair(byArray2, byArray, this.random);
        SIKEPublicKeyParameters sIKEPublicKeyParameters = new SIKEPublicKeyParameters(this.sikeParams.getParameters(), byArray2);
        SIKEPrivateKeyParameters sIKEPrivateKeyParameters = new SIKEPrivateKeyParameters(this.sikeParams.getParameters(), byArray);
        return new AsymmetricCipherKeyPair(sIKEPublicKeyParameters, sIKEPrivateKeyParameters);
    }

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.initialize(keyGenerationParameters);
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        return this.genKeyPair();
    }
}

