/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.render;

import com.softwaremill.quicklens.package;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.http.fetch.ConcurrentResource;
import io.gatling.http.util.HttpHelper$;
import io.gatling.recorder.config.RecorderConfiguration;
import io.gatling.recorder.render.HttpTraffic;
import io.gatling.recorder.render.HttpTrafficElement;
import io.gatling.recorder.render.PauseElement;
import io.gatling.recorder.render.RequestBody;
import io.gatling.recorder.render.RequestElement;
import io.gatling.recorder.render.ResponseBody;
import io.gatling.recorder.render.TagElement;
import io.gatling.recorder.render.TimedScenarioElement;
import io.gatling.recorder.util.collection$;
import io.gatling.recorder.util.collection$RichSeq$;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

public final class HttpTraffic$
implements StrictLogging,
Serializable {
    public static final HttpTraffic$ MODULE$ = new HttpTraffic$();
    private static final int ConsecutiveResourcesMaxIntervalInMillis;
    private static Logger logger;

    static {
        StrictLogging.$init$((StrictLogging)MODULE$);
        ConsecutiveResourcesMaxIntervalInMillis = 1000;
    }

    public Logger logger() {
        return logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        logger = x$1;
    }

    private int ConsecutiveResourcesMaxIntervalInMillis() {
        return ConsecutiveResourcesMaxIntervalInMillis;
    }

    private boolean isRedirection(TimedScenarioElement<RequestElement> t) {
        return HttpHelper$.MODULE$.isRedirect(HttpResponseStatus.valueOf((int)t.element().statusCode()));
    }

    private List<TimedScenarioElement<RequestElement>> filterRedirection(Seq<TimedScenarioElement<RequestElement>> requests) {
        List<List<TimedScenarioElement<RequestElement>>> groupedRequests = collection$RichSeq$.MODULE$.groupAsLongAs$extension(collection$.MODULE$.RichSeq(requests), (Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)HttpTraffic$.MODULE$.isRedirection(t)));
        return groupedRequests.flatMap((Function1 & Serializable)x0$1 -> {
            List list = x0$1;
            if (!(list instanceof .colon.colon)) return list;
            .colon.colon colon2 = (.colon.colon)list;
            TimedScenarioElement timedScenarioElement = (TimedScenarioElement)colon2.head();
            List redirectedReqs = colon2.next$access$1();
            if (timedScenarioElement == null) return list;
            long firstSendTime = timedScenarioElement.sendTime();
            RequestElement firstReq = (RequestElement)timedScenarioElement.element();
            if (!redirectedReqs.nonEmpty()) return list;
            TimedScenarioElement timedScenarioElement2 = (TimedScenarioElement)redirectedReqs.last();
            if (timedScenarioElement2 == null) throw new MatchError((Object)timedScenarioElement2);
            long lastArrivalTime = timedScenarioElement2.arrivalTime();
            RequestElement lastReq = (RequestElement)timedScenarioElement2.element();
            Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)lastArrivalTime), (Object)lastReq);
            Tuple2 tuple22 = tuple2;
            long lastArrivalTime2 = tuple22._1$mcJ$sp();
            RequestElement lastReq2 = (RequestElement)tuple22._2();
            TimedScenarioElement[] timedScenarioElementArray = new TimedScenarioElement[1];
            int x$1 = lastReq2.statusCode();
            List<ConcurrentResource> x$2 = lastReq2.embeddedResources();
            String x$3 = firstReq.copy$default$1();
            String x$4 = firstReq.copy$default$2();
            HttpHeaders x$5 = firstReq.copy$default$3();
            Option<RequestBody> x$6 = firstReq.copy$default$4();
            HttpHeaders x$7 = firstReq.copy$default$5();
            Option<ResponseBody> x$8 = firstReq.copy$default$6();
            List<RequestElement> x$9 = firstReq.copy$default$9();
            timedScenarioElementArray[0] = new TimedScenarioElement<RequestElement>(firstSendTime, lastArrivalTime2, firstReq.copy(x$3, x$4, x$5, x$6, x$7, x$8, x$1, x$2, x$9));
            return (IterableOnce)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])timedScenarioElementArray));
        });
    }

    private List<TimedScenarioElement<RequestElement>> filterInferredResources(List<TimedScenarioElement<RequestElement>> requests) {
        ObjectRef globalAcc = ObjectRef.create((Object)package$.MODULE$.List().empty());
        ObjectRef currentAcc = ObjectRef.create((Object)package$.MODULE$.List().empty());
        LongRef previousArrivalTime = LongRef.create((long)((TimedScenarioElement)requests.head()).arrivalTime());
        requests.foreach((Function1 & Serializable)request -> {
            HttpTraffic$.$anonfun$filterInferredResources$1(previousArrivalTime, currentAcc, globalAcc, request);
            return BoxedUnit.UNIT;
        });
        List list = (List)globalAcc.elem;
        List groupChainedRequests = ((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new List[]{(List)currentAcc.elem}))).$colon$colon$colon(list);
        return groupChainedRequests.map((Function1 & Serializable)x0$1 -> {
            boolean bl = false;
            .colon.colon colon2 = null;
            List list = x0$1;
            if (list instanceof .colon.colon) {
                bl = true;
                colon2 = (.colon.colon)list;
                TimedScenarioElement request2 = (TimedScenarioElement)colon2.head();
                List list2 = colon2.next$access$1();
                Nil$ nil$ = package$.MODULE$.Nil();
                List list3 = list2;
                if (nil$ == null) {
                    if (list3 == null) return request2;
                } else if (nil$.equals(list3)) {
                    return request2;
                }
            }
            if (!bl) throw new IllegalArgumentException("groupChainedRequests shouldn't be empty");
            TimedScenarioElement mainRequest = (TimedScenarioElement)colon2.head();
            List resources = colon2.next$access$1();
            List nonEmbeddedResources = resources.filterNot((Function1 & Serializable)request -> BoxesRunTime.boxToBoolean((boolean)HttpTraffic$.$anonfun$filterInferredResources$3(mainRequest, request))).map((Function1 & Serializable)x$3 -> (RequestElement)x$3.element());
            TimedScenarioElement fresh$macro$3 = mainRequest;
            TimedScenarioElement fresh$macro$6 = (TimedScenarioElement)new package.PathModify((Object)fresh$macro$3, (Function2 & Serializable)(fresh$macro$1, fresh$macro$2) -> {
                long x$1 = fresh$macro$2.apply$mcJJ$sp(fresh$macro$1.arrivalTime());
                long x$2 = fresh$macro$1.copy$default$1();
                RequestElement x$3 = (RequestElement)fresh$macro$1.copy$default$3();
                return fresh$macro$1.copy(x$2, x$1, x$3);
            }).setTo(resources.map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.arrivalTime())).max((Ordering)Ordering.Long$.MODULE$));
            return (TimedScenarioElement)new package.PathModify((Object)fresh$macro$6, (Function2 & Serializable)(fresh$macro$4, fresh$macro$5) -> {
                List x$4 = (List)fresh$macro$5.apply(((RequestElement)fresh$macro$4.element()).nonEmbeddedResources());
                String x$5 = ((RequestElement)fresh$macro$4.element()).copy$default$1();
                String x$6 = ((RequestElement)fresh$macro$4.element()).copy$default$2();
                HttpHeaders x$7 = ((RequestElement)fresh$macro$4.element()).copy$default$3();
                Option<RequestBody> x$8 = ((RequestElement)fresh$macro$4.element()).copy$default$4();
                HttpHeaders x$9 = ((RequestElement)fresh$macro$4.element()).copy$default$5();
                Option<ResponseBody> x$10 = ((RequestElement)fresh$macro$4.element()).copy$default$6();
                int x$11 = ((RequestElement)fresh$macro$4.element()).copy$default$7();
                List<ConcurrentResource> x$12 = ((RequestElement)fresh$macro$4.element()).copy$default$8();
                RequestElement x$13 = ((RequestElement)fresh$macro$4.element()).copy(x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, (List<RequestElement>)x$4);
                long x$14 = fresh$macro$4.copy$default$1();
                long x$15 = fresh$macro$4.copy$default$2();
                return fresh$macro$4.copy(x$14, x$15, x$13);
            }).setTo((Object)nonEmbeddedResources);
        });
    }

    private List<HttpTrafficElement> mergeWithPauses(List<TimedScenarioElement<RequestElement>> sortedRequests, List<TimedScenarioElement<TagElement>> tags, Duration thresholdForPauseCreation) {
        List list;
        if (IterableOps.SizeCompareOps$.MODULE$.$less$eq$extension(sortedRequests.sizeIs(), 1)) {
            list = sortedRequests.map((Function1 & Serializable)x$7 -> (RequestElement)x$7.element());
        } else {
            List allElements = (List)((SeqOps)sortedRequests.$plus$plus(tags)).sortBy((Function1 & Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.arrivalTime()), (Ordering)Ordering.Long$.MODULE$);
            LongRef lastSendDateTime = LongRef.create((long)((TimedScenarioElement)allElements.last()).sendTime());
            List allElementsWithTagsStickingToNextRequest = (List)allElements.reverse().foldLeft((Object)package$.MODULE$.List().empty(), (Function2 & Serializable)(acc, current) -> {
                List list;
                Object t;
                TimedScenarioElement timedScenarioElement = current;
                if (timedScenarioElement != null && (t = timedScenarioElement.element()) instanceof TagElement) {
                    TagElement tagElement = (TagElement)t;
                    String text = tagElement.text();
                    TimedScenarioElement<TagElement> timedScenarioElement2 = new TimedScenarioElement<TagElement>(lastSendDateTime$1.elem, lastSendDateTime$1.elem, new TagElement(text));
                    list = acc.$colon$colon(timedScenarioElement2);
                } else if (timedScenarioElement != null) {
                    long sendTime;
                    lastSendDateTime$1.elem = sendTime = timedScenarioElement.sendTime();
                    TimedScenarioElement timedScenarioElement3 = current;
                    list = acc.$colon$colon((Object)timedScenarioElement3);
                } else {
                    throw new MatchError((Object)timedScenarioElement);
                }
                return list;
            });
            List pauses = ((List)((StrictOptimizedIterableOps)allElementsWithTagsStickingToNextRequest.tail()).zip((IterableOnce)allElementsWithTagsStickingToNextRequest)).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TimedScenarioElement element = (TimedScenarioElement)tuple2._1();
                TimedScenarioElement previousElement = (TimedScenarioElement)tuple2._2();
                long pauseDurationInMillis = scala.math.package$.MODULE$.max(element.sendTime() - previousElement.arrivalTime(), 0L);
                TimedScenarioElement<PauseElement> timedScenarioElement = new TimedScenarioElement<PauseElement>(element.arrivalTime(), element.arrivalTime(), new PauseElement(new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(pauseDurationInMillis)).milliseconds()));
                return timedScenarioElement;
            });
            List combined = (List)((List)allElementsWithTagsStickingToNextRequest.zip((IterableOnce)pauses)).flatMap((Function1 & Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TimedScenarioElement elem = (TimedScenarioElement)tuple2._1();
                TimedScenarioElement pause = (TimedScenarioElement)tuple2._2();
                List list = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TimedScenarioElement[]{elem, pause}));
                return list;
            }).$plus$plus((IterableOnce)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TimedScenarioElement[]{(TimedScenarioElement)allElementsWithTagsStickingToNextRequest.last()})));
            list = combined.filter((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)HttpTraffic$.$anonfun$mergeWithPauses$6(thresholdForPauseCreation, x0$3))).map((Function1 & Serializable)x$9 -> x$9.element());
        }
        return list;
    }

    public HttpTraffic apply(List<TimedScenarioElement<RequestElement>> requests, List<TimedScenarioElement<TagElement>> tags, RecorderConfiguration config) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        List<TimedScenarioElement<RequestElement>> requests2;
        List<TimedScenarioElement<RequestElement>> sortedRequests = (List<TimedScenarioElement<RequestElement>>)requests.sortBy((Function1 & Serializable)x$10 -> BoxesRunTime.boxToLong((long)x$10.arrivalTime()), (Ordering)Ordering.Long$.MODULE$);
        List<TimedScenarioElement<RequestElement>> requests1 = config.http().followRedirect() ? this.filterRedirection((Seq<TimedScenarioElement<RequestElement>>)sortedRequests) : sortedRequests;
        List<TimedScenarioElement<RequestElement>> list = requests2 = config.http().inferHtmlResources() ? this.filterInferredResources(requests1) : requests1;
        if (config.http().followRedirect()) {
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Cleaning redirections: {}->{} requests", new Object[]{BoxesRunTime.boxToInteger((int)requests.size()), BoxesRunTime.boxToInteger((int)requests1.size())});
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (config.http().inferHtmlResources()) {
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Cleaning automatically fetched HTML resources: {}->{} requests", new Object[]{BoxesRunTime.boxToInteger((int)requests1.size()), BoxesRunTime.boxToInteger((int)requests2.size())});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        List<HttpTrafficElement> allElements = this.mergeWithPauses(requests2, tags, config.core().thresholdForPauseCreation());
        return new HttpTraffic(allElements);
    }

    public HttpTraffic apply(List<HttpTrafficElement> elements) {
        return new HttpTraffic(elements);
    }

    public Option<List<HttpTrafficElement>> unapply(HttpTraffic x$0) {
        return x$0 == null ? None$.MODULE$ : new Some(x$0.elements());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(HttpTraffic$.class);
    }

    public static final /* synthetic */ void $anonfun$filterInferredResources$1(LongRef previousArrivalTime$1, ObjectRef currentAcc$1, ObjectRef globalAcc$1, TimedScenarioElement request) {
        if (request.sendTime() - previousArrivalTime$1.elem < (long)MODULE$.ConsecutiveResourcesMaxIntervalInMillis()) {
            List list = (List)currentAcc$1.elem;
            currentAcc$1.elem = ((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TimedScenarioElement[]{request}))).$colon$colon$colon(list);
        } else {
            if (((List)currentAcc$1.elem).nonEmpty()) {
                List list = (List)globalAcc$1.elem;
                globalAcc$1.elem = ((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new List[]{(List)currentAcc$1.elem}))).$colon$colon$colon(list);
            }
            currentAcc$1.elem = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TimedScenarioElement[]{request}));
        }
        previousArrivalTime$1.elem = request.arrivalTime();
    }

    public static final /* synthetic */ boolean $anonfun$filterInferredResources$4(TimedScenarioElement request$1, ConcurrentResource x$2) {
        String string = x$2.url();
        String string2 = ((RequestElement)request$1.element()).uri();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$filterInferredResources$3(TimedScenarioElement mainRequest$1, TimedScenarioElement request) {
        return ((RequestElement)mainRequest$1.element()).embeddedResources().exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)HttpTraffic$.$anonfun$filterInferredResources$4(request, x$2)));
    }

    public static final /* synthetic */ boolean $anonfun$mergeWithPauses$6(Duration thresholdForPauseCreation$1, TimedScenarioElement x0$3) {
        boolean bl;
        Object t;
        TimedScenarioElement timedScenarioElement = x0$3;
        if (timedScenarioElement != null && (t = timedScenarioElement.element()) instanceof PauseElement) {
            PauseElement pauseElement = (PauseElement)t;
            FiniteDuration duration = pauseElement.duration();
            bl = duration.$greater$eq((Object)thresholdForPauseCreation$1);
        } else {
            bl = true;
        }
        return bl;
    }

    private HttpTraffic$() {
    }
}

