/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.coursier.cache.loggers;

import coursierapi.shaded.scala.None$;
import coursierapi.shaded.scala.Option;
import coursierapi.shaded.scala.Product;
import coursierapi.shaded.scala.Some;
import coursierapi.shaded.scala.collection.Iterator;
import coursierapi.shaded.scala.runtime.BoxesRunTime;
import coursierapi.shaded.scala.runtime.ScalaRunTime$;
import coursierapi.shaded.scala.runtime.Statics;
import java.io.Serializable;

public abstract class RefreshInfo
implements Serializable,
Product {
    @Override
    public Iterator<Object> productIterator() {
        return Product.productIterator$(this);
    }

    @Override
    public String productPrefix() {
        return Product.productPrefix$(this);
    }

    public abstract Option<Object> fraction();

    public abstract boolean watching();

    public RefreshInfo() {
        Product.$init$(this);
    }

    public static final class CheckUpdateInfo
    extends RefreshInfo {
        private final Option<Object> currentTimeOpt;
        private final Option<Object> remoteTimeOpt;
        private final boolean isDone;

        public Option<Object> currentTimeOpt() {
            return this.currentTimeOpt;
        }

        public Option<Object> remoteTimeOpt() {
            return this.remoteTimeOpt;
        }

        public boolean isDone() {
            return this.isDone;
        }

        @Override
        public boolean watching() {
            return false;
        }

        public None$ fraction() {
            return None$.MODULE$;
        }

        public CheckUpdateInfo copy(Option<Object> currentTimeOpt, Option<Object> remoteTimeOpt, boolean isDone) {
            return new CheckUpdateInfo(currentTimeOpt, remoteTimeOpt, isDone);
        }

        public Option<Object> copy$default$1() {
            return this.currentTimeOpt();
        }

        @Override
        public String productPrefix() {
            return "CheckUpdateInfo";
        }

        @Override
        public int productArity() {
            return 3;
        }

        @Override
        public Object productElement(int x$1) {
            Serializable serializable;
            int n = x$1;
            switch (n) {
                case 0: {
                    serializable = this.currentTimeOpt();
                    break;
                }
                case 1: {
                    serializable = this.remoteTimeOpt();
                    break;
                }
                case 2: {
                    serializable = BoxesRunTime.boxToBoolean(this.isDone());
                    break;
                }
                default: {
                    serializable = Statics.ioobe(x$1);
                    break;
                }
            }
            return serializable;
        }

        @Override
        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator(this);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, Statics.anyHash(this.currentTimeOpt()));
            n = Statics.mix(n, Statics.anyHash(this.remoteTimeOpt()));
            n = Statics.mix(n, this.isDone() ? 1231 : 1237);
            return Statics.finalizeHash(n, 3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof CheckUpdateInfo)) return false;
            boolean bl = true;
            if (!bl) return false;
            CheckUpdateInfo checkUpdateInfo = (CheckUpdateInfo)x$1;
            if (this.isDone() != checkUpdateInfo.isDone()) return false;
            Option<Object> option = this.currentTimeOpt();
            Option<Object> option2 = checkUpdateInfo.currentTimeOpt();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<Object> option3 = this.remoteTimeOpt();
            Option<Object> option4 = checkUpdateInfo.remoteTimeOpt();
            if (option3 == null) {
                if (option4 == null) return true;
                return false;
            } else {
                if (!option3.equals(option4)) return false;
                return true;
            }
        }

        public CheckUpdateInfo(Option<Object> currentTimeOpt, Option<Object> remoteTimeOpt, boolean isDone) {
            this.currentTimeOpt = currentTimeOpt;
            this.remoteTimeOpt = remoteTimeOpt;
            this.isDone = isDone;
        }
    }

    public static final class DownloadInfo
    extends RefreshInfo {
        private final long downloaded;
        private final long previouslyDownloaded;
        private final Option<Object> length;
        private final long startTime;
        private final boolean updateCheck;
        private final boolean watching;

        public long downloaded() {
            return this.downloaded;
        }

        public long previouslyDownloaded() {
            return this.previouslyDownloaded;
        }

        public Option<Object> length() {
            return this.length;
        }

        public long startTime() {
            return this.startTime;
        }

        public boolean updateCheck() {
            return this.updateCheck;
        }

        @Override
        public boolean watching() {
            return this.watching;
        }

        @Override
        public Option<Object> fraction() {
            return this.length().map(x$1 -> (double)this.downloaded() / (double)x$1);
        }

        public Option<Object> rate() {
            long currentTime = System.currentTimeMillis();
            return currentTime > this.startTime() ? new Some<Double>(BoxesRunTime.boxToDouble((double)(this.downloaded() - this.previouslyDownloaded()) / (double)(System.currentTimeMillis() - this.startTime()) * 1000.0)) : None$.MODULE$;
        }

        public DownloadInfo copy(long downloaded, long previouslyDownloaded, Option<Object> length, long startTime, boolean updateCheck, boolean watching) {
            return new DownloadInfo(downloaded, previouslyDownloaded, length, startTime, updateCheck, watching);
        }

        public long copy$default$1() {
            return this.downloaded();
        }

        public long copy$default$2() {
            return this.previouslyDownloaded();
        }

        public Option<Object> copy$default$3() {
            return this.length();
        }

        public long copy$default$4() {
            return this.startTime();
        }

        public boolean copy$default$5() {
            return this.updateCheck();
        }

        public boolean copy$default$6() {
            return this.watching();
        }

        @Override
        public String productPrefix() {
            return "DownloadInfo";
        }

        @Override
        public int productArity() {
            return 6;
        }

        @Override
        public Object productElement(int x$1) {
            Serializable serializable;
            int n = x$1;
            switch (n) {
                case 0: {
                    serializable = BoxesRunTime.boxToLong(this.downloaded());
                    break;
                }
                case 1: {
                    serializable = BoxesRunTime.boxToLong(this.previouslyDownloaded());
                    break;
                }
                case 2: {
                    serializable = this.length();
                    break;
                }
                case 3: {
                    serializable = BoxesRunTime.boxToLong(this.startTime());
                    break;
                }
                case 4: {
                    serializable = BoxesRunTime.boxToBoolean(this.updateCheck());
                    break;
                }
                case 5: {
                    serializable = BoxesRunTime.boxToBoolean(this.watching());
                    break;
                }
                default: {
                    serializable = Statics.ioobe(x$1);
                    break;
                }
            }
            return serializable;
        }

        @Override
        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator(this);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, Statics.longHash(this.downloaded()));
            n = Statics.mix(n, Statics.longHash(this.previouslyDownloaded()));
            n = Statics.mix(n, Statics.anyHash(this.length()));
            n = Statics.mix(n, Statics.longHash(this.startTime()));
            n = Statics.mix(n, this.updateCheck() ? 1231 : 1237);
            n = Statics.mix(n, this.watching() ? 1231 : 1237);
            return Statics.finalizeHash(n, 6);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof DownloadInfo)) return false;
            boolean bl = true;
            if (!bl) return false;
            DownloadInfo downloadInfo = (DownloadInfo)x$1;
            if (this.downloaded() != downloadInfo.downloaded()) return false;
            if (this.previouslyDownloaded() != downloadInfo.previouslyDownloaded()) return false;
            if (this.startTime() != downloadInfo.startTime()) return false;
            if (this.updateCheck() != downloadInfo.updateCheck()) return false;
            if (this.watching() != downloadInfo.watching()) return false;
            Option<Object> option = this.length();
            Option<Object> option2 = downloadInfo.length();
            if (option != null) {
                if (!option.equals(option2)) return false;
                return true;
            }
            if (option2 == null) return true;
            return false;
        }

        public DownloadInfo(long downloaded, long previouslyDownloaded, Option<Object> length, long startTime, boolean updateCheck, boolean watching) {
            this.downloaded = downloaded;
            this.previouslyDownloaded = previouslyDownloaded;
            this.length = length;
            this.startTime = startTime;
            this.updateCheck = updateCheck;
            this.watching = watching;
        }
    }
}

