/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.coursier.paths;

import coursierapi.shaded.coursier.cache.shaded.io.github.soc.directories.ProjectDirectories;
import coursierapi.shaded.coursier.paths.Util;
import java.io.File;
import java.io.IOException;

public final class CoursierPaths {
    private static final Object coursierDirectoriesLock = new Object();
    private static ProjectDirectories coursierDirectories0;
    private static final Object cacheDirectoryLock;
    private static volatile File cacheDirectory0;
    private static final Object configDirectoryLock;
    private static volatile File configDirectory0;
    private static final Object dataLocalDirectoryLock;
    private static volatile File dataLocalDirectory0;

    private static String computeCacheDirectory() throws IOException {
        File file;
        String string = System.getenv("COURSIER_CACHE");
        if (string == null) {
            string = System.getProperty("coursierapi.shaded.coursier.cache");
        }
        if (string != null) {
            return string;
        }
        File file2 = new File(CoursierPaths.coursierDirectories().cacheDir);
        File file3 = new File(file2, "v1");
        String string2 = file3.getAbsolutePath();
        if (file2.isDirectory()) {
            string = string2;
        }
        if (string == null && (file = new File(System.getProperty("user.home") + "/.coursier")).isDirectory()) {
            string = System.getProperty("user.home") + "/.coursier/cache/v1/";
        }
        if (string == null) {
            string = string2;
            Util.createDirectories(file3.toPath());
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File cacheDirectory() throws IOException {
        if (cacheDirectory0 == null) {
            Object object = cacheDirectoryLock;
            synchronized (object) {
                if (cacheDirectory0 == null) {
                    cacheDirectory0 = new File(CoursierPaths.computeCacheDirectory()).getAbsoluteFile();
                }
            }
        }
        return cacheDirectory0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ProjectDirectories coursierDirectories() throws IOException {
        if (coursierDirectories0 == null) {
            Object object = coursierDirectoriesLock;
            synchronized (object) {
                if (coursierDirectories0 == null) {
                    coursierDirectories0 = ProjectDirectories.from(null, null, "Coursier");
                }
            }
        }
        return coursierDirectories0;
    }

    private static String computeConfigDirectory() throws IOException {
        String string = System.getenv("COURSIER_CONFIG_DIR");
        if (string == null) {
            string = System.getProperty("coursierapi.shaded.coursier.config-dir");
        }
        if (string != null) {
            return string;
        }
        return CoursierPaths.coursierDirectories().configDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File configDirectory() throws IOException {
        if (configDirectory0 == null) {
            Object object = configDirectoryLock;
            synchronized (object) {
                if (configDirectory0 == null) {
                    configDirectory0 = new File(CoursierPaths.computeConfigDirectory()).getAbsoluteFile();
                }
            }
        }
        return configDirectory0;
    }

    static {
        cacheDirectoryLock = new Object();
        cacheDirectory0 = null;
        configDirectoryLock = new Object();
        configDirectory0 = null;
        dataLocalDirectoryLock = new Object();
        dataLocalDirectory0 = null;
    }
}

