/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.commonscompress.archivers.zip;

import coursierapi.shaded.commonscompress.archivers.ArchiveEntry;
import coursierapi.shaded.commonscompress.archivers.zip.ExtraFieldParsingBehavior;
import coursierapi.shaded.commonscompress.archivers.zip.ExtraFieldUtils;
import coursierapi.shaded.commonscompress.archivers.zip.GeneralPurposeBit;
import coursierapi.shaded.commonscompress.archivers.zip.UnparseableExtraFieldData;
import coursierapi.shaded.commonscompress.archivers.zip.UnrecognizedExtraField;
import coursierapi.shaded.commonscompress.archivers.zip.ZipExtraField;
import coursierapi.shaded.commonscompress.archivers.zip.ZipShort;
import coursierapi.shaded.commonscompress.utils.ByteUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;

public class ZipArchiveEntry
extends ZipEntry
implements ArchiveEntry {
    private int method = -1;
    private long size = -1L;
    private int internalAttributes;
    private int versionRequired;
    private int versionMadeBy;
    private int platform = 0;
    private int rawFlag;
    private long externalAttributes;
    private ZipExtraField[] extraFields;
    private UnparseableExtraFieldData unparseableExtra;
    private String name;
    private byte[] rawName;
    private GeneralPurposeBit gpb = new GeneralPurposeBit();
    private long localHeaderOffset = -1L;
    private long dataOffset = -1L;
    private boolean isStreamContiguous;
    private NameSource nameSource = NameSource.NAME;
    private CommentSource commentSource = CommentSource.COMMENT;
    private long diskNumberStart;
    static final ZipArchiveEntry[] EMPTY_ZIP_ARCHIVE_ENTRY_ARRAY = new ZipArchiveEntry[0];

    public ZipArchiveEntry(String name) {
        super(name);
        this.setName(name);
    }

    protected ZipArchiveEntry() {
        this("");
    }

    @Override
    public Object clone() {
        ZipArchiveEntry e = (ZipArchiveEntry)super.clone();
        e.setInternalAttributes(this.getInternalAttributes());
        e.setExternalAttributes(this.getExternalAttributes());
        e.setExtraFields(this.getAllExtraFieldsNoCopy());
        return e;
    }

    @Override
    public int getMethod() {
        return this.method;
    }

    @Override
    public void setMethod(int method) {
        if (method < 0) {
            throw new IllegalArgumentException("ZIP compression method can not be negative: " + method);
        }
        this.method = method;
    }

    public int getInternalAttributes() {
        return this.internalAttributes;
    }

    public void setInternalAttributes(int value) {
        this.internalAttributes = value;
    }

    public long getExternalAttributes() {
        return this.externalAttributes;
    }

    public void setExternalAttributes(long value) {
        this.externalAttributes = value;
    }

    public int getUnixMode() {
        return this.platform != 3 ? 0 : (int)(this.getExternalAttributes() >> 16 & 0xFFFFL);
    }

    public boolean isUnixSymlink() {
        return (this.getUnixMode() & 0xF000) == 40960;
    }

    public int getPlatform() {
        return this.platform;
    }

    protected void setPlatform(int platform) {
        this.platform = platform;
    }

    public void setExtraFields(ZipExtraField[] fields) {
        this.unparseableExtra = null;
        ArrayList<ZipExtraField> newFields = new ArrayList<ZipExtraField>();
        if (fields != null) {
            for (ZipExtraField field : fields) {
                if (field instanceof UnparseableExtraFieldData) {
                    this.unparseableExtra = (UnparseableExtraFieldData)field;
                    continue;
                }
                newFields.add(field);
            }
        }
        this.extraFields = newFields.toArray(ExtraFieldUtils.EMPTY_ZIP_EXTRA_FIELD_ARRAY);
        this.setExtra();
    }

    private ZipExtraField[] getAllExtraFieldsNoCopy() {
        if (this.extraFields == null) {
            return this.getUnparseableOnly();
        }
        return this.unparseableExtra != null ? this.getMergedFields() : this.extraFields;
    }

    private ZipExtraField[] getMergedFields() {
        ZipExtraField[] zipExtraFields = this.copyOf(this.extraFields, this.extraFields.length + 1);
        zipExtraFields[this.extraFields.length] = this.unparseableExtra;
        return zipExtraFields;
    }

    private ZipExtraField[] getUnparseableOnly() {
        ZipExtraField[] zipExtraFieldArray;
        if (this.unparseableExtra == null) {
            zipExtraFieldArray = ExtraFieldUtils.EMPTY_ZIP_EXTRA_FIELD_ARRAY;
        } else {
            ZipExtraField[] zipExtraFieldArray2 = new ZipExtraField[1];
            zipExtraFieldArray = zipExtraFieldArray2;
            zipExtraFieldArray2[0] = this.unparseableExtra;
        }
        return zipExtraFieldArray;
    }

    public void addExtraField(ZipExtraField ze) {
        if (ze instanceof UnparseableExtraFieldData) {
            this.unparseableExtra = (UnparseableExtraFieldData)ze;
        } else if (this.extraFields == null) {
            this.extraFields = new ZipExtraField[]{ze};
        } else {
            if (this.getExtraField(ze.getHeaderId()) != null) {
                this.removeExtraField(ze.getHeaderId());
            }
            ZipExtraField[] zipExtraFields = this.copyOf(this.extraFields, this.extraFields.length + 1);
            zipExtraFields[zipExtraFields.length - 1] = ze;
            this.extraFields = zipExtraFields;
        }
        this.setExtra();
    }

    public void addAsFirstExtraField(ZipExtraField ze) {
        if (ze instanceof UnparseableExtraFieldData) {
            this.unparseableExtra = (UnparseableExtraFieldData)ze;
        } else {
            if (this.getExtraField(ze.getHeaderId()) != null) {
                this.removeExtraField(ze.getHeaderId());
            }
            ZipExtraField[] copy = this.extraFields;
            int newLen = this.extraFields != null ? this.extraFields.length + 1 : 1;
            this.extraFields = new ZipExtraField[newLen];
            this.extraFields[0] = ze;
            if (copy != null) {
                System.arraycopy(copy, 0, this.extraFields, 1, this.extraFields.length - 1);
            }
        }
        this.setExtra();
    }

    public void removeExtraField(ZipShort type) {
        if (this.extraFields == null) {
            throw new NoSuchElementException();
        }
        ArrayList<ZipExtraField> newResult = new ArrayList<ZipExtraField>();
        for (ZipExtraField extraField : this.extraFields) {
            if (type.equals(extraField.getHeaderId())) continue;
            newResult.add(extraField);
        }
        if (this.extraFields.length == newResult.size()) {
            throw new NoSuchElementException();
        }
        this.extraFields = newResult.toArray(ExtraFieldUtils.EMPTY_ZIP_EXTRA_FIELD_ARRAY);
        this.setExtra();
    }

    public ZipExtraField getExtraField(ZipShort type) {
        if (this.extraFields != null) {
            for (ZipExtraField extraField : this.extraFields) {
                if (!type.equals(extraField.getHeaderId())) continue;
                return extraField;
            }
        }
        return null;
    }

    @Override
    public void setExtra(byte[] extra) throws RuntimeException {
        try {
            this.mergeExtraFields(ExtraFieldUtils.parse(extra, true, ExtraFieldParsingMode.BEST_EFFORT), true);
        }
        catch (ZipException e) {
            throw new IllegalArgumentException("Error parsing extra fields for entry: " + this.getName() + " - " + e.getMessage(), e);
        }
    }

    protected void setExtra() {
        super.setExtra(ExtraFieldUtils.mergeLocalFileDataData(this.getAllExtraFieldsNoCopy()));
    }

    public void setCentralDirectoryExtra(byte[] b) {
        try {
            this.mergeExtraFields(ExtraFieldUtils.parse(b, false, ExtraFieldParsingMode.BEST_EFFORT), false);
        }
        catch (ZipException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public byte[] getLocalFileDataExtra() {
        byte[] extra = this.getExtra();
        return extra != null ? extra : ByteUtils.EMPTY_BYTE_ARRAY;
    }

    public byte[] getCentralDirectoryExtra() {
        return ExtraFieldUtils.mergeCentralDirectoryData(this.getAllExtraFieldsNoCopy());
    }

    @Override
    public String getName() {
        return this.name == null ? super.getName() : this.name;
    }

    @Override
    public boolean isDirectory() {
        return this.getName().endsWith("/");
    }

    protected void setName(String name) {
        if (name != null && this.getPlatform() == 0 && !name.contains("/")) {
            name = name.replace('\\', '/');
        }
        this.name = name;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public void setSize(long size) {
        if (size < 0L) {
            throw new IllegalArgumentException("Invalid entry size");
        }
        this.size = size;
    }

    protected void setName(String name, byte[] rawName) {
        this.setName(name);
        this.rawName = rawName;
    }

    protected long getLocalHeaderOffset() {
        return this.localHeaderOffset;
    }

    protected void setLocalHeaderOffset(long localHeaderOffset) {
        this.localHeaderOffset = localHeaderOffset;
    }

    public long getDataOffset() {
        return this.dataOffset;
    }

    protected void setDataOffset(long dataOffset) {
        this.dataOffset = dataOffset;
    }

    protected void setStreamContiguous(boolean isStreamContiguous) {
        this.isStreamContiguous = isStreamContiguous;
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    public GeneralPurposeBit getGeneralPurposeBit() {
        return this.gpb;
    }

    public void setGeneralPurposeBit(GeneralPurposeBit b) {
        this.gpb = b;
    }

    private void mergeExtraFields(ZipExtraField[] f, boolean local) {
        if (this.extraFields == null) {
            this.setExtraFields(f);
        } else {
            for (ZipExtraField element : f) {
                ZipExtraField existing = element instanceof UnparseableExtraFieldData ? this.unparseableExtra : this.getExtraField(element.getHeaderId());
                if (existing == null) {
                    this.addExtraField(element);
                    continue;
                }
                byte[] b = local ? element.getLocalFileDataData() : element.getCentralDirectoryData();
                try {
                    if (local) {
                        existing.parseFromLocalFileData(b, 0, b.length);
                        continue;
                    }
                    existing.parseFromCentralDirectoryData(b, 0, b.length);
                }
                catch (ZipException ex) {
                    UnrecognizedExtraField u = new UnrecognizedExtraField();
                    u.setHeaderId(existing.getHeaderId());
                    if (local) {
                        u.setLocalFileDataData(b);
                        u.setCentralDirectoryData(existing.getCentralDirectoryData());
                    } else {
                        u.setLocalFileDataData(existing.getLocalFileDataData());
                        u.setCentralDirectoryData(b);
                    }
                    this.removeExtraField(existing.getHeaderId());
                    this.addExtraField(u);
                }
            }
            this.setExtra();
        }
    }

    public boolean equals(Object obj) {
        String otherName;
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ZipArchiveEntry other = (ZipArchiveEntry)obj;
        String myName = this.getName();
        if (!Objects.equals(myName, otherName = other.getName())) {
            return false;
        }
        String myComment = this.getComment();
        String otherComment = other.getComment();
        if (myComment == null) {
            myComment = "";
        }
        if (otherComment == null) {
            otherComment = "";
        }
        return this.getTime() == other.getTime() && myComment.equals(otherComment) && this.getInternalAttributes() == other.getInternalAttributes() && this.getPlatform() == other.getPlatform() && this.getExternalAttributes() == other.getExternalAttributes() && this.getMethod() == other.getMethod() && this.getSize() == other.getSize() && this.getCrc() == other.getCrc() && this.getCompressedSize() == other.getCompressedSize() && Arrays.equals(this.getCentralDirectoryExtra(), other.getCentralDirectoryExtra()) && Arrays.equals(this.getLocalFileDataExtra(), other.getLocalFileDataExtra()) && this.localHeaderOffset == other.localHeaderOffset && this.dataOffset == other.dataOffset && this.gpb.equals(other.gpb);
    }

    public void setVersionMadeBy(int versionMadeBy) {
        this.versionMadeBy = versionMadeBy;
    }

    public void setVersionRequired(int versionRequired) {
        this.versionRequired = versionRequired;
    }

    public void setRawFlag(int rawFlag) {
        this.rawFlag = rawFlag;
    }

    public void setNameSource(NameSource nameSource) {
        this.nameSource = nameSource;
    }

    public void setCommentSource(CommentSource commentSource) {
        this.commentSource = commentSource;
    }

    public long getDiskNumberStart() {
        return this.diskNumberStart;
    }

    public void setDiskNumberStart(long diskNumberStart) {
        this.diskNumberStart = diskNumberStart;
    }

    private ZipExtraField[] copyOf(ZipExtraField[] src, int length) {
        ZipExtraField[] cpy = new ZipExtraField[length];
        System.arraycopy(src, 0, cpy, 0, Math.min(src.length, length));
        return cpy;
    }

    public static class ExtraFieldParsingMode
    extends Enum<ExtraFieldParsingMode>
    implements ExtraFieldParsingBehavior {
        public static final /* enum */ ExtraFieldParsingMode BEST_EFFORT = new ExtraFieldParsingMode(ExtraFieldUtils.UnparseableExtraField.READ){

            @Override
            public ZipExtraField fill(ZipExtraField field, byte[] data, int off, int len, boolean local) {
                return ExtraFieldParsingMode.fillAndMakeUnrecognizedOnError(field, data, off, len, local);
            }
        };
        public static final /* enum */ ExtraFieldParsingMode STRICT_FOR_KNOW_EXTRA_FIELDS = new ExtraFieldParsingMode(ExtraFieldUtils.UnparseableExtraField.READ);
        public static final /* enum */ ExtraFieldParsingMode ONLY_PARSEABLE_LENIENT = new ExtraFieldParsingMode(ExtraFieldUtils.UnparseableExtraField.SKIP){

            @Override
            public ZipExtraField fill(ZipExtraField field, byte[] data, int off, int len, boolean local) {
                return ExtraFieldParsingMode.fillAndMakeUnrecognizedOnError(field, data, off, len, local);
            }
        };
        public static final /* enum */ ExtraFieldParsingMode ONLY_PARSEABLE_STRICT = new ExtraFieldParsingMode(ExtraFieldUtils.UnparseableExtraField.SKIP);
        public static final /* enum */ ExtraFieldParsingMode DRACONIC = new ExtraFieldParsingMode(ExtraFieldUtils.UnparseableExtraField.THROW);
        private final ExtraFieldUtils.UnparseableExtraField onUnparseableData;
        private static final /* synthetic */ ExtraFieldParsingMode[] $VALUES;

        private ExtraFieldParsingMode(ExtraFieldUtils.UnparseableExtraField onUnparseableData) {
            this.onUnparseableData = onUnparseableData;
        }

        @Override
        public ZipExtraField onUnparseableExtraField(byte[] data, int off, int len, boolean local, int claimedLength) throws ZipException {
            return this.onUnparseableData.onUnparseableExtraField(data, off, len, local, claimedLength);
        }

        @Override
        public ZipExtraField createExtraField(ZipShort headerId) throws ZipException, InstantiationException, IllegalAccessException {
            return ExtraFieldUtils.createExtraField(headerId);
        }

        @Override
        public ZipExtraField fill(ZipExtraField field, byte[] data, int off, int len, boolean local) throws ZipException {
            return ExtraFieldUtils.fillExtraField(field, data, off, len, local);
        }

        private static ZipExtraField fillAndMakeUnrecognizedOnError(ZipExtraField field, byte[] data, int off, int len, boolean local) {
            try {
                return ExtraFieldUtils.fillExtraField(field, data, off, len, local);
            }
            catch (ZipException ex) {
                UnrecognizedExtraField u = new UnrecognizedExtraField();
                u.setHeaderId(field.getHeaderId());
                if (local) {
                    u.setLocalFileDataData(Arrays.copyOfRange(data, off, off + len));
                } else {
                    u.setCentralDirectoryData(Arrays.copyOfRange(data, off, off + len));
                }
                return u;
            }
        }

        static {
            $VALUES = new ExtraFieldParsingMode[]{BEST_EFFORT, STRICT_FOR_KNOW_EXTRA_FIELDS, ONLY_PARSEABLE_LENIENT, ONLY_PARSEABLE_STRICT, DRACONIC};
        }
    }

    public static final class CommentSource
    extends Enum<CommentSource> {
        public static final /* enum */ CommentSource COMMENT = new CommentSource();
        public static final /* enum */ CommentSource UNICODE_EXTRA_FIELD = new CommentSource();
        private static final /* synthetic */ CommentSource[] $VALUES;

        static {
            $VALUES = new CommentSource[]{COMMENT, UNICODE_EXTRA_FIELD};
        }
    }

    public static final class NameSource
    extends Enum<NameSource> {
        public static final /* enum */ NameSource NAME = new NameSource();
        public static final /* enum */ NameSource NAME_WITH_EFS_FLAG = new NameSource();
        public static final /* enum */ NameSource UNICODE_EXTRA_FIELD = new NameSource();
        private static final /* synthetic */ NameSource[] $VALUES;

        static {
            $VALUES = new NameSource[]{NAME, NAME_WITH_EFS_FLAG, UNICODE_EXTRA_FIELD};
        }
    }
}

