/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.scala.collection.mutable;

import coursierapi.shaded.scala.Array$;
import coursierapi.shaded.scala.Function1;
import coursierapi.shaded.scala.Function2;
import coursierapi.shaded.scala.Option;
import coursierapi.shaded.scala.PartialFunction;
import coursierapi.shaded.scala.Tuple2;
import coursierapi.shaded.scala.collection.IndexedSeqOps;
import coursierapi.shaded.scala.collection.Iterable;
import coursierapi.shaded.scala.collection.IterableOnce;
import coursierapi.shaded.scala.collection.Iterator;
import coursierapi.shaded.scala.collection.SeqFactory;
import coursierapi.shaded.scala.collection.StrictOptimizedIterableOps;
import coursierapi.shaded.scala.collection.StrictOptimizedSeqOps;
import coursierapi.shaded.scala.collection.generic.DefaultSerializable;
import coursierapi.shaded.scala.collection.mutable.AbstractBuffer;
import coursierapi.shaded.scala.collection.mutable.ArrayBuffer$;
import coursierapi.shaded.scala.collection.mutable.ArrayBufferView;
import coursierapi.shaded.scala.collection.mutable.Growable;
import coursierapi.shaded.scala.collection.mutable.IndexedBuffer;
import java.lang.reflect.Array;
import java.util.Arrays;

public class ArrayBuffer<A>
extends AbstractBuffer<A>
implements StrictOptimizedSeqOps<A, ArrayBuffer, ArrayBuffer<A>>,
DefaultSerializable,
IndexedBuffer<A> {
    private transient int mutationCount;
    private Object[] array;
    private int size0;

    @Override
    public Object distinctBy(Function1 f) {
        return StrictOptimizedSeqOps.distinctBy$(this, f);
    }

    @Override
    public Object prepended(Object elem) {
        return StrictOptimizedSeqOps.prepended$(this, elem);
    }

    @Override
    public Object appended(Object elem) {
        return StrictOptimizedSeqOps.appended$(this, elem);
    }

    @Override
    public Object appendedAll(IterableOnce suffix) {
        return StrictOptimizedSeqOps.appendedAll$(this, suffix);
    }

    @Override
    public Tuple2<ArrayBuffer<A>, ArrayBuffer<A>> partition(Function1<A, Object> p) {
        return StrictOptimizedIterableOps.partition$(this, p);
    }

    @Override
    public <A1, A2> Tuple2<ArrayBuffer<A1>, ArrayBuffer<A2>> unzip(Function1<A, Tuple2<A1, A2>> asPair) {
        return StrictOptimizedIterableOps.unzip$(this, asPair);
    }

    @Override
    public Object map(Function1 f) {
        return StrictOptimizedIterableOps.map$(this, f);
    }

    @Override
    public Object flatMap(Function1 f) {
        return StrictOptimizedIterableOps.flatMap$(this, f);
    }

    @Override
    public Object collect(PartialFunction pf) {
        return StrictOptimizedIterableOps.collect$(this, pf);
    }

    @Override
    public Object flatten(Function1 toIterableOnce) {
        return StrictOptimizedIterableOps.flatten$(this, toIterableOnce);
    }

    @Override
    public Object zip(IterableOnce that) {
        return StrictOptimizedIterableOps.zip$(this, that);
    }

    @Override
    public Object zipWithIndex() {
        return StrictOptimizedIterableOps.zipWithIndex$(this);
    }

    @Override
    public Object filter(Function1 pred) {
        return StrictOptimizedIterableOps.filter$(this, pred);
    }

    @Override
    public Object filterNot(Function1 pred) {
        return StrictOptimizedIterableOps.filterNot$(this, pred);
    }

    @Override
    public Object filterImpl(Function1 pred, boolean isFlipped) {
        return StrictOptimizedIterableOps.filterImpl$(this, pred, isFlipped);
    }

    @Override
    public Object dropRight(int n) {
        return StrictOptimizedIterableOps.dropRight$(this, n);
    }

    @Override
    public Iterator<A> iterator() {
        return IndexedSeqOps.iterator$(this);
    }

    @Override
    public Iterator<A> reverseIterator() {
        return IndexedSeqOps.reverseIterator$(this);
    }

    @Override
    public Iterable<A> reversed() {
        return IndexedSeqOps.reversed$(this);
    }

    @Override
    public Object take(int n) {
        return IndexedSeqOps.take$(this, n);
    }

    @Override
    public Object drop(int n) {
        return IndexedSeqOps.drop$(this, n);
    }

    @Override
    public Object reverse() {
        return IndexedSeqOps.reverse$(this);
    }

    @Override
    public Object slice(int from, int until) {
        return IndexedSeqOps.slice$(this, from, until);
    }

    @Override
    public A head() {
        return (A)IndexedSeqOps.head$(this);
    }

    @Override
    public Option<A> headOption() {
        return IndexedSeqOps.headOption$(this);
    }

    @Override
    public A last() {
        return (A)IndexedSeqOps.last$(this);
    }

    @Override
    public final int lengthCompare(int len) {
        return IndexedSeqOps.lengthCompare$(this, len);
    }

    public Object[] array() {
        return this.array;
    }

    public void array_$eq(Object[] x$1) {
        this.array = x$1;
    }

    public int size0() {
        return this.size0;
    }

    public void size0_$eq(int x$1) {
        this.size0 = x$1;
    }

    @Override
    public int knownSize() {
        return IndexedSeqOps.knownSize$(this);
    }

    public void ensureSize(int n) {
        this.array_$eq(ArrayBuffer$.MODULE$.scala$collection$mutable$ArrayBuffer$$ensureSize(this.array(), this.size0(), n));
    }

    public void ensureAdditionalSize(int n) {
        this.array_$eq(ArrayBuffer$.MODULE$.scala$collection$mutable$ArrayBuffer$$ensureSize(this.array(), this.size0(), (long)this.size0() + (long)n));
    }

    private void reduceToSize(int n) {
        ++this.mutationCount;
        Arrays.fill(this.array(), n, this.size0(), null);
        this.size0_$eq(n);
    }

    @Override
    public A apply(int n) {
        int checkWithinBounds_hi = n + 1;
        if (n < 0) {
            throw new IndexOutOfBoundsException(new StringBuilder(31).append(n).append(" is out of bounds (min 0, max ").append(this.size0() - 1).append(")").toString());
        }
        if (checkWithinBounds_hi > this.size0()) {
            throw new IndexOutOfBoundsException(new StringBuilder(31).append(checkWithinBounds_hi - 1).append(" is out of bounds (min 0, max ").append(this.size0() - 1).append(")").toString());
        }
        return (A)this.array()[n];
    }

    @Override
    public void update(int index, A elem) {
        int checkWithinBounds_hi = index + 1;
        if (index < 0) {
            throw new IndexOutOfBoundsException(new StringBuilder(31).append(index).append(" is out of bounds (min 0, max ").append(this.size0() - 1).append(")").toString());
        }
        if (checkWithinBounds_hi > this.size0()) {
            throw new IndexOutOfBoundsException(new StringBuilder(31).append(checkWithinBounds_hi - 1).append(" is out of bounds (min 0, max ").append(this.size0() - 1).append(")").toString());
        }
        ++this.mutationCount;
        this.array()[index] = elem;
    }

    @Override
    public int length() {
        return this.size0();
    }

    @Override
    public ArrayBufferView<A> view() {
        return new ArrayBufferView(this, () -> $this.mutationCount);
    }

    @Override
    public SeqFactory<ArrayBuffer> iterableFactory() {
        return ArrayBuffer$.MODULE$;
    }

    @Override
    public void clear() {
        this.reduceToSize(0);
    }

    @Override
    public ArrayBuffer<A> addOne(A elem) {
        ++this.mutationCount;
        this.ensureAdditionalSize(1);
        int oldSize = this.size0();
        this.size0_$eq(oldSize + 1);
        this.update(oldSize, elem);
        return this;
    }

    @Override
    public ArrayBuffer<A> addAll(IterableOnce<A> elems) {
        if (elems instanceof ArrayBuffer) {
            ArrayBuffer arrayBuffer = (ArrayBuffer)elems;
            int elemsLength = arrayBuffer.size0();
            if (elemsLength > 0) {
                ++this.mutationCount;
                this.ensureAdditionalSize(elemsLength);
                Array$.MODULE$.copy(arrayBuffer.array(), 0, this.array(), this.length(), elemsLength);
                this.size0_$eq(this.length() + elemsLength);
            }
        } else {
            Growable.addAll$(this, elems);
        }
        return this;
    }

    @Override
    public A remove(int index) {
        int checkWithinBounds_hi = index + 1;
        if (index < 0) {
            throw new IndexOutOfBoundsException(new StringBuilder(31).append(index).append(" is out of bounds (min 0, max ").append(this.size0() - 1).append(")").toString());
        }
        if (checkWithinBounds_hi > this.size0()) {
            throw new IndexOutOfBoundsException(new StringBuilder(31).append(checkWithinBounds_hi - 1).append(" is out of bounds (min 0, max ").append(this.size0() - 1).append(")").toString());
        }
        A res = this.apply(index);
        Array$.MODULE$.copy(this.array(), index + 1, this.array(), index, this.size0() - (index + 1));
        this.reduceToSize(this.size0() - 1);
        return res;
    }

    @Override
    public String stringPrefix() {
        return "ArrayBuffer";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <B> int copyToArray(Object xs, int start, int len) {
        void elemsToCopyToArray_destLen;
        int n = Array.getLength(xs);
        int elemsToCopyToArray_srcLen = this.length();
        int copied = Math.max(Math.min(Math.min(len, elemsToCopyToArray_srcLen), (int)(elemsToCopyToArray_destLen - start)), 0);
        if (copied > 0) {
            Array$.MODULE$.copy(this.array(), 0, xs, start, copied);
        }
        return copied;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <B> B foldLeft(B z, Function2<B, A, B> op) {
        B b = z;
        int n = this.length();
        int foldl_start = 0;
        B foldl_z;
        void foldl_end;
        while (foldl_start != foldl_end) {
            foldl_z = op.apply(foldl_z, this.array()[foldl_start]);
            ++foldl_start;
        }
        return foldl_z;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <B> B foldRight(B z, Function2<A, B, B> op) {
        B b = z;
        int n = this.length();
        boolean foldr_start = false;
        B foldr_z;
        void foldr_end;
        while (foldr_start != foldr_end) {
            foldr_z = op.apply(this.array()[foldr_end - true], foldr_z);
            --foldr_end;
        }
        return foldr_z;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <B> B reduceLeft(Function2<B, A, B> op) {
        if (this.length() > 0) {
            Object object = this.array()[0];
            int foldl_end = this.length();
            int foldl_start = 1;
            while (true) {
                B foldl_z;
                if (foldl_start == foldl_end) {
                    return foldl_z;
                }
                foldl_z = op.apply(foldl_z, this.array()[foldl_start]);
                ++foldl_start;
            }
        }
        if (this.length() > 0) {
            Object reduceLeft_foldl_z;
            Object a = reduceLeft_foldl_z = this.apply(0);
            int n = this.length();
            int reduceLeft_foldl_loop$1_at = 1;
            while (true) {
                B reduceLeft_foldl_loop$1_acc;
                void reduceLeft_foldl_loop$1_end;
                if (reduceLeft_foldl_loop$1_at == reduceLeft_foldl_loop$1_end) {
                    return reduceLeft_foldl_loop$1_acc;
                }
                reduceLeft_foldl_loop$1_acc = op.apply(reduceLeft_foldl_loop$1_acc, this.apply(reduceLeft_foldl_loop$1_at));
                ++reduceLeft_foldl_loop$1_at;
            }
        }
        Iterator reduceLeft_it = this.iterator();
        if (reduceLeft_it.isEmpty()) {
            throw new UnsupportedOperationException("empty.reduceLeft");
        }
        boolean reduceLeft_first = true;
        Object reduceLeft_acc = null;
        while (reduceLeft_it.hasNext()) {
            Object reduceLeft_x = reduceLeft_it.next();
            if (reduceLeft_first) {
                reduceLeft_acc = reduceLeft_x;
                reduceLeft_first = false;
                continue;
            }
            reduceLeft_acc = op.apply(reduceLeft_acc, reduceLeft_x);
        }
        return (B)reduceLeft_acc;
    }

    public ArrayBuffer(Object[] initialElements, int initialSize) {
        this.mutationCount = 0;
        this.array = initialElements;
        this.size0 = initialSize;
    }

    public ArrayBuffer() {
        this(new Object[16], 0);
    }

    public ArrayBuffer(int initialSize) {
        int max$extension_that = 1;
        this(new Object[Math.max(initialSize, max$extension_that)], 0);
    }
}

