/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.sources;

import io.github.ascopes.protobufmavenplugin.utils.FileUtils;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class ProtoFileFilter {
    private final List<PathMatcher> includes;
    private final List<PathMatcher> excludes;

    public ProtoFileFilter() {
        this(List.of(), List.of());
    }

    public ProtoFileFilter(List<String> includes, List<String> excludes) {
        this.includes = ProtoFileFilter.compileMatchers(includes);
        this.excludes = ProtoFileFilter.compileMatchers(excludes);
    }

    public boolean matches(Path relativeRoot, Path file) {
        boolean notIncluded;
        Path relativeFile = relativeRoot.relativize(file);
        boolean excluded = this.excludes.isEmpty() ? false : this.excludes.stream().anyMatch(ProtoFileFilter.checking(relativeFile));
        boolean bl = notIncluded = this.includes.isEmpty() ? false : this.includes.stream().noneMatch(ProtoFileFilter.checking(relativeFile));
        if (excluded || notIncluded) {
            return false;
        }
        return Files.isRegularFile(file, new LinkOption[0]) && FileUtils.getFileExtension(file).filter(".proto"::equalsIgnoreCase).isPresent();
    }

    public String toString() {
        return "ProtoFileFilter{isProtoFile=true, includes=" + String.valueOf(this.includes) + ", excludes=" + String.valueOf(this.excludes) + "}";
    }

    private static List<PathMatcher> compileMatchers(List<String> patterns) {
        return patterns.stream().map("glob:"::concat).map(FileSystems.getDefault()::getPathMatcher).collect(Collectors.toUnmodifiableList());
    }

    private static Predicate<PathMatcher> checking(Path path) {
        return matcher -> matcher.matches(path);
    }
}

