/*
 * Copyright (C) 2023 - 2025, Ashley Scopes.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.github.ascopes.protobufmavenplugin.plugins;

import io.github.ascopes.protobufmavenplugin.digests.Digest;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import org.jspecify.annotations.Nullable;

/**
 * A modifiable implementation of the {@link UriProtocPlugin UriProtocPlugin} type.
 * <p>Use the constructor to create new modifiable instances. You may even extend this class to
 * add some convenience methods, however most of the methods in this class are final
 * to preserve safety and predictable invariants.
 * <p><em>UriProtocPluginBean is not thread-safe</em>
 */
@Generated(from = "UriProtocPlugin", generator = "Modifiables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated({"Modifiables.generator", "UriProtocPlugin"})
public class UriProtocPluginBean
    implements UriProtocPlugin {
  private static final long INIT_BIT_URL = 0x1L;
  private static final long OPT_BIT_ORDER = 0x1L;
  private static final long OPT_BIT_SKIP = 0x2L;
  private static final long OPT_BIT_OPTIONAL = 0x4L;
  private long initBits = 0x1L;
  private long optBits;

  private @Nullable String options;
  private @Nullable Path outputDirectory;
  private @Nullable Boolean registerAsCompilationRoot;
  private int order;
  private boolean skip;
  private boolean optional;
  private URI url;
  private @Nullable Digest digest;

  /**
   * @return value of {@code options} attribute, may be {@code null}
   */
  @Override
  public @Nullable String getOptions() {
    return options;
  }

  /**
   * @return value of {@code outputDirectory} attribute, may be {@code null}
   */
  @Override
  public @Nullable Path getOutputDirectory() {
    return outputDirectory;
  }

  /**
   * @return value of {@code registerAsCompilationRoot} attribute, may be {@code null}
   */
  @Override
  public @Nullable Boolean isRegisterAsCompilationRoot() {
    return registerAsCompilationRoot;
  }

  /**
   * @return assigned or, otherwise, newly computed, not cached value of {@code order} attribute
   */
  @Override
  public int getOrder() {
    if (orderIsSet()) {
      return order;
    } else {
      return UriProtocPlugin.super.getOrder();
    }
  }

  /**
   * @return assigned or, otherwise, newly computed, not cached value of {@code skip} attribute
   */
  @Override
  public boolean isSkip() {
    if (skipIsSet()) {
      return skip;
    } else {
      return UriProtocPlugin.super.isSkip();
    }
  }

  /**
   * @return assigned or, otherwise, newly computed, not cached value of {@code optional} attribute
   */
  @Override
  public boolean isOptional() {
    if (optionalIsSet()) {
      return optional;
    } else {
      return UriProtocPlugin.super.isOptional();
    }
  }

  /**
   * @return value of {@code url} attribute, may be {@code null}
   */
  @Override
  public URI getUrl() {
    if (!urlIsSet()) checkRequiredAttributes();
    return url;
  }

  /**
   * @return value of {@code digest} attribute, may be {@code null}
   */
  @Override
  public @Nullable Digest getDigest() {
    return digest;
  }

  /**
   * Clears the object by setting all attributes to their initial values.
   */
  public void clear() {
    initBits = 0x1L;
    optBits = 0;
    options = null;
    outputDirectory = null;
    registerAsCompilationRoot = null;
    order = 0;
    skip = false;
    optional = false;
    url = null;
    digest = null;
    return;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link io.github.ascopes.protobufmavenplugin.plugins.ProtocPlugin} instance.
   * @param instance The instance from which to copy values
   */
  public UriProtocPluginBean from(ProtocPlugin instance) {
    Objects.requireNonNull(instance, "instance");
    from((Object) instance);
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link io.github.ascopes.protobufmavenplugin.plugins.OptionalProtocPlugin} instance.
   * @param instance The instance from which to copy values
   */
  public UriProtocPluginBean from(OptionalProtocPlugin instance) {
    Objects.requireNonNull(instance, "instance");
    from((Object) instance);
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link io.github.ascopes.protobufmavenplugin.plugins.UriProtocPlugin} instance.
   * @param instance The instance from which to copy values
   */
  public UriProtocPluginBean from(UriProtocPlugin instance) {
    Objects.requireNonNull(instance, "instance");
    from((Object) instance);
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link UriProtocPlugin} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public UriProtocPluginBean from(UriProtocPluginBean instance) {
    Objects.requireNonNull(instance, "instance");
    from((Object) instance);
    return this;
  }

  private void from(Object object) {
    if (object instanceof UriProtocPluginBean) {
      UriProtocPluginBean instance = (UriProtocPluginBean) object;
      @Nullable String optionsValue = instance.getOptions();
      if (optionsValue != null) {
        setOptions(optionsValue);
      }
      @Nullable Path outputDirectoryValue = instance.getOutputDirectory();
      if (outputDirectoryValue != null) {
        setOutputDirectory(outputDirectoryValue);
      }
      @Nullable Boolean registerAsCompilationRootValue = instance.isRegisterAsCompilationRoot();
      if (registerAsCompilationRootValue != null) {
        setRegisterAsCompilationRoot(registerAsCompilationRootValue);
      }
      setOrder(instance.getOrder());
      setSkip(instance.isSkip());
      setOptional(instance.isOptional());
      if (instance.urlIsSet()) {
        URI urlValue = instance.getUrl();
        if (urlValue != null) {
          setUrl(urlValue);
        }
      }
      @Nullable Digest digestValue = instance.getDigest();
      if (digestValue != null) {
        setDigest(digestValue);
      }
      return;
    }
    long bits = 0;
    if (object instanceof ProtocPlugin) {
      ProtocPlugin instance = (ProtocPlugin) object;
      if ((bits & 0x8L) == 0) {
        @Nullable String optionsValue = instance.getOptions();
        if (optionsValue != null) {
          setOptions(optionsValue);
        }
        bits |= 0x8L;
      }
      if ((bits & 0x2L) == 0) {
        setSkip(instance.isSkip());
        bits |= 0x2L;
      }
      if ((bits & 0x10L) == 0) {
        @Nullable Path outputDirectoryValue = instance.getOutputDirectory();
        if (outputDirectoryValue != null) {
          setOutputDirectory(outputDirectoryValue);
        }
        bits |= 0x10L;
      }
      if ((bits & 0x1L) == 0) {
        @Nullable Boolean registerAsCompilationRootValue = instance.isRegisterAsCompilationRoot();
        if (registerAsCompilationRootValue != null) {
          setRegisterAsCompilationRoot(registerAsCompilationRootValue);
        }
        bits |= 0x1L;
      }
      if ((bits & 0x20L) == 0) {
        setOrder(instance.getOrder());
        bits |= 0x20L;
      }
    }
    if (object instanceof OptionalProtocPlugin) {
      OptionalProtocPlugin instance = (OptionalProtocPlugin) object;
      if ((bits & 0x8L) == 0) {
        @Nullable String optionsValue = instance.getOptions();
        if (optionsValue != null) {
          setOptions(optionsValue);
        }
        bits |= 0x8L;
      }
      if ((bits & 0x2L) == 0) {
        setSkip(instance.isSkip());
        bits |= 0x2L;
      }
      if ((bits & 0x4L) == 0) {
        setOptional(instance.isOptional());
        bits |= 0x4L;
      }
      if ((bits & 0x10L) == 0) {
        @Nullable Path outputDirectoryValue = instance.getOutputDirectory();
        if (outputDirectoryValue != null) {
          setOutputDirectory(outputDirectoryValue);
        }
        bits |= 0x10L;
      }
      if ((bits & 0x1L) == 0) {
        @Nullable Boolean registerAsCompilationRootValue = instance.isRegisterAsCompilationRoot();
        if (registerAsCompilationRootValue != null) {
          setRegisterAsCompilationRoot(registerAsCompilationRootValue);
        }
        bits |= 0x1L;
      }
      if ((bits & 0x20L) == 0) {
        setOrder(instance.getOrder());
        bits |= 0x20L;
      }
    }
    if (object instanceof UriProtocPlugin) {
      UriProtocPlugin instance = (UriProtocPlugin) object;
      if ((bits & 0x1L) == 0) {
        @Nullable Boolean registerAsCompilationRootValue = instance.isRegisterAsCompilationRoot();
        if (registerAsCompilationRootValue != null) {
          setRegisterAsCompilationRoot(registerAsCompilationRootValue);
        }
        bits |= 0x1L;
      }
      if ((bits & 0x8L) == 0) {
        @Nullable String optionsValue = instance.getOptions();
        if (optionsValue != null) {
          setOptions(optionsValue);
        }
        bits |= 0x8L;
      }
      @Nullable Digest digestValue = instance.getDigest();
      if (digestValue != null) {
        setDigest(digestValue);
      }
      if ((bits & 0x2L) == 0) {
        setSkip(instance.isSkip());
        bits |= 0x2L;
      }
      if ((bits & 0x4L) == 0) {
        setOptional(instance.isOptional());
        bits |= 0x4L;
      }
      if ((bits & 0x10L) == 0) {
        @Nullable Path outputDirectoryValue = instance.getOutputDirectory();
        if (outputDirectoryValue != null) {
          setOutputDirectory(outputDirectoryValue);
        }
        bits |= 0x10L;
      }
      URI urlValue = instance.getUrl();
      if (urlValue != null) {
        setUrl(urlValue);
      }
      if ((bits & 0x20L) == 0) {
        setOrder(instance.getOrder());
        bits |= 0x20L;
      }
    }
  }

  /**
   * Assigns a value to the {@code options} attribute.
   * @param options The value for options, can be {@code null}
   */
  public void setOptions(@Nullable String options) {
    this.options = options;
    return;
  }

  /**
   * Assigns a value to the {@code outputDirectory} attribute.
   * @param outputDirectory The value for outputDirectory, can be {@code null}
   */
  public void setOutputDirectory(@Nullable Path outputDirectory) {
    this.outputDirectory = outputDirectory;
    return;
  }

  /**
   * Assigns a value to the {@code registerAsCompilationRoot} attribute.
   * @param registerAsCompilationRoot The value for registerAsCompilationRoot, can be {@code null}
   */
  public void setRegisterAsCompilationRoot(@Nullable Boolean registerAsCompilationRoot) {
    this.registerAsCompilationRoot = registerAsCompilationRoot;
    return;
  }

  /**
   * Assigns a value to the {@code order} attribute.
   * <p><em>If not set, this attribute will have a default value returned by the initializer of {@code order}.</em>
   * @param order The value for order
   */
  public void setOrder(int order) {
    this.order = order;
    optBits |= OPT_BIT_ORDER;
    return;
  }

  /**
   * Assigns a value to the {@code skip} attribute.
   * <p><em>If not set, this attribute will have a default value returned by the initializer of {@code skip}.</em>
   * @param skip The value for skip
   */
  public void setSkip(boolean skip) {
    this.skip = skip;
    optBits |= OPT_BIT_SKIP;
    return;
  }

  /**
   * Assigns a value to the {@code optional} attribute.
   * <p><em>If not set, this attribute will have a default value returned by the initializer of {@code optional}.</em>
   * @param optional The value for optional
   */
  public void setOptional(boolean optional) {
    this.optional = optional;
    optBits |= OPT_BIT_OPTIONAL;
    return;
  }

  /**
   * Assigns a value to the {@code url} attribute.
   * @param url The value for url, can be {@code null}
   */
  public void setUrl(URI url) {
    this.url = url;
    initBits &= ~INIT_BIT_URL;
    return;
  }

  /**
   * Assigns a value to the {@code digest} attribute.
   * @param digest The value for digest, can be {@code null}
   */
  public void setDigest(@Nullable Digest digest) {
    this.digest = digest;
    return;
  }

  /**
   * Returns {@code true} if the required attribute {@code url} is set.
   * @return {@code true} if set
   */
  public final boolean urlIsSet() {
    return (initBits & INIT_BIT_URL) == 0;
  }

  /**
   * Returns {@code true} if the default attribute {@code order} is set.
   * @return {@code true} if set
   */
  public final boolean orderIsSet() {
    return (optBits & OPT_BIT_ORDER) != 0;
  }

  /**
   * Returns {@code true} if the default attribute {@code skip} is set.
   * @return {@code true} if set
   */
  public final boolean skipIsSet() {
    return (optBits & OPT_BIT_SKIP) != 0;
  }

  /**
   * Returns {@code true} if the default attribute {@code optional} is set.
   * @return {@code true} if set
   */
  public final boolean optionalIsSet() {
    return (optBits & OPT_BIT_OPTIONAL) != 0;
  }


  /**
   * Reset an attribute to its initial value.
   */
  public final void unsetUrl() {
    initBits |= INIT_BIT_URL;
    url = null;
    return;
  }
  /**
   * Reset an attribute to its initial value.
   */
  public final void unsetOrder() {
    optBits |= 0;
    order = 0;
    return;
  }
  /**
   * Reset an attribute to its initial value.
   */
  public final void unsetSkip() {
    optBits |= 0;
    skip = false;
    return;
  }
  /**
   * Reset an attribute to its initial value.
   */
  public final void unsetOptional() {
    optBits |= 0;
    optional = false;
    return;
  }

  /**
   * Returns {@code true} if all required attributes are set, indicating that the object is initialized.
   * @return {@code true} if set
   */
  public final boolean isInitialized() {
    return initBits == 0;
  }

  private void checkRequiredAttributes() {
    if (!isInitialized()) {
      throw new IllegalStateException(formatRequiredAttributesMessage());
    }
  }

  private String formatRequiredAttributesMessage() {
    List<String> attributes = new ArrayList<>();
    if (!urlIsSet()) attributes.add("url");
    return "UriProtocPlugin is not initialized, some of the required attributes are not set " + attributes;
  }

  /**
   * This instance is equal to all instances of {@code UriProtocPluginBean} that have equal attribute values.
   * An uninitialized instance is equal only to itself.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    if (!(another instanceof UriProtocPluginBean)) return false;
    UriProtocPluginBean other = (UriProtocPluginBean) another;
    if (!isInitialized() || !other.isInitialized()) {
      return false;
    }
    return equalTo(other);
  }

  private boolean equalTo(UriProtocPluginBean another) {
    int order = getOrder();
    boolean skip = isSkip();
    boolean optional = isOptional();
    return Objects.equals(options, another.options)
        && Objects.equals(outputDirectory, another.outputDirectory)
        && Objects.equals(registerAsCompilationRoot, another.registerAsCompilationRoot)
        && order == another.getOrder()
        && skip == another.isSkip()
        && optional == another.isOptional()
        && Objects.equals(url, another.url)
        && Objects.equals(digest, another.digest);
  }

  /**
   * Computes a hash code from attributes: {@code options}, {@code outputDirectory}, {@code registerAsCompilationRoot}, {@code order}, {@code skip}, {@code optional}, {@code url}, {@code digest}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(options);
    h += (h << 5) + Objects.hashCode(outputDirectory);
    h += (h << 5) + Objects.hashCode(registerAsCompilationRoot);
    int order = getOrder();
    h += (h << 5) + order;
    boolean skip = isSkip();
    h += (h << 5) + Boolean.hashCode(skip);
    boolean optional = isOptional();
    h += (h << 5) + Boolean.hashCode(optional);
    h += (h << 5) + Objects.hashCode(url);
    h += (h << 5) + Objects.hashCode(digest);
    return h;
  }

  /**
   * Generates a string representation of this {@code UriProtocPlugin}.
   * If uninitialized, some attribute values may appear as question marks.
   * @return A string representation
   */
  @Override
  public String toString() {
    return "UriProtocPluginBean{"
        + "options=" + getOptions()
        + ", outputDirectory=" + getOutputDirectory()
        + ", registerAsCompilationRoot=" + isRegisterAsCompilationRoot()
        + ", order=" + getOrder()
        + ", skip=" + isSkip()
        + ", optional=" + isOptional()
        + ", url=" + getUrl()
        + ", digest=" + getDigest()
        + "}";
  }
}
