/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.urls;

import io.github.ascopes.protobufmavenplugin.urls.AbstractNestingUrlConnection;
import io.github.ascopes.protobufmavenplugin.urls.AbstractUrlStreamHandlerFactory;
import io.github.ascopes.protobufmavenplugin.urls.InputStreamDecorator;
import io.github.ascopes.protobufmavenplugin.urls.UrlFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;

final class ApacheArchiveUrlStreamHandlerFactory
extends AbstractUrlStreamHandlerFactory {
    private final UrlFactory urlFactory;
    private final InputStreamDecorator<ArchiveInputStream<?>> decorator;

    ApacheArchiveUrlStreamHandlerFactory(UrlFactory urlFactory, InputStreamDecorator<ArchiveInputStream<?>> decorator, String protocol, String ... protocols) {
        super(protocol, protocols);
        this.urlFactory = urlFactory;
        this.decorator = decorator;
    }

    @Override
    URLConnection createUrlConnection(URL url) throws IOException {
        String rawInnerUri = url.getFile();
        int pathIndex = rawInnerUri.lastIndexOf("!/");
        if (pathIndex == -1) {
            throw new IOException("URI '" + String.valueOf(url) + "' was missing a nested path fragment (e.g. '" + url.getProtocol() + ":http://some-website.com/some-file!/path/within/archive')");
        }
        final String file = rawInnerUri.substring(pathIndex + 2);
        rawInnerUri = rawInnerUri.substring(0, pathIndex);
        URL innerUrl = this.urlFactory.create(URI.create(rawInnerUri));
        return new AbstractNestingUrlConnection(this, url, innerUrl){
            final /* synthetic */ ApacheArchiveUrlStreamHandlerFactory this$0;
            {
                this.this$0 = this$0;
                super(url, nestedUrl);
            }

            @Override
            InputStream nestInputStream(InputStream inputStream) throws IOException {
                return this.this$0.readFileFromArchive(inputStream, file);
            }
        };
    }

    private InputStream readFileFromArchive(InputStream inputStream, String file) throws IOException {
        file = ApacheArchiveUrlStreamHandlerFactory.normalizeEntryName(file);
        try (InputStream inputStream2 = inputStream;){
            ByteArrayInputStream byteArrayInputStream;
            block14: {
                ArchiveInputStream<?> archiveInputStream = this.decorator.decorate(inputStream);
                try {
                    String name;
                    ArchiveEntry entry;
                    while ((entry = archiveInputStream.getNextEntry()) != null && !file.equals(name = ApacheArchiveUrlStreamHandlerFactory.normalizeEntryName(entry.getName()))) {
                    }
                    if (entry == null) {
                        throw new FileNotFoundException("Could not find '" + file + "' within " + archiveInputStream.getClass().getSimpleName());
                    }
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    archiveInputStream.transferTo((OutputStream)baos);
                    byteArrayInputStream = new ByteArrayInputStream(baos.toByteArray());
                    if (archiveInputStream == null) break block14;
                }
                catch (Throwable throwable) {
                    if (archiveInputStream != null) {
                        try {
                            archiveInputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                archiveInputStream.close();
            }
            return byteArrayInputStream;
        }
    }

    private static String normalizeEntryName(String name) {
        if (name.startsWith("./")) {
            name = name.substring(2);
        }
        return name;
    }
}

