/*
 * Copyright (C) 2023 Ashley Scopes
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.github.ascopes.protobufmavenplugin.protoc;

import io.github.ascopes.protobufmavenplugin.protoc.targets.ProtocTarget;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedSet;
import org.immutables.value.Generated;
import org.jspecify.annotations.Nullable;

/**
 * Immutable implementation of {@link ProtocInvocation}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableProtocInvocation.builder()}.
 */
@Generated(from = "ProtocInvocation", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableProtocInvocation
    implements ProtocInvocation {
  private final @Nullable Path protocPath;
  private final boolean fatalWarnings;
  private final List<String> arguments;
  private final Map<String, String> environmentVariables;
  private final List<Path> importPaths;
  private final List<Path> inputDescriptorFiles;
  private final List<String> descriptorSourceFiles;
  private final List<Path> sourcePaths;
  private final @Nullable SortedSet<ProtocTarget> targets;
  private final @Nullable Path sanctionedExecutablePath;

  private ImmutableProtocInvocation(ImmutableProtocInvocation.Builder builder) {
    this.protocPath = builder.protocPath;
    this.fatalWarnings = builder.fatalWarnings;
    this.arguments = builder.arguments == null ? Collections.<String>emptyList() : createUnmodifiableList(true, builder.arguments);
    this.environmentVariables = builder.environmentVariables == null ? Collections.<String, String>emptyMap() : createUnmodifiableMap(false, false, builder.environmentVariables);
    this.importPaths = builder.importPaths == null ? Collections.<Path>emptyList() : createUnmodifiableList(true, builder.importPaths);
    this.inputDescriptorFiles = builder.inputDescriptorFiles == null ? Collections.<Path>emptyList() : createUnmodifiableList(true, builder.inputDescriptorFiles);
    this.descriptorSourceFiles = builder.descriptorSourceFiles == null ? Collections.<String>emptyList() : createUnmodifiableList(true, builder.descriptorSourceFiles);
    this.sourcePaths = builder.sourcePaths == null ? Collections.<Path>emptyList() : createUnmodifiableList(true, builder.sourcePaths);
    this.targets = builder.targets;
    this.sanctionedExecutablePath = builder.sanctionedExecutablePath;
  }

  /**
   * @return The value of the {@code protocPath} attribute
   */
  @Override
  public @Nullable Path getProtocPath() {
    return protocPath;
  }

  /**
   * @return The value of the {@code fatalWarnings} attribute
   */
  @Override
  public boolean isFatalWarnings() {
    return fatalWarnings;
  }

  /**
   * @return The value of the {@code arguments} attribute
   */
  @Override
  public List<String> getArguments() {
    return arguments;
  }

  /**
   * @return The value of the {@code environmentVariables} attribute
   */
  @Override
  public Map<String, String> getEnvironmentVariables() {
    return environmentVariables;
  }

  /**
   * @return The value of the {@code importPaths} attribute
   */
  @Override
  public List<Path> getImportPaths() {
    return importPaths;
  }

  /**
   * @return The value of the {@code inputDescriptorFiles} attribute
   */
  @Override
  public List<Path> getInputDescriptorFiles() {
    return inputDescriptorFiles;
  }

  /**
   * @return The value of the {@code descriptorSourceFiles} attribute
   */
  @Override
  public List<String> getDescriptorSourceFiles() {
    return descriptorSourceFiles;
  }

  /**
   * @return The value of the {@code sourcePaths} attribute
   */
  @Override
  public List<Path> getSourcePaths() {
    return sourcePaths;
  }

  /**
   * @return The value of the {@code targets} attribute
   */
  @Override
  public @Nullable SortedSet<ProtocTarget> getTargets() {
    return targets;
  }

  /**
   * @return The value of the {@code sanctionedExecutablePath} attribute
   */
  @Override
  public @Nullable Path getSanctionedExecutablePath() {
    return sanctionedExecutablePath;
  }

  /**
   * This instance is equal to all instances of {@code ImmutableProtocInvocation} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableProtocInvocation
        && equalsByValue((ImmutableProtocInvocation) another);
  }

  private boolean equalsByValue(ImmutableProtocInvocation another) {
    return Objects.equals(protocPath, another.protocPath)
        && fatalWarnings == another.fatalWarnings
        && arguments.equals(another.arguments)
        && environmentVariables.equals(another.environmentVariables)
        && importPaths.equals(another.importPaths)
        && inputDescriptorFiles.equals(another.inputDescriptorFiles)
        && descriptorSourceFiles.equals(another.descriptorSourceFiles)
        && sourcePaths.equals(another.sourcePaths)
        && Objects.equals(targets, another.targets)
        && Objects.equals(sanctionedExecutablePath, another.sanctionedExecutablePath);
  }

  /**
   * Computes a hash code from attributes: {@code protocPath}, {@code fatalWarnings}, {@code arguments}, {@code environmentVariables}, {@code importPaths}, {@code inputDescriptorFiles}, {@code descriptorSourceFiles}, {@code sourcePaths}, {@code targets}, {@code sanctionedExecutablePath}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(protocPath);
    h += (h << 5) + Boolean.hashCode(fatalWarnings);
    h += (h << 5) + arguments.hashCode();
    h += (h << 5) + environmentVariables.hashCode();
    h += (h << 5) + importPaths.hashCode();
    h += (h << 5) + inputDescriptorFiles.hashCode();
    h += (h << 5) + descriptorSourceFiles.hashCode();
    h += (h << 5) + sourcePaths.hashCode();
    h += (h << 5) + Objects.hashCode(targets);
    h += (h << 5) + Objects.hashCode(sanctionedExecutablePath);
    return h;
  }

  /**
   * Prints the immutable value {@code ProtocInvocation} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ProtocInvocation{"
        + "protocPath=" + protocPath
        + ", fatalWarnings=" + fatalWarnings
        + ", arguments=" + arguments
        + ", environmentVariables=" + environmentVariables
        + ", importPaths=" + importPaths
        + ", inputDescriptorFiles=" + inputDescriptorFiles
        + ", descriptorSourceFiles=" + descriptorSourceFiles
        + ", sourcePaths=" + sourcePaths
        + ", targets=" + targets
        + ", sanctionedExecutablePath=" + sanctionedExecutablePath
        + "}";
  }

  /**
   * Creates a builder for {@link ImmutableProtocInvocation ImmutableProtocInvocation}.
   * <pre>
   * ImmutableProtocInvocation.builder()
   *    .protocPath(java.nio.file.Path | null) // nullable {@link ProtocInvocation#getProtocPath() protocPath}
   *    .fatalWarnings(boolean) // required {@link ProtocInvocation#isFatalWarnings() fatalWarnings}
   *    .addArguments|addAllArguments(String) // {@link ProtocInvocation#getArguments() arguments} elements
   *    .putEnvironmentVariables|putAllEnvironmentVariables(String =&gt; String) // {@link ProtocInvocation#getEnvironmentVariables() environmentVariables} mappings
   *    .addImportPaths|addAllImportPaths(java.nio.file.Path) // {@link ProtocInvocation#getImportPaths() importPaths} elements
   *    .addInputDescriptorFiles|addAllInputDescriptorFiles(java.nio.file.Path) // {@link ProtocInvocation#getInputDescriptorFiles() inputDescriptorFiles} elements
   *    .addDescriptorSourceFiles|addAllDescriptorSourceFiles(String) // {@link ProtocInvocation#getDescriptorSourceFiles() descriptorSourceFiles} elements
   *    .addSourcePaths|addAllSourcePaths(java.nio.file.Path) // {@link ProtocInvocation#getSourcePaths() sourcePaths} elements
   *    .targets(SortedSet&lt;io.github.ascopes.protobufmavenplugin.protoc.targets.ProtocTarget&gt; | null) // nullable {@link ProtocInvocation#getTargets() targets}
   *    .sanctionedExecutablePath(java.nio.file.Path | null) // nullable {@link ProtocInvocation#getSanctionedExecutablePath() sanctionedExecutablePath}
   *    .build();
   * </pre>
   * @return A new ImmutableProtocInvocation builder
   */
  public static ImmutableProtocInvocation.Builder builder() {
    return new ImmutableProtocInvocation.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableProtocInvocation ImmutableProtocInvocation}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ProtocInvocation", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_PROTOC_PATH = 0x1L;
    private static final long INIT_BIT_FATAL_WARNINGS = 0x2L;
    private static final long INIT_BIT_TARGETS = 0x4L;
    private long initBits = 0x7L;

    private @Nullable Path protocPath;
    private boolean fatalWarnings;
    private @Nullable List<String> arguments = null;
    private @Nullable Map<String, String> environmentVariables = null;
    private @Nullable List<Path> importPaths = null;
    private @Nullable List<Path> inputDescriptorFiles = null;
    private @Nullable List<String> descriptorSourceFiles = null;
    private @Nullable List<Path> sourcePaths = null;
    private @Nullable SortedSet<ProtocTarget> targets;
    private @Nullable Path sanctionedExecutablePath;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ProtocInvocation} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ProtocInvocation instance) {
      Objects.requireNonNull(instance, "instance");
      Path protocPathValue = instance.getProtocPath();
      if (protocPathValue != null) {
        protocPath(protocPathValue);
      }
      this.fatalWarnings(instance.isFatalWarnings());
      addAllArguments(instance.getArguments());
      putAllEnvironmentVariables(instance.getEnvironmentVariables());
      addAllImportPaths(instance.getImportPaths());
      addAllInputDescriptorFiles(instance.getInputDescriptorFiles());
      addAllDescriptorSourceFiles(instance.getDescriptorSourceFiles());
      addAllSourcePaths(instance.getSourcePaths());
      SortedSet<ProtocTarget> targetsValue = instance.getTargets();
      if (targetsValue != null) {
        targets(targetsValue);
      }
      @Nullable Path sanctionedExecutablePathValue = instance.getSanctionedExecutablePath();
      if (sanctionedExecutablePathValue != null) {
        sanctionedExecutablePath(sanctionedExecutablePathValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ProtocInvocation#getProtocPath() protocPath} attribute.
     * @param protocPath The value for protocPath (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder protocPath(Path protocPath) {
      this.protocPath = protocPath;
      initBits &= ~INIT_BIT_PROTOC_PATH;
      return this;
    }

    /**
     * Initializes the value for the {@link ProtocInvocation#isFatalWarnings() fatalWarnings} attribute.
     * @param fatalWarnings The value for fatalWarnings 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder fatalWarnings(boolean fatalWarnings) {
      this.fatalWarnings = fatalWarnings;
      initBits &= ~INIT_BIT_FATAL_WARNINGS;
      return this;
    }

    /**
     * Adds one element to {@link ProtocInvocation#getArguments() arguments} list.
     * @param element A arguments element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addArguments(@Nullable String element) {
      if (this.arguments == null) {
        this.arguments = new ArrayList<String>();
      }
      this.arguments.add(element);
      return this;
    }

    /**
     * Adds elements to {@link ProtocInvocation#getArguments() arguments} list.
     * @param elements An array of arguments elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addArguments(@Nullable String... elements) {
      if (this.arguments == null) {
        this.arguments = new ArrayList<String>();
      }
      for (String element : elements) {
        this.arguments.add(element);
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ProtocInvocation#getArguments() arguments} list.
     * @param elements An iterable of arguments elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder arguments(Iterable<@Nullable String> elements) {
      this.arguments = new ArrayList<String>();
      return addAllArguments(elements);
    }

    /**
     * Adds elements to {@link ProtocInvocation#getArguments() arguments} list.
     * @param elements An iterable of arguments elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllArguments(Iterable<@Nullable String> elements) {
      Objects.requireNonNull(elements, "arguments element");
      if (this.arguments == null) {
        this.arguments = new ArrayList<String>();
      }
      for (String element : elements) {
        this.arguments.add(element);
      }
      return this;
    }

    /**
     * Put one entry to the {@link ProtocInvocation#getEnvironmentVariables() environmentVariables} map.
     * @param key The key in the environmentVariables map
     * @param value The associated value in the environmentVariables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putEnvironmentVariables(@Nullable String key, @Nullable String value) {
      if (this.environmentVariables == null) {
        this.environmentVariables = new LinkedHashMap<String, String>();
      }
      this.environmentVariables.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link ProtocInvocation#getEnvironmentVariables() environmentVariables} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putEnvironmentVariables(Map.Entry<@Nullable String, ? extends @Nullable String> entry) {
      if (this.environmentVariables == null) {
        this.environmentVariables = new LinkedHashMap<String, String>();
      }
      String k = entry.getKey();
      @Nullable String v = entry.getValue();
      this.environmentVariables.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ProtocInvocation#getEnvironmentVariables() environmentVariables} map. Nulls are not permitted
     * @param entries The entries that will be added to the environmentVariables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder environmentVariables(Map<@Nullable String, ? extends @Nullable String> entries) {
      this.environmentVariables = new LinkedHashMap<String, String>();
      return putAllEnvironmentVariables(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ProtocInvocation#getEnvironmentVariables() environmentVariables} map. Nulls are not permitted
     * @param entries The entries that will be added to the environmentVariables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllEnvironmentVariables(Map<@Nullable String, ? extends @Nullable String> entries) {
      if (this.environmentVariables == null) {
        this.environmentVariables = new LinkedHashMap<String, String>();
      }
      for (Map.Entry<@Nullable String, ? extends @Nullable String> e : entries.entrySet()) {
        String k = e.getKey();
        @Nullable String v = e.getValue();
        this.environmentVariables.put(k, v);
      }
      return this;
    }

    /**
     * Adds one element to {@link ProtocInvocation#getImportPaths() importPaths} list.
     * @param element A importPaths element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addImportPaths(@Nullable Path element) {
      if (this.importPaths == null) {
        this.importPaths = new ArrayList<Path>();
      }
      this.importPaths.add(element);
      return this;
    }

    /**
     * Adds elements to {@link ProtocInvocation#getImportPaths() importPaths} list.
     * @param elements An array of importPaths elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addImportPaths(@Nullable Path... elements) {
      if (this.importPaths == null) {
        this.importPaths = new ArrayList<Path>();
      }
      for (Path element : elements) {
        this.importPaths.add(element);
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ProtocInvocation#getImportPaths() importPaths} list.
     * @param elements An iterable of importPaths elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder importPaths(Iterable<? extends @Nullable Path> elements) {
      this.importPaths = new ArrayList<Path>();
      return addAllImportPaths(elements);
    }

    /**
     * Adds elements to {@link ProtocInvocation#getImportPaths() importPaths} list.
     * @param elements An iterable of importPaths elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllImportPaths(Iterable<? extends @Nullable Path> elements) {
      Objects.requireNonNull(elements, "importPaths element");
      if (this.importPaths == null) {
        this.importPaths = new ArrayList<Path>();
      }
      for (Path element : elements) {
        this.importPaths.add(element);
      }
      return this;
    }

    /**
     * Adds one element to {@link ProtocInvocation#getInputDescriptorFiles() inputDescriptorFiles} list.
     * @param element A inputDescriptorFiles element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addInputDescriptorFiles(@Nullable Path element) {
      if (this.inputDescriptorFiles == null) {
        this.inputDescriptorFiles = new ArrayList<Path>();
      }
      this.inputDescriptorFiles.add(element);
      return this;
    }

    /**
     * Adds elements to {@link ProtocInvocation#getInputDescriptorFiles() inputDescriptorFiles} list.
     * @param elements An array of inputDescriptorFiles elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addInputDescriptorFiles(@Nullable Path... elements) {
      if (this.inputDescriptorFiles == null) {
        this.inputDescriptorFiles = new ArrayList<Path>();
      }
      for (Path element : elements) {
        this.inputDescriptorFiles.add(element);
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ProtocInvocation#getInputDescriptorFiles() inputDescriptorFiles} list.
     * @param elements An iterable of inputDescriptorFiles elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder inputDescriptorFiles(Iterable<? extends @Nullable Path> elements) {
      this.inputDescriptorFiles = new ArrayList<Path>();
      return addAllInputDescriptorFiles(elements);
    }

    /**
     * Adds elements to {@link ProtocInvocation#getInputDescriptorFiles() inputDescriptorFiles} list.
     * @param elements An iterable of inputDescriptorFiles elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllInputDescriptorFiles(Iterable<? extends @Nullable Path> elements) {
      Objects.requireNonNull(elements, "inputDescriptorFiles element");
      if (this.inputDescriptorFiles == null) {
        this.inputDescriptorFiles = new ArrayList<Path>();
      }
      for (Path element : elements) {
        this.inputDescriptorFiles.add(element);
      }
      return this;
    }

    /**
     * Adds one element to {@link ProtocInvocation#getDescriptorSourceFiles() descriptorSourceFiles} list.
     * @param element A descriptorSourceFiles element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addDescriptorSourceFiles(@Nullable String element) {
      if (this.descriptorSourceFiles == null) {
        this.descriptorSourceFiles = new ArrayList<String>();
      }
      this.descriptorSourceFiles.add(element);
      return this;
    }

    /**
     * Adds elements to {@link ProtocInvocation#getDescriptorSourceFiles() descriptorSourceFiles} list.
     * @param elements An array of descriptorSourceFiles elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addDescriptorSourceFiles(@Nullable String... elements) {
      if (this.descriptorSourceFiles == null) {
        this.descriptorSourceFiles = new ArrayList<String>();
      }
      for (String element : elements) {
        this.descriptorSourceFiles.add(element);
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ProtocInvocation#getDescriptorSourceFiles() descriptorSourceFiles} list.
     * @param elements An iterable of descriptorSourceFiles elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder descriptorSourceFiles(Iterable<@Nullable String> elements) {
      this.descriptorSourceFiles = new ArrayList<String>();
      return addAllDescriptorSourceFiles(elements);
    }

    /**
     * Adds elements to {@link ProtocInvocation#getDescriptorSourceFiles() descriptorSourceFiles} list.
     * @param elements An iterable of descriptorSourceFiles elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllDescriptorSourceFiles(Iterable<@Nullable String> elements) {
      Objects.requireNonNull(elements, "descriptorSourceFiles element");
      if (this.descriptorSourceFiles == null) {
        this.descriptorSourceFiles = new ArrayList<String>();
      }
      for (String element : elements) {
        this.descriptorSourceFiles.add(element);
      }
      return this;
    }

    /**
     * Adds one element to {@link ProtocInvocation#getSourcePaths() sourcePaths} list.
     * @param element A sourcePaths element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addSourcePaths(@Nullable Path element) {
      if (this.sourcePaths == null) {
        this.sourcePaths = new ArrayList<Path>();
      }
      this.sourcePaths.add(element);
      return this;
    }

    /**
     * Adds elements to {@link ProtocInvocation#getSourcePaths() sourcePaths} list.
     * @param elements An array of sourcePaths elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addSourcePaths(@Nullable Path... elements) {
      if (this.sourcePaths == null) {
        this.sourcePaths = new ArrayList<Path>();
      }
      for (Path element : elements) {
        this.sourcePaths.add(element);
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ProtocInvocation#getSourcePaths() sourcePaths} list.
     * @param elements An iterable of sourcePaths elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder sourcePaths(Iterable<? extends @Nullable Path> elements) {
      this.sourcePaths = new ArrayList<Path>();
      return addAllSourcePaths(elements);
    }

    /**
     * Adds elements to {@link ProtocInvocation#getSourcePaths() sourcePaths} list.
     * @param elements An iterable of sourcePaths elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSourcePaths(Iterable<? extends @Nullable Path> elements) {
      Objects.requireNonNull(elements, "sourcePaths element");
      if (this.sourcePaths == null) {
        this.sourcePaths = new ArrayList<Path>();
      }
      for (Path element : elements) {
        this.sourcePaths.add(element);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ProtocInvocation#getTargets() targets} attribute.
     * @param targets The value for targets (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder targets(SortedSet<ProtocTarget> targets) {
      this.targets = targets;
      initBits &= ~INIT_BIT_TARGETS;
      return this;
    }

    /**
     * Initializes the value for the {@link ProtocInvocation#getSanctionedExecutablePath() sanctionedExecutablePath} attribute.
     * @param sanctionedExecutablePath The value for sanctionedExecutablePath (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder sanctionedExecutablePath(@Nullable Path sanctionedExecutablePath) {
      this.sanctionedExecutablePath = sanctionedExecutablePath;
      return this;
    }

    /**
     * Builds a new {@link ImmutableProtocInvocation ImmutableProtocInvocation}.
     * @return An immutable instance of ProtocInvocation
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableProtocInvocation build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableProtocInvocation(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_PROTOC_PATH) != 0) attributes.add("protocPath");
      if ((initBits & INIT_BIT_FATAL_WARNINGS) != 0) attributes.add("fatalWarnings");
      if ((initBits & INIT_BIT_TARGETS) != 0) attributes.add("targets");
      return "Cannot build ProtocInvocation, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<? extends T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size() * 4 / 3 + 1);
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
